/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.jvnet.flamingo.common.StackIcon;
import org.jvnet.flamingo.ribbon.GalleryElementState;
import org.jvnet.flamingo.ribbon.JBandControlPanel;
import org.jvnet.flamingo.ribbon.JRibbonBand;
import org.jvnet.flamingo.ribbon.JRibbonButton;
import org.jvnet.flamingo.ribbon.gallery.JPopupGallery;
import org.jvnet.flamingo.ribbon.ui.BasicBandControlPanelUI;
import org.jvnet.flamingo.ribbon.ui.RibbonBandUI;

public class BasicRibbonBandUI
extends RibbonBandUI {
    public static final int BAND_HEADER_HEIGHT = 18;
    public static final int BAND_CONTROL_PANEL_HEIGHT = 68;
    protected JRibbonBand ribbonBand;
    protected JRibbonButton collapsedButton;
    protected JRibbonBand.RibbonBandCollapseKind currentFitCollapse;
    protected AbstractButton expandButton;
    protected boolean isUnderMouse;
    protected MouseListener mouseListener;
    protected ActionListener expandButtonActionListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonBandUI();
    }

    public void installUI(JComponent c) {
        this.ribbonBand = (JRibbonBand)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        c.setLayout(this.createLayoutManager());
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.ribbonBand, "RibbonBand.background", "RibbonBand.foreground", "RibbonBand.font");
        LookAndFeel.installBorder(this.ribbonBand, "RibbonBand.border");
    }

    protected void installComponents() {
        StackIcon icon = new StackIcon(this.ribbonBand.getIcon(), 0.25);
        this.collapsedButton = new JRibbonButton(null, this.ribbonBand.getTitle(), icon, icon);
        this.collapsedButton.setState(GalleryElementState.BIG, true);
        this.ribbonBand.add(this.collapsedButton);
        if (this.ribbonBand.getExpandActionListener() != null) {
            this.expandButton = this.createExpandButton();
            this.ribbonBand.add(this.expandButton);
        }
    }

    protected AbstractButton createExpandButton() {
        JButton result = new JButton(UIManager.getIcon("RibbonBand.expandIcon"));
        result.setPreferredSize(new Dimension(result.getIcon().getIconWidth() + 4, result.getIcon().getIconHeight() + 4));
        return result;
    }

    protected void installListeners() {
        this.mouseListener = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                BasicRibbonBandUI.this.isUnderMouse = true;
                BasicRibbonBandUI.this.ribbonBand.repaint();
            }

            public void mouseExited(MouseEvent e) {
                if (BasicRibbonBandUI.this.ribbonBand.contains(e.getPoint())) {
                    return;
                }
                BasicRibbonBandUI.this.isUnderMouse = false;
                BasicRibbonBandUI.this.ribbonBand.repaint();
            }
        };
        this.ribbonBand.addMouseListener(this.mouseListener);
        if (this.expandButton != null) {
            this.expandButton.addActionListener(this.ribbonBand.getExpandActionListener());
            this.expandButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BasicRibbonBandUI.this.isUnderMouse = false;
                            if (BasicRibbonBandUI.this.ribbonBand != null) {
                                BasicRibbonBandUI.this.ribbonBand.repaint();
                            }
                        }
                    });
                }
            };
            this.expandButton.addActionListener(this.expandButtonActionListener);
        }
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.ribbonBand);
    }

    protected void uninstallComponents() {
        JPopupGallery popupGallery;
        if (this.collapsedButton.isVisible() && (popupGallery = this.collapsedButton.getGallery()) != null) {
            JBandControlPanel panelFromPopup = (JBandControlPanel)this.collapsedButton.getGallery().removeComponent();
            this.ribbonBand.setControlPanel(panelFromPopup);
            this.collapsedButton.setGallery(null);
        }
        this.ribbonBand.remove(this.collapsedButton);
        this.collapsedButton = null;
        if (this.expandButton != null) {
            this.ribbonBand.remove(this.expandButton);
        }
        this.expandButton = null;
        this.ribbonBand = null;
    }

    protected void uninstallListeners() {
        this.ribbonBand.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
        if (this.expandButton != null) {
            this.expandButton.removeActionListener(this.expandButtonActionListener);
            this.expandButtonActionListener = null;
            this.expandButton.removeActionListener(this.ribbonBand.getExpandActionListener());
        }
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonBandLayout();
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.currentFitCollapse != JRibbonBand.RibbonBandCollapseKind.ICON) {
            String title = this.ribbonBand.getTitle();
            this.paintBandTitle(graphics, new Rectangle(0, 0, c.getWidth(), 18), title);
        }
        this.paintBandBackground(graphics, new Rectangle(0, 18, c.getWidth(), 68));
        graphics.dispose();
    }

    protected void paintBandTitle(Graphics g, Rectangle titleRectangle, String title) {
        Graphics2D graphics = (Graphics2D)g.create();
        Color ribbonBandBackground = this.ribbonBand.getBackground();
        double topCoef = this.isUnderMouse ? 0.4 : 0.28;
        double bottomCoef = this.isUnderMouse ? 0.6 : 0.4;
        Color topColor = new Color((int)(topCoef * (double)ribbonBandBackground.getRed()), (int)(topCoef * (double)ribbonBandBackground.getGreen()), (int)(topCoef * (double)ribbonBandBackground.getBlue()));
        Color bottomColor = new Color((int)(bottomCoef * (double)ribbonBandBackground.getRed()), (int)(bottomCoef * (double)ribbonBandBackground.getGreen()), (int)(bottomCoef * (double)ribbonBandBackground.getBlue()));
        graphics.setPaint(new GradientPaint(titleRectangle.x, titleRectangle.y, topColor, titleRectangle.x, titleRectangle.y + titleRectangle.height, bottomColor));
        graphics.fillRect(titleRectangle.x, titleRectangle.y, titleRectangle.width, titleRectangle.height);
        graphics.setFont(new Font("Tahoma", 1, 11));
        int y = titleRectangle.y + (titleRectangle.height + graphics.getFontMetrics().getAscent()) / 2;
        graphics.setColor(topColor);
        graphics.drawString(title, titleRectangle.x + 3, y);
        graphics.setColor(ribbonBandBackground);
        graphics.drawString(title, titleRectangle.x + 2, y - 1);
        graphics.dispose();
    }

    protected void paintBandBackground(Graphics graphics, Rectangle toFill) {
        graphics.setColor(this.ribbonBand.getBackground());
        graphics.fillRect(toFill.x, toFill.y, toFill.width, toFill.height);
    }

    public int getPreferredWidth(JRibbonBand.RibbonBandCollapseKind collapseKind) {
        if (collapseKind == JRibbonBand.RibbonBandCollapseKind.ICON) {
            return this.collapsedButton.getPreferredSize().width + 2;
        }
        JBandControlPanel controlPanel = this.ribbonBand.getControlPanel();
        if (controlPanel == null) {
            JPopupGallery gallery = this.collapsedButton.getGallery();
            controlPanel = (JBandControlPanel)gallery.getComponent();
        }
        BasicBandControlPanelUI baseUI = (BasicBandControlPanelUI)controlPanel.getUI();
        return baseUI.getPreferredWidth(collapseKind);
    }

    public AbstractButton getExpandButton() {
        return this.expandButton;
    }

    private class RibbonBandLayout
    implements LayoutManager {
        private RibbonBandLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int width = BasicRibbonBandUI.this.ribbonBand.getControlPanel().isVisible() ? BasicRibbonBandUI.this.collapsedButton.getPreferredSize().width : BasicRibbonBandUI.this.ribbonBand.getControlPanel().getPreferredSize().width;
            return new Dimension(width + 2, 86);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            JPopupGallery popupGallery;
            if (!c.isVisible()) {
                return;
            }
            JRibbonBand.RibbonBandCollapseKind bestFitCollapse = JRibbonBand.RibbonBandCollapseKind.getSortedKinds().getLast();
            for (JRibbonBand.RibbonBandCollapseKind collapseKind : JRibbonBand.RibbonBandCollapseKind.getSortedKinds()) {
                int collapsedWidth = BasicRibbonBandUI.this.getPreferredWidth(collapseKind);
                if (collapsedWidth >= c.getWidth()) continue;
                bestFitCollapse = collapseKind;
                break;
            }
            BasicRibbonBandUI.this.currentFitCollapse = bestFitCollapse;
            if (bestFitCollapse == JRibbonBand.RibbonBandCollapseKind.ICON) {
                BasicRibbonBandUI.this.collapsedButton.setVisible(true);
                int w = BasicRibbonBandUI.this.collapsedButton.getPreferredSize().width;
                BasicRibbonBandUI.this.collapsedButton.setBounds((c.getWidth() - w) / 2, 18, w, 68);
                Dimension size = new Dimension(4 + BasicRibbonBandUI.this.getPreferredWidth(JRibbonBand.RibbonBandCollapseKind.NONE), 72);
                if (BasicRibbonBandUI.this.collapsedButton.getGallery() == null) {
                    BasicRibbonBandUI.this.collapsedButton.setGallery(new JPopupGallery(BasicRibbonBandUI.this.ribbonBand.getControlPanel(), size));
                    BasicRibbonBandUI.this.ribbonBand.setControlPanel(null);
                }
                return;
            }
            if (BasicRibbonBandUI.this.collapsedButton.isVisible() && (popupGallery = BasicRibbonBandUI.this.collapsedButton.getGallery()) != null) {
                JBandControlPanel panelFromPopup = (JBandControlPanel)BasicRibbonBandUI.this.collapsedButton.getGallery().removeComponent();
                BasicRibbonBandUI.this.ribbonBand.setControlPanel(panelFromPopup);
                BasicRibbonBandUI.this.collapsedButton.setGallery(null);
            }
            BasicRibbonBandUI.this.collapsedButton.setVisible(false);
            JBandControlPanel controlPanel = BasicRibbonBandUI.this.ribbonBand.getControlPanel();
            controlPanel.setVisible(true);
            controlPanel.setBounds(1, 18, c.getWidth() - 2, 67);
            controlPanel.doLayout();
        }
    }
}

