/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.svg;

import java.awt.Dimension;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.util.EventDispatcher;
import org.jvnet.flamingo.common.AsynchronousLoadListener;
import org.jvnet.flamingo.common.AsynchronousLoading;
import org.jvnet.flamingo.common.ResizableIcon;
import org.jvnet.flamingo.svg.SvgBatikIcon;

public class SvgBatikResizableIcon
extends SvgBatikIcon
implements ResizableIcon,
AsynchronousLoading {
    private Dimension initialDim;
    protected List asyncListeners = Collections.synchronizedList(new LinkedList());
    static EventDispatcher.Dispatcher asyncCompletedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((AsynchronousLoadListener)listener).completed((Boolean)event);
        }
    };

    public SvgBatikResizableIcon(URL location, Dimension initialDim) {
        super(location.toString(), initialDim.width, initialDim.height);
        this.initialDim = initialDim;
        this.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                SvgBatikResizableIcon.this.fireAsyncEvent(asyncCompletedDispatcher, true);
            }

            public void gvtRenderingFailed(GVTTreeRendererEvent arg0) {
                SvgBatikResizableIcon.this.fireAsyncEvent(asyncCompletedDispatcher, false);
            }
        });
    }

    public void revertToOriginalDimension() {
        this.setPreferredSize(this.initialDim);
    }

    public void setDimension(Dimension dim) {
        this.setPreferredSize(dim);
    }

    public void setHeight(int height) {
        this.setPreferredSize(new Dimension(height, height));
    }

    public void setWidth(int width) {
        this.setPreferredSize(new Dimension(width, width));
    }

    public void addAsynchronousLoadListener(AsynchronousLoadListener l) {
        this.asyncListeners.add(l);
    }

    public void removeAsynchronousLoadListener(AsynchronousLoadListener l) {
        this.asyncListeners.remove(l);
    }

    protected boolean renderGVTTree() {
        boolean cached = super.renderGVTTree();
        if (cached) {
            this.fireAsyncEvent(asyncCompletedDispatcher, true);
        }
        return cached;
    }

    public void fireAsyncEvent(EventDispatcher.Dispatcher dispatcher, Object event) {
        EventDispatcher.fireEvent((EventDispatcher.Dispatcher)dispatcher, (List)this.asyncListeners, (Object)event, (boolean)true);
    }
}

