/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.shell;

import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.command.IdCallback;
import ddb.dsz.core.connection.ConnectionChangeEvent;
import ddb.dsz.core.connection.events.NewHostEvent;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.controller.DispatcherException;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.internalcommand.InternalCommandHandler;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.library.console.Console;
import ddb.dsz.plugin.Plugin;
import ddb.dsz.plugin.shell.ShellCompletionAction;
import ddb.dsz.plugin.shell.ShellConfiguration;
import ddb.dsz.plugin.shell.jaxb.shellcommands.ObjectFactory;
import ddb.dsz.plugin.shell.jaxb.shellcommands.ShellMapType;
import ddb.util.JaxbCache;
import ddb.util.Pair;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DszLive(live=true, replay=false)
@DszLogo(value="images/alevt.png")
@DszName(value="Shell")
@DszDescription(value="A command console")
public class Shell
extends Console
implements Plugin,
IdCallback,
FocusListener,
InternalCommandHandler {
    public static final String SHELLSTRS = "Shell/shellStartStrings.xml";
    List<Pair<String, String>> shells = new Vector<Pair<String, String>>();
    boolean started = false;
    JLayeredPane shellDisplay = new JLayeredPane();
    JComponent consoleDisplay;
    ShellConfiguration configDisplay;
    TaskId pendingCommand = null;
    private final Runnable CommandEnded = new Runnable(){

        public void run() {
            Shell.this.commandLine.setEnabled(false);
            if (!Shell.this.started) {
                Shell.this.configDisplay.commandFailed();
                Shell.this.setStatus("Shell command failed");
            } else {
                Shell.this.setStatus("Shell terminated");
            }
        }
    };

    public String getHistory() {
        return "Shell/history.xml";
    }

    public Shell() {
        super.setName("Shell");
        super.setCareAboutLocalEvents(true);
        this.setupBuiltinCommands();
    }

    public boolean startCommand(String string) {
        return this.startCommand(null, string);
    }

    public boolean startCommand(Object object, String string) {
        HostInfo hostInfo = null;
        if (object instanceof String) {
            hostInfo = this.core.getHostById(object.toString());
        } else if (object instanceof HostInfo) {
            hostInfo = (HostInfo)object;
        } else if (object != null) {
            hostInfo = this.core.getHostById("localhost");
        }
        try {
            String string2 = "";
            if (hostInfo != null && hostInfo.isLocal()) {
                string2 = "local ";
            }
            super.clearOutputScreen("");
            this.setStatus("Starting Remote Shell");
            this.core.startCommand(string2 + string, (IdCallback)this, (Object)this, null);
            if (hostInfo != null) {
                this.setHost(hostInfo);
            }
            return true;
        }
        catch (DispatcherException dispatcherException) {
            this.core.logEvent(Level.INFO, dispatcherException.getMessage(), (Throwable)dispatcherException);
            this.configDisplay.commandFailed();
            this.setStatus("");
            return false;
        }
    }

    protected void fini3() {
        Task task = this.core.getRunningTaskById(this.pendingCommand);
        if (task != null) {
            try {
                this.core.startCommand("stop " + task.getId().getId(), null, null, this.target);
            }
            catch (DispatcherException dispatcherException) {
                this.core.logEvent(Level.WARNING, "Unable to stop shell program", (Throwable)dispatcherException);
            }
        }
    }

    protected String getConsoleLogName() {
        return "Shell-screen";
    }

    protected void setupCommandLineSpecificActionMaps() {
        super.setupCommandLineSpecificActionMaps();
        ActionMap actionMap = this.commandLine.getActionMap();
        actionMap.put("complete", (Action)((Object)new ShellCompletionAction(this, this.commandSet)));
    }

    protected int init3() {
        this.consoleDisplay = this.mainDisplayPanel;
        this.configDisplay = new ShellConfiguration(this);
        this.configDisplay.configureMaps(this.core);
        super.setDisplay((JComponent)this.shellDisplay);
        this.shellDisplay.add((Component)this.consoleDisplay, JLayeredPane.DEFAULT_LAYER);
        this.shellDisplay.add((Component)this.configDisplay, JLayeredPane.MODAL_LAYER);
        this.consoleDisplay.setVisible(false);
        this.configDisplay.setVisible(true);
        this.configDisplay.showUser(false);
        this.shellDisplay.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
                this.event();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                this.event();
            }

            public void componentResized(ComponentEvent componentEvent) {
                this.event();
            }

            public void componentShown(ComponentEvent componentEvent) {
                this.event();
            }

            private void event() {
                Shell.this.consoleDisplay.setBounds(new Rectangle(Shell.this.shellDisplay.getWidth(), Shell.this.shellDisplay.getHeight()));
                Rectangle rectangle = new Rectangle(Shell.this.configDisplay.getPreferredSize().width, Shell.this.configDisplay.getPreferredSize().height);
                int n = Shell.this.shellDisplay.getWidth() - rectangle.width;
                int n2 = Shell.this.shellDisplay.getHeight() - rectangle.height;
                rectangle.x = n / 2;
                rectangle.y = n2 / 2;
                Shell.this.configDisplay.setBounds(rectangle);
                Shell.this.shellDisplay.validate();
            }
        });
        JButton jButton = new JButton("New...");
        this.southPanel.add((Component)jButton, "East");
        try {
            JAXBElement jAXBElement;
            Object object;
            JAXBContext jAXBContext = JaxbCache.getContext(ObjectFactory.class);
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            URL uRL = this.getClass().getClassLoader().getResource(SHELLSTRS);
            if (uRL != null && (object = unmarshaller.unmarshal(uRL)) instanceof JAXBElement && (jAXBElement = (JAXBElement)object).getValue() instanceof ShellMapType) {
                ShellMapType shellMapType = (ShellMapType)jAXBElement.getValue();
                this.configDisplay.addAllSystems(shellMapType.getSystem());
            }
        }
        catch (JAXBException jAXBException) {
            this.core.logEvent(Level.WARNING, jAXBException.getMessage(), (Throwable)jAXBException);
        }
        this.configDisplay.addAllHosts(this.core.getHosts());
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<String> list = Shell.this.configDisplay.getConfiguration();
                list.add("-stealfocus");
                Shell.this.startNewPluginWithInitArgs(Shell.this.getClass(), list);
            }
        });
        return 0;
    }

    protected boolean parseArgument3(String string, String string2) {
        if (string.equals("-stealfocus")) {
            this.core.StealFocus((Plugin)this);
            return true;
        }
        return this.configDisplay.parseArgument(string, string2);
    }

    public void startNewPluginWithInitArgs(Class<?> clazz, List<String> list) {
        this.core.startNewPlugin(clazz, this.getName(), list, this.detached, true);
    }

    protected void commandEnded(CommandEvent commandEvent) {
        super.commandEnded(commandEvent);
        if (commandEvent.getId().equals((Object)this.pendingCommand)) {
            this.pendingCommand = null;
            EventQueue.invokeLater(this.CommandEnded);
        }
    }

    public void startPromptReceived(CommandEvent commandEvent) {
        EventQueue.invokeLater(new ShellStartPromptReceived(commandEvent));
    }

    public void connectionChanged(ConnectionChangeEvent connectionChangeEvent) {
        super.connectionChanged(connectionChangeEvent);
        if (connectionChangeEvent instanceof NewHostEvent) {
            NewHostEvent newHostEvent = (NewHostEvent)connectionChangeEvent;
            this.configDisplay.addNewHost(newHostEvent.getHost());
        }
        if (CoreController.OperationState.Inactive.equals((Object)this.core.getOperationState())) {
            this.configDisplay.disconnected();
        }
    }

    public void idAcquired(TaskId taskId, Object object) {
        super.idAcquired(taskId, object);
        this.pendingCommand = taskId;
    }

    public HostInfo getHostById(String string) {
        return this.core.getHostById(string);
    }

    public JComponent getDefaultElement() {
        if (this.started) {
            return this.commandLine;
        }
        return this.configDisplay.getDefaultElement();
    }

    public class ShellStartPromptReceived
    extends Console.StartPromptReceived
    implements Runnable {
        public ShellStartPromptReceived(CommandEvent commandEvent) {
            super((Console)Shell.this, commandEvent);
            this.e = commandEvent;
        }

        public void run() {
            super.run();
            if (this.e.getId().equals((Object)Shell.this.pendingCommand) && !Shell.this.started) {
                Shell.this.started = true;
                Shell.this.commandLine.setEnabled(true);
                Shell.this.consoleDisplay.setVisible(true);
                Shell.this.configDisplay.setVisible(false);
                Shell.this.shellDisplay.validate();
                Shell.this.commandLine.requestFocusInWindow();
                Task task = Shell.this.core.getTaskById(this.e.getId());
                if (task != null) {
                    Shell.this.setStatus(task.getTypedCommand());
                    Shell.this.setHost(task.getHost());
                }
            }
        }
    }
}

