/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.shell;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.plugin.shell.Shell;
import ddb.dsz.plugin.shell.jaxb.shellcommands.SystemType;
import ddb.swing.DszTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellConfiguration
extends JPanel {
    Shell owner;
    Component[] disable;
    DefaultComboBoxModel model = new DefaultComboBoxModel();
    List<SystemType> systems = new Vector<SystemType>();
    Predicate uniqueHost = PredicateUtils.uniquePredicate();
    ListCellRenderer hostRenderer = new DefaultListCellRenderer(){

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = "";
            String string2 = "??";
            String string3 = "000000";
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                if (object instanceof HostInfo) {
                    HostInfo hostInfo = (HostInfo)object;
                    string = hostInfo.getId();
                    if (hostInfo.isLocal()) {
                        string2 = "Local";
                        string3 = "ff0000";
                    } else {
                        string2 = "Remote";
                    }
                } else {
                    string = object != null ? object.toString() : "Unknown";
                }
                jLabel.setText(String.format("<html><b>%s</b> - <font color=\"#%s\">%s</font></html>", string, string3, string2));
            }
            return component;
        }
    };
    BasicComboBoxEditor comboBoxEditor = new BasicComboBoxEditor(){

        public void setItem(Object object) {
            if (object instanceof HostInfo) {
                super.setItem(((HostInfo)HostInfo.class.cast(object)).getId());
            } else {
                super.setItem(object);
            }
        }

        public Object getItem() {
            return super.getItem();
        }
    };
    private JCheckBox bAllowDszCommands;
    private JTextField commandField;
    private JLabel commandLabel;
    private JTextField groupField;
    private JLabel groupLabel;
    private JTextField initialInputField;
    private JLabel initialInputLabel;
    private JComboBox inputField;
    private JLabel inputLabel;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JLabel osDisplay;
    private JComboBox outputField;
    private JLabel outputLabel;
    private JButton startButton;
    private JComboBox targetField;
    private JTextField userField;
    private JLabel userLabel;
    private JTextField workingField;
    private JLabel workingLabel;
    public static final String ALLOW_DSZ = "-dsz";
    public static final String COMMAND = "-cmd";
    public static final String GROUP = "-group";
    public static final String INITIALINPUT = "-initial";
    public static final String OUTPUT = "-output";
    public static final String TARGET = "-target";
    public static final String USER = "-user";
    public static final String WORKING = "-working";

    public ShellConfiguration(Shell shell) {
        this.initComponents();
        this.owner = shell;
        this.disable = new Component[]{this.commandField, this.groupField, this.initialInputField, this.inputField, this.outputField, this.startButton, this.userField, this.workingField, this.comboBoxEditor.getEditorComponent(), this.bAllowDszCommands};
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.targetField = new JComboBox();
        this.jPanel3 = new JPanel();
        this.commandLabel = new JLabel();
        this.commandField = new DszTextField("Shell Program");
        this.initialInputLabel = new JLabel();
        this.initialInputField = new JTextField();
        this.outputLabel = new JLabel();
        this.outputField = new JComboBox();
        this.workingLabel = new JLabel();
        this.workingField = new DszTextField("Working Directory");
        this.userLabel = new JLabel();
        this.userField = new JTextField();
        this.groupLabel = new JLabel();
        this.groupField = new JTextField();
        this.bAllowDszCommands = new JCheckBox();
        this.startButton = new JButton();
        this.inputLabel = new JLabel();
        this.inputField = new JComboBox();
        this.osDisplay = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 2));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Target:"));
        this.targetField.setEditable(true);
        this.targetField.setModel(this.model);
        this.targetField.setEditor(this.comboBoxEditor);
        this.targetField.setPrototypeDisplayValue("123.456.789.012");
        this.targetField.setRenderer(this.hostRenderer);
        this.targetField.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ShellConfiguration.this.targetSelected(itemEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.targetField, 0, 142, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.targetField, -2, -1, -2));
        this.commandLabel.setText("Command:");
        this.initialInputLabel.setText("Initial Input:");
        this.outputLabel.setText("Output Format:");
        this.outputField.setModel(new DefaultComboBoxModel<String>(new String[]{"ascii", "oem", "unicode", "utf8"}));
        this.outputField.setSelectedItem(null);
        this.workingLabel.setText("Working Directory:");
        this.userLabel.setText("User:");
        this.groupLabel.setText("Group:");
        this.bAllowDszCommands.setText("Allow Dsz Commands");
        this.startButton.setText("Start Shell");
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShellConfiguration.this.startButtonActionPerformed(actionEvent);
            }
        });
        this.inputLabel.setText("Input Format:");
        this.inputField.setModel(new DefaultComboBoxModel<String>(new String[]{"ascii", "oem", "unicode", "utf8"}));
        this.inputField.setSelectedItem(null);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.commandLabel).add((Component)this.initialInputLabel).add((Component)this.workingLabel).add((Component)this.inputLabel).add((Component)this.outputLabel).add((Component)this.userLabel).add((Component)this.groupLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.commandField, -1, 293, Short.MAX_VALUE).add((Component)this.initialInputField, -1, 293, Short.MAX_VALUE).add((Component)this.workingField, -1, 293, Short.MAX_VALUE).add((Component)this.inputField, 0, 293, Short.MAX_VALUE).add((Component)this.outputField, 0, 293, Short.MAX_VALUE).add((Component)this.userField, -1, 293, Short.MAX_VALUE).add((Component)this.groupField, -1, 293, Short.MAX_VALUE)).addContainerGap()).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.bAllowDszCommands).addPreferredGap(0, 183, Short.MAX_VALUE).add((Component)this.startButton).addContainerGap(10, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.commandLabel).add((Component)this.commandField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.initialInputLabel).add((Component)this.initialInputField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.workingField, -2, -1, -2).add((Component)this.workingLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.inputLabel).add((Component)this.inputField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.outputLabel).add((Component)this.outputField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.userLabel).add((Component)this.userField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.groupField, -2, -1, -2).add((Component)this.groupLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.bAllowDszCommands).add((Component)this.startButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.osDisplay.setHorizontalAlignment(0);
        this.osDisplay.setText(" ");
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.osDisplay, -1, 239, Short.MAX_VALUE).addContainerGap()).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(21, 21, 21).add((Component)this.osDisplay))).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2)));
    }

    private void startButtonActionPerformed(ActionEvent actionEvent) {
        for (Component component : this.disable) {
            component.setEnabled(false);
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.targetField.getSelectedItem();
        if (object instanceof HostInfo) {
            stringBuilder.append(String.format("dst=%s ", ((HostInfo)HostInfo.class.cast(object)).getId()));
        } else if (object instanceof String) {
            stringBuilder.append(String.format("dst=%s ", object));
        }
        stringBuilder.append("run -command \"" + this.escape(this.commandField.getText().trim()) + "\"");
        if (this.initialInputField.getText().trim().length() > 0) {
            stringBuilder.append(" -redirect \"" + this.escape(this.initialInputField.getText().trim()) + "\"");
        } else {
            stringBuilder.append(" -redirect ");
        }
        if (this.inputField.getSelectedItem() != null) {
            stringBuilder.append(" -input " + this.inputField.getSelectedItem());
        }
        if (this.outputField.getSelectedItem() != null) {
            stringBuilder.append(" -output " + this.outputField.getSelectedItem());
        }
        if (this.workingField.getText().trim().length() > 0) {
            stringBuilder.append(" -directory \"" + this.escape(this.workingField.getText().trim()) + "\"");
        }
        if (this.userField.getText().trim().length() > 0) {
            stringBuilder.append(" -user \"" + this.escape(this.userField.getText().trim()) + "\" \"" + this.escape(this.groupField.getText().trim()) + "\"");
        }
        if (this.bAllowDszCommands.isSelected()) {
            stringBuilder.append(" -allowdsz");
        }
        this.owner.startCommand(this.targetField.getSelectedItem(), stringBuilder.toString());
    }

    private void targetSelected(ItemEvent itemEvent) {
        Object object = this.targetField.getSelectedItem();
        if (object instanceof String) {
            this.targetField.setSelectedItem(this.owner.getHostById(object.toString()));
        } else if (object instanceof HostInfo) {
            HostInfo hostInfo = (HostInfo)object;
            String string = "Local";
            String string2 = "ff0000";
            if (!hostInfo.isLocal()) {
                string = "Remote";
                string2 = "000000";
            }
            this.osDisplay.setText(String.format("<html><b><font color=\"#%s\">%s</font></b>: %s/%s [%s]</html>", string2, string, hostInfo.getPlatform(), hostInfo.getArch(), hostInfo.getVersion()));
            if (hostInfo.getPlatform() != null) {
                for (SystemType systemType : this.systems) {
                    try {
                        if (!hostInfo.getPlatform().matches(systemType.getPlatformRegex())) continue;
                        if (itemEvent != null) {
                            this.commandField.setText(systemType.getCommandLine());
                            this.initialInputField.setText(systemType.getInitialCommand());
                            this.outputField.setSelectedItem(systemType.getOutputFormat());
                            this.workingField.setText(systemType.getWorkingDirectory());
                        }
                        this.showUser(systemType.isEnableUser());
                        this.inputField.setEnabled(systemType.isAdjustableFormat());
                        this.outputField.setEnabled(systemType.isAdjustableFormat());
                        return;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                    }
                }
            }
            this.commandField.setText("");
            this.initialInputField.setText("");
            this.outputField.setSelectedItem("");
            this.workingField.setText("");
            this.showUser(true);
        }
    }

    public void showUser(boolean bl) {
        this.userField.setEnabled(bl);
        this.userLabel.setEnabled(bl);
        this.groupField.setEnabled(bl);
        this.groupLabel.setEnabled(bl);
        this.validate();
    }

    public void commandFailed() {
        for (Component component : this.disable) {
            component.setEnabled(true);
        }
        this.targetSelected(null);
    }

    public String escape(String string) {
        return string.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\\"", "\\\\\"");
    }

    public List<String> getConfiguration() {
        Vector<String> vector = new Vector<String>();
        vector.add(String.format("%s=%s", ALLOW_DSZ, this.bAllowDszCommands.isSelected() ? "true" : "false"));
        vector.add(String.format("%s=%s", COMMAND, this.commandField.getText()));
        vector.add(String.format("%s=%s", GROUP, this.groupField.getText()));
        vector.add(String.format("%s=%s", INITIALINPUT, this.initialInputField.getText()));
        Object object = this.outputField.getSelectedItem();
        if (object instanceof String) {
            vector.add(String.format("%s=%s", OUTPUT, object.toString()));
        }
        if ((object = this.targetField.getSelectedItem()) instanceof String) {
            vector.add(String.format("%s=%s", TARGET, object.toString()));
        } else if (object instanceof HostInfo) {
            vector.add(String.format("%s=%s", TARGET, ((HostInfo)HostInfo.class.cast(object)).getId()));
        }
        vector.add(String.format("%s=%s", USER, this.userField.getText()));
        vector.add(String.format("%s=%s", WORKING, this.workingField.getText()));
        return vector;
    }

    public boolean parseArgument(String string, String string2) {
        if (string.equals(ALLOW_DSZ)) {
            if (string2.equals("true")) {
                this.bAllowDszCommands.setSelected(true);
            } else {
                this.bAllowDszCommands.setSelected(false);
            }
            return true;
        }
        if (string.equals(COMMAND)) {
            this.commandField.setText(string2);
            return true;
        }
        if (string.equals(GROUP)) {
            this.groupField.setText(string2);
            return true;
        }
        if (string.equals(INITIALINPUT)) {
            this.initialInputField.setText(string2);
            return true;
        }
        if (string.equals(OUTPUT)) {
            this.outputField.setSelectedItem(string2);
            return true;
        }
        if (string.equals(TARGET)) {
            this.targetField.setSelectedItem(this.owner.getHostById(string2));
            return true;
        }
        if (string.equals(USER)) {
            this.userField.setText(string2);
            return true;
        }
        if (string.equals(WORKING)) {
            this.workingField.setText(string2);
            return true;
        }
        return false;
    }

    public void addAllSystems(List<SystemType> list) {
        this.systems = list;
    }

    public void addAllHosts(List<HostInfo> list) {
        for (HostInfo hostInfo : list) {
            this.addNewHost(hostInfo);
        }
    }

    public void addNewHost(HostInfo hostInfo) {
        if (this.uniqueHost.evaluate((Object)hostInfo.getId())) {
            this.model.addElement(hostInfo);
            Object object = this.model.getSelectedItem();
            if (object instanceof HostInfo) {
                if (((HostInfo)HostInfo.class.cast(object)).isLocal() && !hostInfo.isLocal()) {
                    this.model.setSelectedItem(hostInfo);
                }
            } else if (object == null) {
                this.model.setSelectedItem(hostInfo);
            }
        }
    }

    public JComponent getDefaultElement() {
        return this.startButton;
    }

    public void configureMaps(CoreController coreController) {
        for (Component component : this.disable) {
            if (!(component instanceof JComponent)) continue;
            coreController.setupKeyBindings((JComponent)component);
        }
    }

    public void disconnected() {
        for (Component component : this.disable) {
            component.setEnabled(false);
        }
    }
}

