/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit.tokenmarker;

import javax.swing.text.Segment;
import org.syntax.jedit.KeywordMap;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class DssTokenMarker
extends TokenMarker {
    private static KeywordMap cKeywords;
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public DssTokenMarker() {
        this(DssTokenMarker.getKeywords());
    }

    public DssTokenMarker(KeywordMap keywordMap) {
        this.keywords = keywordMap;
    }

    public byte markTokensImpl(byte by, Segment segment, int n) {
        int n2;
        char[] cArray = segment.array;
        this.lastOffset = n2 = segment.offset;
        this.lastKeyword = n2;
        int n3 = segment.count + n2;
        boolean bl = false;
        block23: for (int i = n2; i < n3; ++i) {
            int n4 = i + 1;
            char c = cArray[i];
            if (c == '\\') {
                bl = !bl;
                continue;
            }
            switch (by) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (bl) {
                                bl = false;
                            }
                            this.addToken(i - this.lastOffset, by);
                            this.addToken(n3 - i, (byte)1);
                            this.lastOffset = this.lastKeyword = n3;
                            break block23;
                        }
                        case '\"': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '`': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '@': {
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.doKeyword(segment, i, c);
                            this.lastKeyword = i;
                            break;
                        }
                        case '/': {
                            bl = false;
                            this.doKeyword(segment, i, c);
                            if (n3 - i <= 1) continue block23;
                            switch (cArray[n4]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, by);
                                    this.lastOffset = this.lastKeyword = i;
                                    if (n3 - i > 2 && cArray[i + 2] == '*') {
                                        by = (byte)2;
                                        break;
                                    }
                                    by = 1;
                                    break;
                                }
                                case '/': {
                                    this.addToken(i - this.lastOffset, by);
                                    this.addToken(n3 - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = n3;
                                    break block23;
                                }
                            }
                            continue block23;
                        }
                        default: {
                            bl = false;
                            if (Character.isLetterOrDigit(c) || c == '_') continue block23;
                            this.doKeyword(segment, i, c);
                            break;
                        }
                    }
                    continue block23;
                }
                case 1: 
                case 2: {
                    bl = false;
                    if (c != '*' || n3 - i <= 1 || cArray[n4] != '/') continue block23;
                    this.addToken(++i + 1 - this.lastOffset, by);
                    by = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block23;
                }
                case 3: {
                    if (bl) {
                        bl = false;
                        continue block23;
                    }
                    if (c == '\"') {
                        if (cArray[this.lastOffset] != '\"') continue block23;
                        this.addToken(n4 - this.lastOffset, by);
                        by = 0;
                        this.lastOffset = this.lastKeyword = n4;
                        continue block23;
                    }
                    if (c != '\'' || cArray[this.lastOffset] != '\'') continue block23;
                    this.addToken(n4 - this.lastOffset, by);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block23;
                }
                case 4: {
                    if (bl) {
                        bl = false;
                        continue block23;
                    }
                    if (c != '`') continue block23;
                    this.addToken(n4 - this.lastOffset, (byte)4);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block23;
                }
                default: {
                    throw new InternalError("Invalid state: " + by);
                }
            }
        }
        if (by == 0) {
            this.doKeyword(segment, n3, '\u0000');
        }
        switch (by) {
            case 3: 
            case 4: {
                this.addToken(n3 - this.lastOffset, (byte)10);
                by = 0;
                break;
            }
            case 7: {
                this.addToken(n3 - this.lastOffset, by);
                if (bl) break;
                by = 0;
                break;
            }
            case 9: {
                this.addToken(n3 - this.lastOffset, by);
                if (bl) break;
                by = 0;
                break;
            }
            default: {
                this.addToken(n3 - this.lastOffset, by);
            }
        }
        return by;
    }

    public static KeywordMap getKeywords() {
        if (cKeywords == null) {
            cKeywords = new KeywordMap(true, 101);
        }
        return cKeywords;
    }

    private boolean doKeyword(Segment segment, int n, char c) {
        int n2 = n + 1;
        int n3 = n - this.lastKeyword;
        byte by = this.keywords.lookup(segment, this.lastKeyword, n3);
        if (by != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n3, by);
            this.lastOffset = n;
        }
        this.lastKeyword = n2;
        return false;
    }
}

