/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.config;

import java.io.File;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.config.NamedListConfig;
import net.azib.ipscan.config.Platform;

public class OpenersConfig
extends NamedListConfig {
    static final Logger LOG = LoggerFactory.getLogger();

    public OpenersConfig(Preferences preferences) {
        super(preferences, "openers");
        if (this.size() == 0) {
            Labels labels = Labels.getInstance();
            if (Platform.WINDOWS) {
                this.add(labels.get("opener.netbios"), new Opener("\\\\${fetcher.ip}", false, null));
            }
            this.add(labels.get("opener.web"), new Opener("http://${fetcher.hostname}/", false, null));
            this.add(labels.get("opener.ftp"), new Opener("ftp://${fetcher.hostname}/", false, null));
            if (!Platform.WINDOWS) {
                this.add(labels.get("opener.telnet"), new Opener("telnet ${fetcher.ip}", true, null));
            }
            this.add(labels.get("opener.ping"), new Opener("ping ${fetcher.ip}", true, null));
            this.add(labels.get("opener.traceroute"), new Opener((Platform.WINDOWS ? "tracert" : (Platform.LINUX ? "tracepath" : "traceroute")) + " ${fetcher.ip}", true, null));
            if (!Platform.WINDOWS) {
                this.add(labels.get("opener.ssh"), new Opener("ssh ${fetcher.ip}", true, null));
            }
            if (!Platform.WINDOWS) {
                this.add(labels.get("opener.whois"), new Opener("whois ${fetcher.ip}", true, null));
            }
            this.add(labels.get("opener.geolocate"), new Opener("https://angryip.org/iplocate?ip=${fetcher.ip}", false, null));
            this.add(labels.get("opener.email"), new Opener("mailto:somebody@example.com?subject=${fetcher.ip} (${fetcher.hostname})", true, null));
        }
    }

    @Override
    Object serializeValue(String value) {
        return new Opener(value);
    }

    @Override
    public void add(String name, Object value) {
        if (!(value instanceof Opener)) {
            throw new IllegalArgumentException();
        }
        super.add(name, value);
    }

    public Opener getOpener(String name) {
        return (Opener)this.namedList.get(name);
    }

    public static class Opener {
        public String execString;
        public boolean inTerminal;
        public File workingDir;

        Opener(String serialized) {
            try {
                String[] parts = serialized.split("@@@");
                this.execString = parts[0];
                this.inTerminal = parts[1].charAt(0) == '1';
                this.workingDir = parts.length >= 3 && parts[2].length() > 0 ? new File(parts[2]) : null;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.fine("Broken opener config read: " + serialized);
            }
        }

        public Opener(String execString, boolean inTerminal, File workingDir) {
            this.execString = execString;
            this.inTerminal = inTerminal;
            this.workingDir = workingDir;
        }

        public String toString() {
            return this.execString + "@@@" + (this.inTerminal ? (char)'1' : '0') + "@@@" + (this.workingDir != null ? this.workingDir.toString() : "");
        }
    }
}

