/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core.values;

import java.util.Collection;

public class NumericRangeList
implements Comparable<NumericRangeList> {
    private boolean displayAsRanges;
    private int[] numbers;

    public NumericRangeList(Collection<Integer> numbers, boolean displayAsRanges) {
        this.numbers = new int[numbers.size()];
        int c = 0;
        for (Number number : numbers) {
            this.numbers[c++] = number.intValue();
        }
        this.displayAsRanges = displayAsRanges;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int prevNumber = Integer.MAX_VALUE;
        int rangeStartNumber = 0;
        boolean isRange = false;
        int i = 0;
        if (this.numbers.length > 0) {
            prevNumber = this.numbers[0];
            sb.append(prevNumber);
        }
        while (++i < this.numbers.length) {
            int curNumber = this.numbers[i];
            if (this.displayAsRanges && prevNumber + 1 == curNumber) {
                if (!isRange) {
                    isRange = true;
                    rangeStartNumber = prevNumber;
                }
            } else {
                if (isRange) {
                    sb.append(rangeStartNumber + 1 == prevNumber ? (char)',' : '-').append(prevNumber);
                    isRange = false;
                }
                sb.append(',').append(curNumber);
            }
            prevNumber = curNumber;
        }
        if (isRange) {
            sb.append(rangeStartNumber + 1 == prevNumber ? (char)',' : '-').append(prevNumber);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(NumericRangeList that) {
        int result = this.numbers.length - that.numbers.length;
        if (result == 0) {
            for (int i = 0; i < this.numbers.length && result == 0; ++i) {
                result = this.numbers[i] - that.numbers[i];
            }
        }
        return result;
    }
}

