/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.exporters;

import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.ScanningResultList;
import net.azib.ipscan.exporters.Exporter;
import net.azib.ipscan.exporters.ExporterException;
import net.azib.ipscan.fetchers.Fetcher;

public class ExportProcessor {
    private final Exporter exporter;
    private final File file;
    private final boolean append;

    public ExportProcessor(Exporter exporter, File file, boolean append) {
        this.exporter = exporter;
        this.file = file;
        this.append = append;
    }

    public void process(ScanningResultList scanningResults, ScanningResultFilter filter) {
        FileOutputStream outputStream = null;
        try {
            if (this.append) {
                this.exporter.shouldAppendTo(this.file);
            }
            outputStream = new FileOutputStream(this.file, this.append);
            this.exporter.start(outputStream, scanningResults.getFeederInfo());
            List<Fetcher> fetchers = scanningResults.getFetchers();
            String[] fetcherNames = new String[fetchers.size()];
            int i = 0;
            for (Fetcher fetcher : fetchers) {
                fetcherNames[i++] = fetcher.getName();
            }
            this.exporter.setFetchers(fetcherNames);
            int index = 0;
            for (ScanningResult scanningResult : scanningResults) {
                if (filter != null && !filter.apply(index++, scanningResult)) continue;
                this.exporter.nextAddressResults(scanningResult.getValues().toArray());
            }
            this.exporter.end();
        }
        catch (ExporterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExporterException("exporting failed", e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static interface ScanningResultFilter {
        public boolean apply(int var1, ScanningResult var2);
    }
}

