/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.fetchers;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.fetchers.AbstractFetcher;
import net.azib.ipscan.util.MDNSResolver;
import net.azib.ipscan.util.NetBIOSResolver;

public class HostnameFetcher
extends AbstractFetcher {
    private static final Logger LOG = LoggerFactory.getLogger();
    private static Object inetAddressImpl;
    private static Method getHostByAddr;

    @Override
    public String getId() {
        return "fetcher.hostname";
    }

    private String resolveWithRegularDNS(InetAddress ip) {
        try {
            return (String)getHostByAddr.invoke(inetAddressImpl, new Object[]{ip.getAddress()});
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException && e.getCause() instanceof UnknownHostException) {
                return null;
            }
            String hostname = ip.getCanonicalHostName();
            return ip.getHostAddress().equals(hostname) ? null : hostname;
        }
    }

    private String resolveWithMulticastDNS(ScanningSubject subject) {
        try {
            MDNSResolver resolver = new MDNSResolver(subject.getAdaptedPortTimeout());
            String name = resolver.resolve(subject.getAddress());
            resolver.close();
            return name;
        }
        catch (SocketException | SocketTimeoutException e) {
            return null;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to query mDNS for " + String.valueOf(subject), e);
            return null;
        }
    }

    private String resolveWithNetBIOS(ScanningSubject subject) {
        try {
            NetBIOSResolver resolver = new NetBIOSResolver(subject.getAdaptedPortTimeout());
            String[] names = resolver.resolve(subject.getAddress());
            resolver.close();
            return names == null ? null : names[0];
        }
        catch (SocketException | SocketTimeoutException e) {
            return null;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to query NetBIOS for " + String.valueOf(subject), e);
            return null;
        }
    }

    @Override
    public Object scan(ScanningSubject subject) {
        String name = this.resolveWithRegularDNS(subject.getAddress());
        if (name == null && subject.isLocal()) {
            name = this.resolveWithMulticastDNS(subject);
        }
        if (name == null && subject.isLocal()) {
            name = this.resolveWithNetBIOS(subject);
        }
        return name;
    }

    static {
        try {
            Field impl = InetAddress.class.getDeclaredField("impl");
            impl.setAccessible(true);
            inetAddressImpl = impl.get(null);
            getHostByAddr = inetAddressImpl.getClass().getDeclaredMethod("getHostByAddr", byte[].class);
            getHostByAddr.setAccessible(true);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Could not get InetAddressImpl", e);
        }
    }
}

