/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.fetchers;

import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.fetchers.AbstractFetcher;
import net.azib.ipscan.util.NetBIOSResolver;

public class NetBIOSInfoFetcher
extends AbstractFetcher {
    private static final Logger LOG = LoggerFactory.getLogger();

    @Override
    public String getId() {
        return "fetcher.netbios";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object scan(ScanningSubject subject) {
        try (NetBIOSResolver netbios = new NetBIOSResolver(subject.getAdaptedPortTimeout());){
            String[] names = netbios.resolve(subject.getAddress());
            if (names == null) {
                Object var4_8 = null;
                return var4_8;
            }
            String computerName = names[0];
            String userName = names[1];
            String groupName = names[2];
            String macAddress = names[3];
            String string = (String)(groupName != null ? groupName + "\\" : "") + (String)(userName != null ? userName + "@" : "") + (String)(computerName != null ? computerName + " " : "") + "[" + macAddress + "]";
            return string;
        }
        catch (SocketTimeoutException e) {
            return null;
        }
        catch (SocketException e) {
            return null;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, null, e);
            return null;
        }
    }
}

