/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.actions;

import net.azib.ipscan.config.Labels;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.ScanningResultList;
import net.azib.ipscan.gui.InputDialog;
import net.azib.ipscan.gui.ResultTable;
import net.azib.ipscan.gui.StatusBar;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class GotoMenuActions {

    public static final class Find
    implements Listener {
        private final ResultTable resultTable;
        private final StatusBar statusBar;
        private String lastText = "";

        public Find(StatusBar statusBar, ResultTable resultTable) {
            this.statusBar = statusBar;
            this.resultTable = resultTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(Event event) {
            InputDialog dialog = new InputDialog(Labels.getLabel("title.find"), Labels.getLabel("text.find"));
            String text = dialog.open(this.lastText, Labels.getLabel("button.find.next"));
            if (text == null) {
                return;
            }
            this.lastText = text;
            try {
                this.statusBar.setStatusText(Labels.getLabel("state.searching"));
                this.findText(text, this.statusBar.getShell());
            }
            finally {
                this.statusBar.setStatusText(null);
            }
        }

        private void findText(String text, Shell activeShell) {
            int startIndex;
            ScanningResultList results = this.resultTable.getScanningResults();
            int foundIndex = results.findText(text, startIndex = this.resultTable.getSelectionIndex() + 1);
            if (foundIndex >= 0) {
                this.resultTable.setSelection(foundIndex);
                this.resultTable.setFocus();
                return;
            }
            if (startIndex > 0) {
                MessageBox messageBox = new MessageBox(activeShell, 196);
                messageBox.setText(Labels.getLabel("title.find"));
                messageBox.setMessage(Labels.getLabel("text.find.notFound") + "\n" + Labels.getLabel("text.find.restart"));
                if (messageBox.open() == 64) {
                    this.resultTable.deselectAll();
                    this.findText(text, activeShell);
                }
            } else {
                MessageBox messageBox = new MessageBox(activeShell, 34);
                messageBox.setText(Labels.getLabel("title.find"));
                messageBox.setMessage(Labels.getLabel("text.find.notFound"));
                messageBox.open();
            }
        }
    }

    public static final class PrevHostWithInfo
    extends PrevHost {
        public PrevHostWithInfo(ResultTable resultTable) {
            super(resultTable, ScanningResult.ResultType.WITH_PORTS);
        }
    }

    public static final class PrevDeadHost
    extends PrevHost {
        public PrevDeadHost(ResultTable resultTable) {
            super(resultTable, ScanningResult.ResultType.DEAD);
        }
    }

    public static final class PrevAliveHost
    extends PrevHost {
        public PrevAliveHost(ResultTable resultTable) {
            super(resultTable, ScanningResult.ResultType.ALIVE);
        }
    }

    public static final class NextHostWithInfo
    extends NextHost {
        public NextHostWithInfo(ResultTable resultTable) {
            super(resultTable, ScanningResult.ResultType.WITH_PORTS);
        }
    }

    public static final class NextDeadHost
    extends NextHost {
        public NextDeadHost(ResultTable resultTable) {
            super(resultTable, ScanningResult.ResultType.DEAD);
        }
    }

    public static final class NextAliveHost
    extends NextHost {
        public NextAliveHost(ResultTable resultTable) {
            super(resultTable, ScanningResult.ResultType.ALIVE);
        }
    }

    static class PrevHost
    extends NextHost {
        public PrevHost(ResultTable resultTable, ScanningResult.ResultType whatToSearchFor) {
            super(resultTable, whatToSearchFor);
        }

        @Override
        protected int inc(int i) {
            return i - 1;
        }

        @Override
        protected int startIndex() {
            int curIndex = this.resultTable.getSelectionIndex();
            return curIndex >= 0 ? curIndex : this.resultTable.getItemCount();
        }
    }

    static class NextHost
    implements Listener {
        final ResultTable resultTable;
        final ScanningResult.ResultType whatToSearchFor;

        NextHost(ResultTable resultTable, ScanningResult.ResultType whatToSearchFor) {
            this.resultTable = resultTable;
            this.whatToSearchFor = whatToSearchFor;
        }

        protected int inc(int i) {
            return i + 1;
        }

        protected int startIndex() {
            return this.resultTable.getSelectionIndex();
        }

        @Override
        public final void handleEvent(Event event) {
            ScanningResultList results = this.resultTable.getScanningResults();
            int numElements = this.resultTable.getItemCount();
            int startIndex = this.startIndex();
            int i = this.inc(startIndex);
            while (i < numElements && i >= 0) {
                ScanningResult scanningResult = results.getResult(i);
                if (this.whatToSearchFor.matches(scanningResult.getType())) {
                    this.resultTable.setSelection(i);
                    this.resultTable.setFocus();
                    return;
                }
                i = this.inc(i);
            }
            if (startIndex >= 0 && startIndex < numElements) {
                this.resultTable.deselectAll();
                this.handleEvent(event);
            }
        }
    }
}

