/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.actions;

import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.core.UserErrorException;

public class TerminalLauncher {
    static final Logger LOG = LoggerFactory.getLogger();
    private static String workingTerminal;

    public static void launchInTerminal(String execString, File workingDir) {
        block13: {
            try {
                if (Platform.WINDOWS) {
                    File batFile = File.createTempFile("launch", ".cmd");
                    batFile.deleteOnExit();
                    try (FileWriter writer = new FileWriter(batFile);){
                        writer.write("@rem This is a temporary file generated by Angry IP Scanner\n@start cmd /k " + execString);
                    }
                    Runtime.getRuntime().exec(batFile.getAbsolutePath(), null, workingDir);
                    break block13;
                }
                if (Platform.MAC_OS) {
                    Runtime.getRuntime().exec(new String[]{"osascript", "-e", "tell application \"Terminal\" to do script \"" + execString + "\""}, null, workingDir);
                } else {
                    String shell;
                    if (workingTerminal == null) {
                        workingTerminal = TerminalLauncher.detectWorkingTerminal();
                    }
                    if ((shell = System.getenv("SHELL")) == null) {
                        shell = "sh";
                    }
                    String execArg = workingTerminal.contains("gnome") || workingTerminal.contains("xfce") ? "-x" : "-e";
                    Runtime.getRuntime().exec(new String[]{workingTerminal, execArg, shell, "-xc", execString + ";" + shell}, null, workingDir);
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "openTerminal.failed", e);
                throw new UserErrorException("openTerminal.failed", execString);
            }
        }
    }

    private static String detectWorkingTerminal() {
        for (String term : Arrays.asList("x-terminal-emulator", "xdg-terminal", "gnome-terminal", "xfce4-terminal", "konsole", "xterm")) {
            File file = new File("/usr/bin/" + term);
            if (!file.exists()) continue;
            return file.getPath();
        }
        return "xterm";
    }
}

