/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.feeders;

import net.azib.ipscan.config.Labels;
import net.azib.ipscan.feeders.Feeder;
import net.azib.ipscan.feeders.FileFeeder;
import net.azib.ipscan.gui.feeders.AbstractFeederGUI;
import net.azib.ipscan.gui.feeders.FeederArea;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class FileFeederGUI
extends AbstractFeederGUI {
    private Text fileNameText;

    public FileFeederGUI(FeederArea parent) {
        super(parent);
        this.feeder = new FileFeeder();
    }

    @Override
    public void initialize() {
        this.setLayout(new GridLayout(3, false));
        Label fileNameLabel = new Label(this, 0);
        this.fileNameText = new Text(this, 2048);
        Button browseButton = new Button(this, 0);
        fileNameLabel.setText(Labels.getLabel("feeder.file.name") + ":");
        this.fileNameText.setLayoutData(new GridData(160, -1));
        browseButton.setText(Labels.getLabel("feeder.file.browse"));
        browseButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(FileFeederGUI.this.getShell());
                dialog.setText(Labels.getLabel("feeder.file.browse"));
                String fileName = dialog.open();
                if (fileName != null) {
                    FileFeederGUI.this.fileNameText.setText(fileName);
                    FileFeederGUI.this.fileNameText.setSelection(fileName.length());
                }
            }
        });
        this.pack();
    }

    @Override
    public Feeder createFeeder() {
        this.feeder = new FileFeeder(this.fileNameText.getText());
        return this.feeder;
    }

    @Override
    public String[] serialize() {
        return new String[]{this.fileNameText.getText()};
    }

    @Override
    public void unserialize(String[] parts) {
        this.fileNameText.setText(parts[0]);
    }

    @Override
    public String[] serializePartsLabels() {
        return new String[]{"feeder.file.name"};
    }
}

