/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.fetchers;

import net.azib.ipscan.config.Labels;
import net.azib.ipscan.fetchers.Fetcher;
import net.azib.ipscan.fetchers.FetcherPrefs;
import net.azib.ipscan.fetchers.MACFetcher;
import net.azib.ipscan.gui.AbstractModalDialog;
import net.azib.ipscan.gui.util.LayoutHelper;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MACFetcherPrefs
extends AbstractModalDialog
implements FetcherPrefs {
    private MACFetcher fetcher;
    private Text separator;

    @Override
    public void openFor(Fetcher fetcher) {
        this.fetcher = (MACFetcher)fetcher;
        this.open();
    }

    @Override
    protected void populateShell() {
        this.shell = new Shell(Display.getCurrent().getActiveShell(), 2144);
        this.shell.setText(this.fetcher.getName());
        this.shell.setLayout(LayoutHelper.formLayout(10, 10, 5));
        Label separatorLabel = new Label(this.shell, 0);
        separatorLabel.setText(Labels.getLabel("fetcher.mac.separator"));
        this.separator = new Text(this.shell, 2048);
        this.separator.setText(this.fetcher.getSeparator());
        this.separator.setLayoutData(LayoutHelper.formData(new FormAttachment(0), new FormAttachment(100), new FormAttachment(separatorLabel), null));
        Button okButton = new Button(this.shell, 0);
        okButton.setText(Labels.getLabel("button.OK"));
        Button cancelButton = new Button(this.shell, 0);
        cancelButton.setText(Labels.getLabel("button.cancel"));
        this.positionButtonsInFormLayout(okButton, cancelButton, this.separator);
        okButton.addListener(13, e -> {
            this.savePreferences();
            this.close();
        });
        cancelButton.addListener(13, e -> this.close());
        this.shell.pack();
    }

    void savePreferences() {
        String text = this.separator.getText();
        this.fetcher.setSeparator(text);
        this.fetcher.getPreferences().put("separator", text);
    }
}

