/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.util;

import java.io.Closeable;
import java.net.DatagramSocket;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.azib.ipscan.util.IOUtils;

public class ThreadResourceBinder<T> {
    private Map<Long, T> resources = new ConcurrentHashMap<Long, T>(256);

    public T bind(T resource) {
        this.resources.put(Thread.currentThread().getId(), resource);
        return resource;
    }

    public void close() {
        for (T resource : this.resources.values()) {
            this.close(resource);
        }
        this.resources.clear();
    }

    private void close(T resource) {
        if (resource instanceof DatagramSocket) {
            IOUtils.closeQuietly((DatagramSocket)resource);
        } else if (resource instanceof Socket) {
            IOUtils.closeQuietly((Socket)resource);
        } else if (resource instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)resource);
        }
    }

    public void closeAndUnbind(T resource) {
        this.close(resource);
        this.resources.remove(Thread.currentThread().getId());
    }
}

