/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEditableTextListener;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleObject;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class Accessible {
    List<AccessibleListener> accessibleListeners;
    List<AccessibleControlListener> accessibleControlListeners;
    List<AccessibleTextListener> accessibleTextListeners;
    List<AccessibleActionListener> accessibleActionListeners;
    List<AccessibleEditableTextListener> accessibleEditableTextListeners;
    List<AccessibleTableListener> accessibleTableListeners;
    List<AccessibleTableCellListener> accessibleTableCellListeners;
    List<AccessibleTextExtendedListener> accessibleTextExtendedListeners;
    List<AccessibleValueListener> accessibleValueListeners;
    List<AccessibleAttributeListener> accessibleAttributeListeners;
    Accessible parent;
    AccessibleObject accessibleObject;
    Control control;
    List<Relation> relations;
    List<Accessible> children;

    @Deprecated
    protected Accessible() {
    }

    Accessible(Control control) {
        this.control = control;
        long type = OS.G_OBJECT_TYPE(this.getControlHandle());
        this.accessibleObject = new AccessibleObject(type, this.getControlHandle(), this, false);
        this.addRelations();
    }

    public void addRelation(int type, Accessible target) {
        Relation relation;
        this.checkWidget();
        if (target == null) {
            SWT.error(4);
        }
        if (this.relations == null) {
            this.relations = new ArrayList<Relation>();
        }
        if (this.relations.indexOf(relation = new Relation(type, target)) != -1) {
            return;
        }
        this.relations.add(relation);
        if (this.accessibleObject != null) {
            this.accessibleObject.addRelation(type, target);
        }
    }

    void addRelations() {
        if (this.relations == null) {
            return;
        }
        if (this.accessibleObject == null) {
            return;
        }
        int i = 0;
        while (i < this.relations.size()) {
            Relation relation = this.relations.get(i);
            this.accessibleObject.addRelation(relation.type, relation.target);
            ++i;
        }
    }

    public void dispose() {
        if (this.parent == null) {
            return;
        }
        this.release();
        this.parent.children.remove(this);
        this.parent = null;
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    AccessibleObject getAccessibleObject() {
        if (this.accessibleObject == null) {
            long widget = this.getControlHandle();
            long type = OS.G_OBJECT_TYPE(widget);
            if (this.parent == null) {
                this.accessibleObject = new AccessibleObject(type, widget, this, false);
            } else {
                this.accessibleObject = new AccessibleObject(type, 0L, this, true);
                this.accessibleObject.parent = this.parent.getAccessibleObject();
            }
        }
        return this.accessibleObject;
    }

    long getControlHandle() {
        long result = this.control.handle;
        if (this.control instanceof Label) {
            if (GTK.GTK4) {
                long child = GTK4.gtk_widget_get_first_child(result);
                while (child != 0L) {
                    if (GTK.gtk_widget_get_visible(child)) {
                        result = child;
                        break;
                    }
                    child = GTK4.gtk_widget_get_next_sibling(child);
                }
            } else {
                long list = GTK3.gtk_container_get_children(result);
                if (list != 0L) {
                    long temp = list;
                    while (temp != 0L) {
                        long widget = OS.g_list_data(temp);
                        if (GTK.gtk_widget_get_visible(widget)) {
                            result = widget;
                            break;
                        }
                        temp = OS.g_list_next(temp);
                    }
                    OS.g_list_free(list);
                }
            }
        }
        return result;
    }

    public void internal_dispose_Accessible() {
        this.release();
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }

    void release() {
        if (this.children != null) {
            ArrayList<Accessible> temp = new ArrayList<Accessible>(this.children);
            int i = 0;
            while (i < temp.size()) {
                Accessible child = (Accessible)temp.get(i);
                child.dispose();
                ++i;
            }
        }
        if (this.accessibleObject != null) {
            this.accessibleObject.release();
            this.accessibleObject = null;
        }
    }

    public void removeRelation(int type, Accessible target) {
        Relation relation;
        int index;
        this.checkWidget();
        if (this.relations == null) {
            return;
        }
        if (target == null) {
            SWT.error(4);
        }
        if ((index = this.relations.indexOf(relation = new Relation(type, target))) == -1) {
            return;
        }
        this.relations.remove(index);
        if (this.accessibleObject != null) {
            this.accessibleObject.removeRelation(type, target);
        }
    }

    static class Relation {
        int type;
        Accessible target;

        public Relation(int type, Accessible target) {
            this.type = type;
            this.target = target;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Relation)) {
                return false;
            }
            Relation relation = (Relation)object;
            return relation.type == this.type && relation.target == this.target;
        }
    }
}

