/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_rectangle_int_t;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;

public final class GC
extends Resource {
    public long handle;
    Drawable drawable;
    GCData data;
    private double[] cairoTransformationMatrix;
    private double[] currentTransform;
    private Rectangle clipping;
    static final float[] LINE_DOT = new float[]{1.0f, 1.0f};
    static final float[] LINE_DASH = new float[]{3.0f, 1.0f};
    static final float[] LINE_DASHDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DASHDOTDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = this.checkStyle(style);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = data.device = device;
        long gdkGC = drawable.internal_new_GC(data);
        this.init(drawable, data, gdkGC);
        this.init();
    }

    int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    void cairoClipRegion(long cairo) {
        if (cairo == 0L) {
            return;
        }
        GdkRectangle rect = new GdkRectangle();
        GDK.gdk_cairo_get_clip_rectangle(cairo, rect);
        cairo_rectangle_int_t cairoRect = new cairo_rectangle_int_t();
        cairoRect.convertFromGdkRectangle(rect);
        long regionHandle = this.data.regionSet;
        long actualRegion = Cairo.cairo_region_create_rectangle(cairoRect);
        Cairo.cairo_region_subtract(actualRegion, regionHandle);
        GDK.gdk_cairo_region(cairo, actualRegion);
        Cairo.cairo_clip(cairo);
        Cairo.cairo_paint(cairo);
    }

    public static GC gtk_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        long gdkGC = drawable.internal_new_GC(data);
        gc.device = data.device;
        gc.init(drawable, data, gdkGC);
        return gc;
    }

    void checkGC(int mask) {
        int state = this.data.state;
        if ((state & mask) == mask) {
            return;
        }
        state = (state ^ mask) & mask;
        this.data.state |= mask;
        long cairo = this.data.cairo;
        if ((state & 3) != 0) {
            Pattern pattern;
            GdkRGBA colorRGBA = null;
            if ((state & 1) != 0) {
                colorRGBA = this.data.foregroundRGBA;
                pattern = this.data.foregroundPattern;
                this.data.state &= 0xFFFFFFFD;
            } else {
                colorRGBA = this.data.backgroundRGBA;
                pattern = this.data.backgroundPattern;
                this.data.state &= 0xFFFFFFFE;
            }
            if (pattern != null) {
                if ((this.data.style & 0x8000000) != 0 && pattern.surface != 0L) {
                    long newPattern = Cairo.cairo_pattern_create_for_surface(pattern.surface);
                    if (newPattern == 0L) {
                        SWT.error(2);
                    }
                    Cairo.cairo_pattern_set_extend(newPattern, 1);
                    double[] matrix = new double[]{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                    Cairo.cairo_pattern_set_matrix(newPattern, matrix);
                    Cairo.cairo_set_source(cairo, newPattern);
                    Cairo.cairo_pattern_destroy(newPattern);
                } else {
                    Cairo.cairo_set_source(cairo, pattern.handle);
                }
            } else {
                Cairo.cairo_set_source_rgba(cairo, colorRGBA.red, colorRGBA.green, colorRGBA.blue, (float)this.data.alpha / 255.0f);
            }
        }
        if ((state & 4) != 0 && this.data.layout != 0L) {
            Font font = this.data.font;
            OS.pango_layout_set_font_description(this.data.layout, font.handle);
        }
        if ((state & 0x10) != 0) {
            int cap_style = 0;
            switch (this.data.lineCap) {
                case 2: {
                    cap_style = 1;
                    break;
                }
                case 1: {
                    cap_style = 0;
                    break;
                }
                case 3: {
                    cap_style = 2;
                }
            }
            Cairo.cairo_set_line_cap(cairo, cap_style);
        }
        if ((state & 0x20) != 0) {
            int join_style = 0;
            switch (this.data.lineJoin) {
                case 1: {
                    join_style = 0;
                    break;
                }
                case 2: {
                    join_style = 1;
                    break;
                }
                case 3: {
                    join_style = 2;
                }
            }
            Cairo.cairo_set_line_join(cairo, join_style);
        }
        if ((state & 0x40) != 0) {
            Cairo.cairo_set_line_width(cairo, this.data.lineWidth == 0.0f ? (float)DPIUtil.autoScaleUp(this.drawable, 1) : this.data.lineWidth);
            switch (this.data.lineStyle) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    state |= 8;
                }
            }
        }
        if ((state & 8) != 0) {
            float dashesOffset = 0.0f;
            float[] dashes = null;
            float width = this.data.lineWidth;
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    dashes = width != 0.0f ? LINE_DASH : LINE_DASH_ZERO;
                    break;
                }
                case 3: {
                    dashes = width != 0.0f ? LINE_DOT : LINE_DOT_ZERO;
                    break;
                }
                case 4: {
                    dashes = width != 0.0f ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                    break;
                }
                case 5: {
                    dashes = width != 0.0f ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                    break;
                }
                case 6: {
                    dashes = this.data.lineDashes;
                }
            }
            if (dashes != null) {
                dashesOffset = this.data.lineDashesOffset;
                double[] cairoDashes = new double[dashes.length];
                int i = 0;
                while (i < cairoDashes.length) {
                    cairoDashes[i] = width == 0.0f || this.data.lineStyle == 6 ? dashes[i] : dashes[i] * width;
                    ++i;
                }
                Cairo.cairo_set_dash(cairo, cairoDashes, cairoDashes.length, dashesOffset);
            } else {
                Cairo.cairo_set_dash(cairo, null, 0, 0.0);
            }
        }
        if ((state & 0x80) != 0) {
            Cairo.cairo_set_miter_limit(cairo, this.data.lineMiterLimit);
        }
        if ((state & 0x200) != 0) {
            int effectiveLineWidth;
            int n = effectiveLineWidth = this.data.lineWidth < 1.0f ? 1 : Math.round(this.data.lineWidth);
            if (effectiveLineWidth % 2 == 1) {
                double[] offsetX = new double[]{0.5};
                double[] offsetY = new double[]{0.5};
                double[] matrix = new double[6];
                Cairo.cairo_get_matrix(cairo, matrix);
                double[] inverseMatrix = Arrays.copyOf(matrix, 6);
                Cairo.cairo_matrix_invert(inverseMatrix);
                Cairo.cairo_set_matrix(cairo, inverseMatrix);
                Cairo.cairo_user_to_device_distance(cairo, offsetX, offsetY);
                Cairo.cairo_set_matrix(cairo, matrix);
                this.data.cairoXoffset = Math.abs(offsetX[0]);
                this.data.cairoYoffset = Math.abs(offsetY[0]);
            } else {
                this.data.cairoYoffset = 0.0;
                this.data.cairoXoffset = 0.0;
            }
        }
    }

    long convertRgn(long rgn, double[] matrix) {
        long newRgn = Cairo.cairo_region_create();
        if (this.isIdentity(matrix)) {
            Cairo.cairo_region_union(newRgn, rgn);
            return newRgn;
        }
        int[] nRects = new int[1];
        long[] rects = new long[1];
        Region.cairo_region_get_rectangles(rgn, rects, nRects);
        cairo_rectangle_int_t rect = new cairo_rectangle_int_t();
        int[] pointArray = new int[8];
        double[] x = new double[1];
        double[] y = new double[1];
        int i = 0;
        while (i < nRects[0]) {
            Cairo.memmove(rect, rects[0] + (long)(i * cairo_rectangle_int_t.sizeof), cairo_rectangle_int_t.sizeof);
            x[0] = rect.x;
            y[0] = rect.y;
            Cairo.cairo_matrix_transform_point(matrix, x, y);
            pointArray[0] = (int)x[0];
            pointArray[1] = (int)y[0];
            x[0] = rect.x + rect.width;
            y[0] = rect.y;
            Cairo.cairo_matrix_transform_point(matrix, x, y);
            pointArray[2] = (int)Math.round(x[0]);
            pointArray[3] = (int)y[0];
            x[0] = rect.x + rect.width;
            y[0] = rect.y + rect.height;
            Cairo.cairo_matrix_transform_point(matrix, x, y);
            pointArray[4] = (int)Math.round(x[0]);
            pointArray[5] = (int)Math.round(y[0]);
            x[0] = rect.x;
            y[0] = rect.y + rect.height;
            Cairo.cairo_matrix_transform_point(matrix, x, y);
            pointArray[6] = (int)x[0];
            pointArray[7] = (int)Math.round(y[0]);
            long polyRgn = Region.gdk_region_polygon(pointArray, pointArray.length / 2, 0);
            Cairo.cairo_region_union(newRgn, polyRgn);
            Cairo.cairo_region_destroy(polyRgn);
            ++i;
        }
        if (rects[0] != 0L) {
            OS.g_free(rects[0]);
        }
        return newRgn;
    }

    void disposeLayout() {
        this.data.string = null;
        if (this.data.context != 0L) {
            OS.g_object_unref(this.data.context);
        }
        if (this.data.layout != 0L) {
            OS.g_object_unref(this.data.layout);
        }
        this.data.context = 0L;
        this.data.layout = 0L;
    }

    @Override
    void destroy() {
        Image image;
        if (this.data.disposeCairo) {
            long cairo = this.data.cairo;
            Cairo.cairo_destroy(cairo);
        }
        this.data.cairo = 0L;
        long clipRgn = this.data.clipRgn;
        if (clipRgn != 0L) {
            Cairo.cairo_region_destroy(clipRgn);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            if (image.transparentPixel != -1) {
                image.createMask();
            }
        }
        this.disposeLayout();
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.data.clipRgn = 0L;
        this.data.drawable = 0L;
        this.drawable = null;
        this.handle = 0L;
        this.data.image = null;
        this.data.string = null;
        this.data = null;
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle destRect = DPIUtil.autoScaleUp(this.drawable, new Rectangle(destX, destY, destWidth, destHeight));
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destRect.x, destRect.y, destRect.width, destRect.height, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        srcImage.refreshImageForZoom();
        ImageData srcImageData = srcImage.getImageData();
        int imgWidth = srcImageData.width;
        int imgHeight = srcImageData.height;
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            boolean bl = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            if (srcX + srcWidth > imgWidth + 1 || srcY + srcHeight > imgHeight + 1) {
                SWT.error(5);
            }
        }
        long cairo = this.data.cairo;
        if (this.data.alpha != 0) {
            srcImage.createSurface();
            Cairo.cairo_save(cairo);
            if ((this.data.style & 0x8000000) != 0) {
                Cairo.cairo_scale(cairo, -1.0, 1.0);
                Cairo.cairo_translate(cairo, -2 * destX - destWidth, 0.0);
            }
            Cairo.cairo_rectangle(cairo, destX, destY, destWidth, destHeight);
            Cairo.cairo_clip(cairo);
            if (srcWidth != destWidth || srcHeight != destHeight) {
                float scaleX = (float)destWidth / (float)srcWidth;
                float scaleY = (float)destHeight / (float)srcHeight;
                Cairo.cairo_translate(cairo, destX - (int)((float)srcX * scaleX), destY - (int)((float)srcY * scaleY));
                Cairo.cairo_scale(cairo, scaleX, scaleY);
            } else {
                Cairo.cairo_translate(cairo, destX - srcX, destY - srcY);
            }
            int filter = 1;
            switch (this.data.interpolation) {
                case -1: {
                    filter = 1;
                    break;
                }
                case 0: {
                    filter = 3;
                    break;
                }
                case 1: {
                    filter = 0;
                    break;
                }
                case 2: {
                    filter = 2;
                }
            }
            long pattern = Cairo.cairo_pattern_create_for_surface(srcImage.surface);
            if (pattern == 0L) {
                SWT.error(2);
            }
            if (srcWidth != destWidth || srcHeight != destHeight) {
                Cairo.cairo_pattern_set_extend(pattern, 3);
            }
            Cairo.cairo_pattern_set_filter(pattern, filter);
            Cairo.cairo_set_source(cairo, pattern);
            if (this.data.alpha != 255) {
                Cairo.cairo_paint_with_alpha(cairo, (float)this.data.alpha / 255.0f);
            } else {
                Cairo.cairo_paint(cairo);
            }
            Cairo.cairo_restore(cairo);
            Cairo.cairo_pattern_destroy(pattern);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    void fillRectangleInPixels(int x, int y, int width, int height) {
        this.checkGC(2);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        long cairo = this.data.cairo;
        if (this.data.regionSet != 0L) {
            this.cairoClipRegion(cairo);
        } else {
            Cairo.cairo_rectangle(cairo, x, y, width, height);
        }
        Cairo.cairo_fill(cairo);
    }

    public void fillRectangle(Rectangle rect) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangleInPixels(DPIUtil.autoScaleUp(this.drawable, rect));
    }

    void fillRectangleInPixels(Rectangle rect) {
        this.fillRectangleInPixels(rect.x, rect.y, rect.width, rect.height);
    }

    public Rectangle getClipping() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return DPIUtil.autoScaleDown(this.drawable, this.getClippingInPixels());
    }

    Rectangle getClippingInPixels() {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        int[] w = new int[1];
        int[] h = new int[1];
        this.getSize(w, h);
        width = w[0];
        height = h[0];
        long cairo = this.data.cairo;
        long clipRgn = this.data.clipRgn;
        long damageRgn = this.data.damageRgn;
        if (clipRgn != 0L || damageRgn != 0L || cairo != 0L) {
            long rgn = Cairo.cairo_region_create();
            cairo_rectangle_int_t rect = new cairo_rectangle_int_t();
            rect.width = width;
            rect.height = height;
            Cairo.cairo_region_union_rectangle(rgn, rect);
            if (damageRgn != 0L) {
                Cairo.cairo_region_intersect(rgn, damageRgn);
            }
            if (clipRgn != 0L) {
                if (!Arrays.equals(this.data.clippingTransform, this.currentTransform)) {
                    double[] clippingTransform;
                    if (this.currentTransform != null && this.data.clippingTransform == null) {
                        clippingTransform = (double[])this.currentTransform.clone();
                        Cairo.cairo_matrix_invert(clippingTransform);
                    } else if (this.currentTransform != null && this.data.clippingTransform != null) {
                        clippingTransform = new double[6];
                        double[] invertedCurrentTransform = (double[])this.currentTransform.clone();
                        Cairo.cairo_matrix_invert(invertedCurrentTransform);
                        Cairo.cairo_matrix_multiply(clippingTransform, this.data.clippingTransform, invertedCurrentTransform);
                    } else {
                        clippingTransform = (double[])this.data.clippingTransform.clone();
                    }
                    long oldRgn = rgn;
                    rgn = this.convertRgn(rgn, clippingTransform);
                    Cairo.cairo_region_destroy(oldRgn);
                    clipRgn = this.convertRgn(clipRgn, clippingTransform);
                    Cairo.cairo_region_intersect(rgn, clipRgn);
                    Cairo.cairo_region_destroy(clipRgn);
                } else {
                    Cairo.cairo_region_intersect(rgn, clipRgn);
                }
            }
            Cairo.cairo_region_get_extents(rgn, rect);
            Cairo.cairo_region_destroy(rgn);
            x = rect.x;
            y = rect.y;
            width = rect.width;
            height = rect.height;
        }
        return new Rectangle(x, y, width, height);
    }

    public Color getForeground() {
        if (this.handle == 0L) {
            SWT.error(24);
        }
        return Color.gtk_new(this.data.device, this.data.foregroundRGBA);
    }

    public GCData getGCData() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data;
    }

    void getSize(int[] width, int[] height) {
        if (this.data.width != -1 && this.data.height != -1) {
            width[0] = this.data.width;
            height[0] = this.data.height;
            return;
        }
        if (this.data.drawable != 0L) {
            if (GTK.GTK4) {
                width[0] = GDK.gdk_surface_get_width(this.data.drawable);
                height[0] = GDK.gdk_surface_get_height(this.data.drawable);
            } else {
                width[0] = GDK.gdk_window_get_width(this.data.drawable);
                height[0] = GDK.gdk_window_get_height(this.data.drawable);
            }
            return;
        }
        long surface = Cairo.cairo_get_target(this.handle);
        switch (Cairo.cairo_surface_get_type(surface)) {
            case 0: {
                width[0] = Cairo.cairo_image_surface_get_width(surface);
                height[0] = Cairo.cairo_image_surface_get_height(surface);
                break;
            }
            case 3: {
                width[0] = Cairo.cairo_xlib_surface_get_width(surface);
                height[0] = Cairo.cairo_xlib_surface_get_height(surface);
            }
        }
    }

    public int hashCode() {
        return (int)this.handle;
    }

    void init(Drawable drawable, GCData data, long gdkGC) {
        Image image;
        if (data.foregroundRGBA != null) {
            data.state &= 0xFFFFFFFE;
        }
        if (data.backgroundRGBA != null) {
            data.state &= 0xFFFFFEFD;
        }
        if (data.font != null) {
            data.state &= 0xFFFFFFFB;
        }
        if ((image = data.image) != null) {
            image.memGC = this;
            if (image.transparentPixel != -1) {
                image.destroyMask();
            }
        }
        this.drawable = drawable;
        this.data = data;
        long cairo = data.cairo = (this.handle = gdkGC);
        Cairo.cairo_set_fill_rule(cairo, 1);
        data.state &= 0xFFFFFD80;
        this.setClipping(data.clipRgn);
        this.initCairo();
        if ((data.style & 0x8000000) != 0) {
            int[] w = new int[1];
            int[] h = new int[1];
            this.getSize(w, h);
            Cairo.cairo_translate(cairo, w[0], 0.0);
            Cairo.cairo_scale(cairo, -1.0, 1.0);
        }
        if (this.cairoTransformationMatrix == null) {
            this.cairoTransformationMatrix = new double[6];
        }
        Cairo.cairo_get_matrix(data.cairo, this.cairoTransformationMatrix);
        this.clipping = this.getClipping();
    }

    void initCairo() {
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            return;
        }
        if (GTK.GTK4) {
            long surface = Cairo.cairo_image_surface_create(2, this.data.width, this.data.height);
            this.data.cairo = cairo = Cairo.cairo_create(surface);
        } else {
            this.data.cairo = cairo = Cairo.cairo_create(this.data.drawable);
        }
        if (cairo == 0L) {
            SWT.error(2);
        }
        this.data.disposeCairo = true;
        Cairo.cairo_set_fill_rule(cairo, 1);
        this.data.state &= 0xFFFFFD80;
        this.setCairoClip(this.data.damageRgn, this.data.clipRgn);
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    boolean isIdentity(double[] matrix) {
        if (matrix == null) {
            return true;
        }
        return matrix[0] == 1.0 && matrix[1] == 0.0 && matrix[2] == 0.0 && matrix[3] == 1.0 && matrix[4] == 0.0 && matrix[5] == 0.0;
    }

    public void setAntialias(int antialias) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && antialias == -1) {
            return;
        }
        int mode = 0;
        switch (antialias) {
            case -1: {
                mode = 0;
                break;
            }
            case 0: {
                mode = 1;
                break;
            }
            case 1: {
                mode = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        long cairo = this.data.cairo;
        Cairo.cairo_set_antialias(cairo, mode);
    }

    public void setBackground(Color color) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.backgroundRGBA = color.handle;
        this.data.backgroundPattern = null;
        this.data.state &= 0xFFFFFEFD;
    }

    static void setCairoRegion(long cairo, long rgn) {
        GDK.gdk_cairo_region(cairo, rgn);
    }

    void setCairoClip(long damageRgn, long clipRgn) {
        long cairo = this.data.cairo;
        Cairo.cairo_reset_clip(cairo);
        if (damageRgn != 0L) {
            double[] matrix = new double[6];
            Cairo.cairo_get_matrix(cairo, matrix);
            double[] identity = new double[6];
            Cairo.cairo_matrix_init_identity(identity);
            Cairo.cairo_set_matrix(cairo, identity);
            GC.setCairoRegion(cairo, damageRgn);
            Cairo.cairo_clip(cairo);
            Cairo.cairo_set_matrix(cairo, matrix);
        }
        if (clipRgn != 0L) {
            long clipRgnCopy = Cairo.cairo_region_create();
            Cairo.cairo_region_union(clipRgnCopy, clipRgn);
            this.limitClipping(clipRgnCopy);
            GC.setCairoRegion(cairo, clipRgnCopy);
            Cairo.cairo_clip(cairo);
            Cairo.cairo_region_destroy(clipRgnCopy);
        }
    }

    private void limitClipping(long gcClipping) {
        Region clippingRegion = new Region();
        if (this.currentTransform != null) {
            double[] invertedCurrentTransform = (double[])this.currentTransform.clone();
            Cairo.cairo_matrix_invert(invertedCurrentTransform);
            int[] clippingWithoutUserTransform = GC.transformRectangle(invertedCurrentTransform, this.clipping);
            if (GC.hasNoRotation(invertedCurrentTransform)) {
                Rectangle rectangle = GC.getTransformedClippingRectangle(clippingWithoutUserTransform);
                clippingRegion.add(rectangle);
            } else {
                clippingRegion.add(clippingWithoutUserTransform);
            }
        } else {
            clippingRegion.add(this.clipping);
        }
        Cairo.cairo_region_intersect(gcClipping, clippingRegion.handle);
        clippingRegion.dispose();
    }

    private static int[] transformRectangle(double[] affineTransformation, Rectangle rectangle) {
        Point[] endPoints = new Point[]{new Point(rectangle.x, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height), new Point(rectangle.x, rectangle.y + rectangle.height)};
        return GC.transformPoints(affineTransformation, endPoints);
    }

    private static int[] transformPoints(double[] transformation, Point[] points) {
        int[] transformedPoints = new int[points.length * 2];
        double[] px = new double[1];
        double[] py = new double[1];
        int i = 0;
        while (i < points.length) {
            px[0] = points[i].x;
            py[0] = points[i].y;
            Cairo.cairo_matrix_transform_point(transformation, px, py);
            transformedPoints[i * 2 + 0] = (int)Math.round(px[0]);
            transformedPoints[i * 2 + 1] = (int)Math.round(py[0]);
            ++i;
        }
        return transformedPoints;
    }

    private static boolean hasNoRotation(double[] matrix) {
        double m12 = matrix[1];
        double m21 = matrix[2];
        return m12 == 0.0 && m21 == 0.0;
    }

    private static Rectangle getTransformedClippingRectangle(int[] pointsArray) {
        int x1 = pointsArray[0];
        int y1 = pointsArray[1];
        int x2 = pointsArray[2];
        int y2 = pointsArray[3];
        int x3 = pointsArray[4];
        int y3 = pointsArray[5];
        int x4 = pointsArray[6];
        int y4 = pointsArray[7];
        int x = Math.min(Math.min(x1, x2), Math.min(x3, x4));
        int y = Math.min(Math.min(y1, y2), Math.min(y3, y4));
        int width = Math.abs(x1 - x2);
        int height = Math.abs(y1 - y4);
        Rectangle r = new Rectangle(x, y, width, height);
        return r;
    }

    void setClipping(long clipRgn) {
        if (clipRgn == 0L) {
            if (this.data.clipRgn != 0L) {
                Cairo.cairo_region_destroy(this.data.clipRgn);
                this.data.clipRgn = 0L;
            }
            this.data.clippingTransform = null;
            this.setCairoClip(this.data.damageRgn, 0L);
        } else {
            if (this.data.clipRgn == 0L) {
                this.data.clipRgn = Cairo.cairo_region_create();
            }
            Cairo.cairo_region_subtract(this.data.clipRgn, this.data.clipRgn);
            Cairo.cairo_region_union(this.data.clipRgn, clipRgn);
            this.data.clippingTransform = (double[])(this.currentTransform != null ? (double[])this.currentTransform.clone() : null);
            this.setCairoClip(this.data.damageRgn, clipRgn);
        }
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.setClippingInPixels(DPIUtil.autoScaleUp(this.drawable, x), DPIUtil.autoScaleUp(this.drawable, y), DPIUtil.autoScaleUp(this.drawable, width), DPIUtil.autoScaleUp(this.drawable, height));
    }

    void setClippingInPixels(int x, int y, int width, int height) {
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        cairo_rectangle_int_t rect = new cairo_rectangle_int_t();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        long clipRgn = Cairo.cairo_region_create();
        Cairo.cairo_region_union_rectangle(clipRgn, rect);
        this.setClipping(clipRgn);
        Cairo.cairo_region_destroy(clipRgn);
    }

    public void setFont(Font font) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    public void setForeground(Color color) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foregroundRGBA = color.handle;
        this.data.foregroundPattern = null;
        this.data.state &= 0xFFFFFFFE;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

