/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.ImageLoaderListener;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public class ImageLoader {
    public ImageData[] data;
    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int backgroundPixel;
    public int repeatCount;
    public int compression;
    List<ImageLoaderListener> imageLoaderListeners;

    public ImageLoader() {
        this.reset();
    }

    void reset() {
        this.data = null;
        this.logicalScreenWidth = 0;
        this.logicalScreenHeight = 0;
        this.backgroundPixel = -1;
        this.repeatCount = 1;
        this.compression = -1;
    }

    public ImageData[] load(InputStream stream) {
        if (stream == null) {
            SWT.error(4);
        }
        this.reset();
        ImageData[] imgDataArray = this.getImageDataArrayFromStream(stream);
        this.data = imgDataArray;
        return imgDataArray;
    }

    boolean isInterlacedPNG(byte[] imageAsByteArray) {
        return imageAsByteArray.length > 28 && imageAsByteArray[28] != 0;
    }

    ImageData[] getImageDataArrayFromStream(InputStream stream) {
        long loader = GDK.gdk_pixbuf_loader_new();
        ArrayList<ImageData> imgDataList = new ArrayList<ImageData>();
        try {
            boolean isStatic;
            byte[] data_buffer = stream.readAllBytes();
            if (data_buffer.length == 0) {
                SWT.error(42);
            }
            long buffer_ptr = OS.g_malloc(data_buffer.length);
            C.memmove(buffer_ptr, data_buffer, (long)data_buffer.length);
            long[] error = new long[1];
            GDK.gdk_pixbuf_loader_write(loader, buffer_ptr, data_buffer.length, error);
            if (error[0] != 0L) {
                if (OS.g_error_matches(error[0], OS.g_file_error_quark(), 21)) {
                    SWT.error(39, null, Display.extractFreeGError(error[0]));
                } else {
                    OS.g_error_free(error[0]);
                }
            }
            GDK.gdk_pixbuf_loader_close(loader, null);
            long pixbuf_animation = GDK.gdk_pixbuf_loader_get_animation(loader);
            if (pixbuf_animation == 0L) {
                SWT.error(40);
            }
            if (isStatic = GDK.gdk_pixbuf_animation_is_static_image(pixbuf_animation)) {
                long pixbuf = GDK.gdk_pixbuf_animation_get_static_image(pixbuf_animation);
                ImageData imgData = ImageLoader.pixbufToImageData(pixbuf);
                imgData.type = this.getImageFormat(loader);
                imgDataList.add(imgData);
            } else {
                long start_time = OS.g_malloc(8L);
                OS.g_get_current_time(start_time);
                long animation_iter = GDK.gdk_pixbuf_animation_get_iter(pixbuf_animation, start_time);
                int delay_time = 0;
                int time_offset = 0;
                int num_frames = 32;
                int i = 0;
                while (i < num_frames) {
                    delay_time = GDK.gdk_pixbuf_animation_iter_get_delay_time(animation_iter);
                    OS.g_time_val_add(start_time, (time_offset += delay_time) * 1000);
                    boolean update = GDK.gdk_pixbuf_animation_iter_advance(animation_iter, start_time);
                    if (!update) break;
                    long curr_pixbuf = GDK.gdk_pixbuf_animation_iter_get_pixbuf(animation_iter);
                    long pixbuf_copy = GDK.gdk_pixbuf_copy(curr_pixbuf);
                    ImageData imgData = ImageLoader.pixbufToImageData(pixbuf_copy);
                    if (this.logicalScreenHeight == 0 && this.logicalScreenWidth == 0) {
                        this.logicalScreenHeight = imgData.height;
                        this.logicalScreenWidth = imgData.width;
                    }
                    OS.g_object_unref(pixbuf_copy);
                    imgData.type = this.getImageFormat(loader);
                    imgData.delayTime = delay_time;
                    imgDataList.add(imgData);
                    ++i;
                }
            }
            ImageData[] imgDataArray = new ImageData[imgDataList.size()];
            int i = 0;
            while (i < imgDataList.size()) {
                imgDataArray[i] = (ImageData)imgDataList.get(i);
                ImageData data = (ImageData)imgDataArray[i].clone();
                if (this.hasListeners() && imgDataArray != null) {
                    if (data.type == 5 && this.isInterlacedPNG(data_buffer)) {
                        this.notifyListeners(new ImageLoaderEvent(this, data, i, true));
                    } else if (data.type != 5) {
                        this.notifyListeners(new ImageLoaderEvent(this, data, i, true));
                    }
                }
                ++i;
            }
            OS.g_free(buffer_ptr);
            OS.g_object_unref(loader);
            stream.close();
            return imgDataArray;
        }
        catch (IOException e) {
            SWT.error(39);
            return null;
        }
    }

    public ImageData[] load(String filename) {
        if (filename == null) {
            SWT.error(4);
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream stream = new FileInputStream(filename);){
                return this.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            SWT.error(39, e);
            return null;
        }
    }

    int getImageFormat(long loader) {
        long format = GDK.gdk_pixbuf_loader_get_format(loader);
        long name = GDK.gdk_pixbuf_format_get_name(format);
        String nameStr = Converter.cCharPtrToJavaString(name, false);
        OS.g_free(name);
        return switch (nameStr) {
            case "bmp" -> 0;
            case "gif" -> 2;
            case "ico" -> 3;
            case "jpeg" -> 4;
            case "png" -> 5;
            case "tiff" -> 6;
            case "svg" -> 8;
            default -> -1;
        };
    }

    static ImageData pixbufToImageData(long pixbuf) {
        boolean hasAlpha = GDK.gdk_pixbuf_get_has_alpha(pixbuf);
        int width = GDK.gdk_pixbuf_get_width(pixbuf);
        int height = GDK.gdk_pixbuf_get_height(pixbuf);
        int stride = GDK.gdk_pixbuf_get_rowstride(pixbuf);
        int n_channels = GDK.gdk_pixbuf_get_n_channels(pixbuf);
        int bits_per_sample = GDK.gdk_pixbuf_get_bits_per_sample(pixbuf);
        long pixels = GDK.gdk_pixbuf_get_pixels(pixbuf);
        int lastRowWidth = width * ((n_channels * bits_per_sample + 7) / 8);
        byte[] srcData = new byte[stride * height];
        C.memmove(srcData, pixels, (long)(stride * (height - 1) + lastRowWidth));
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData imgData = new ImageData(width, height, bits_per_sample * n_channels, palette, stride, srcData);
        if (hasAlpha) {
            imgData.alphaData = new byte[width * height];
            byte[] alphaData = imgData.alphaData;
            int y = 0;
            int offset = 0;
            int alphaOffset = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    byte r = srcData[offset + 0];
                    byte g = srcData[offset + 1];
                    byte b = srcData[offset + 2];
                    byte a = srcData[offset + 3];
                    srcData[offset + 0] = 0;
                    alphaData[alphaOffset++] = a;
                    if (a != 0) {
                        srcData[offset + 1] = r;
                        srcData[offset + 2] = g;
                        srcData[offset + 3] = b;
                    }
                    ++x;
                    offset += n_channels;
                }
                ++y;
            }
        } else {
            int y = 0;
            int offset = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    byte r = srcData[offset + 0];
                    byte g = srcData[offset + 1];
                    byte b = srcData[offset + 2];
                    srcData[offset + 0] = r;
                    srcData[offset + 1] = g;
                    srcData[offset + 2] = b;
                    ++x;
                    offset += n_channels;
                }
                ++y;
            }
        }
        return imgData;
    }

    public boolean hasListeners() {
        return this.imageLoaderListeners != null && this.imageLoaderListeners.size() > 0;
    }

    public void notifyListeners(ImageLoaderEvent event) {
        if (!this.hasListeners()) {
            return;
        }
        int size = this.imageLoaderListeners.size();
        int i = 0;
        while (i < size) {
            ImageLoaderListener listener = this.imageLoaderListeners.get(i);
            listener.imageDataLoaded(event);
            ++i;
        }
    }
}

