/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.internal.image.PngChunk;

class PngIhdrChunk
extends PngChunk {
    static final int IHDR_DATA_LENGTH = 13;
    static final int WIDTH_DATA_OFFSET = 8;
    static final int HEIGHT_DATA_OFFSET = 12;
    static final int BIT_DEPTH_OFFSET = 16;
    static final int COLOR_TYPE_OFFSET = 17;
    static final int COMPRESSION_METHOD_OFFSET = 18;
    static final int FILTER_METHOD_OFFSET = 19;
    static final int INTERLACE_METHOD_OFFSET = 20;
    static final byte COLOR_TYPE_GRAYSCALE = 0;
    static final byte COLOR_TYPE_RGB = 2;
    static final byte COLOR_TYPE_PALETTE = 3;
    static final byte COLOR_TYPE_GRAYSCALE_WITH_ALPHA = 4;
    static final byte COLOR_TYPE_RGB_WITH_ALPHA = 6;
    static final int INTERLACE_METHOD_NONE = 0;
    static final int INTERLACE_METHOD_ADAM7 = 1;
    static final int FILTER_NONE = 0;
    static final int FILTER_SUB = 1;
    static final int FILTER_UP = 2;
    static final int FILTER_AVERAGE = 3;
    static final int FILTER_PAETH = 4;
    static final byte[] ValidBitDepths = new byte[]{1, 2, 4, 8, 16};
    static final byte[] ValidColorTypes;
    int width;
    int height;
    byte bitDepth;
    byte colorType;
    byte compressionMethod;
    byte filterMethod;
    byte interlaceMethod;

    static {
        byte[] byArray = new byte[5];
        byArray[1] = 2;
        byArray[2] = 3;
        byArray[3] = 4;
        byArray[4] = 6;
        ValidColorTypes = byArray;
    }

    String getColorTypeString() {
        return switch (this.colorType) {
            case 0 -> "Grayscale";
            case 2 -> "RGB";
            case 3 -> "Palette";
            case 4 -> "Grayscale with Alpha";
            case 6 -> "RGB with Alpha";
            default -> "Unknown - " + this.colorType;
        };
    }

    String getFilterMethodString() {
        return switch (this.filterMethod) {
            case 0 -> "None";
            case 1 -> "Sub";
            case 2 -> "Up";
            case 3 -> "Average";
            case 4 -> "Paeth";
            default -> "Unknown";
        };
    }

    String getInterlaceMethodString() {
        return switch (this.interlaceMethod) {
            case 0 -> "Not Interlaced";
            case 1 -> "Interlaced - ADAM7";
            default -> "Unknown";
        };
    }

    @Override
    void contributeToString(StringBuilder buffer) {
        buffer.append("\n\tWidth: ");
        buffer.append(this.width);
        buffer.append("\n\tHeight: ");
        buffer.append(this.height);
        buffer.append("\n\tBit Depth: ");
        buffer.append(this.bitDepth);
        buffer.append("\n\tColor Type: ");
        buffer.append(this.getColorTypeString());
        buffer.append("\n\tCompression Method: ");
        buffer.append(this.compressionMethod);
        buffer.append("\n\tFilter Method: ");
        buffer.append(this.getFilterMethodString());
        buffer.append("\n\tInterlace Method: ");
        buffer.append(this.getInterlaceMethodString());
    }
}

