/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.IME;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;
    boolean blink;
    boolean drawFlag;

    Canvas() {
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    @Override
    Point getIMCaretPos() {
        if (this.caret == null) {
            return super.getIMCaretPos();
        }
        return new Point(this.caret.x, this.caret.y);
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        long result;
        if (this.ime != null && (result = this.ime.gtk_button_press_event(widget, event)) != 0L) {
            return result;
        }
        return super.gtk_button_press_event(widget, event);
    }

    @Override
    long gtk_commit(long imcontext, long text) {
        long result;
        if (this.ime != null && (result = this.ime.gtk_commit(imcontext, text)) != 0L) {
            return result;
        }
        return super.gtk_commit(imcontext, text);
    }

    @Override
    long gtk_draw(long widget, long cairo) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        long result = super.gtk_draw(widget, cairo);
        this.drawCaretInFocus(widget, cairo);
        return result;
    }

    void drawCaretInFocus(long widget, long cairo) {
        if (this.caret != null && this.blink && this.caret.isFocusCaret()) {
            this.drawCaret(widget, cairo);
            this.blink = false;
        }
    }

    private void drawCaret(long widget, long cairo) {
        if (this.isDisposed()) {
            return;
        }
        if (cairo == 0L) {
            this.error(2);
        }
        if (this.drawFlag) {
            Cairo.cairo_save(cairo);
            if (this.caret.image != null && !this.caret.image.isDisposed() && this.caret.image.mask == 0L) {
                Cairo.cairo_set_source_rgb(cairo, 1.0, 1.0, 1.0);
                Cairo.cairo_set_operator(cairo, 23);
                long surface = Cairo.cairo_get_target(cairo);
                int nWidth = 0;
                switch (Cairo.cairo_surface_get_type(surface)) {
                    case 0: {
                        nWidth = Cairo.cairo_image_surface_get_width(surface);
                        break;
                    }
                    case 3: {
                        nWidth = Cairo.cairo_xlib_surface_get_width(surface);
                    }
                }
                int nX = this.caret.x;
                if ((this.style & 0x8000000) != 0) {
                    nX = this.getClientWidth() - nWidth - nX;
                }
                Cairo.cairo_translate(cairo, nX, this.caret.y);
                Cairo.cairo_set_source_surface(cairo, this.caret.image.surface, 0.0, 0.0);
                Cairo.cairo_paint(cairo);
            } else {
                Cairo.cairo_set_source_rgb(cairo, 1.0, 1.0, 1.0);
                Cairo.cairo_set_operator(cairo, 23);
                int nWidth = this.caret.width;
                int nHeight = this.caret.height;
                if (nWidth <= 0) {
                    nWidth = 1;
                }
                int nX = this.caret.x;
                if ((this.style & 0x8000000) != 0) {
                    nX = this.getClientWidth() - nWidth - nX;
                }
                Cairo.cairo_rectangle(cairo, nX, this.caret.y, nWidth, nHeight);
            }
            Cairo.cairo_fill(cairo);
            Cairo.cairo_restore(cairo);
            if (this.caret.embeddedInto == null) {
                this.drawFlag = false;
            }
        } else {
            this.drawFlag = true;
        }
    }

    @Override
    long gtk_focus_in_event(long widget, long event) {
        long result = super.gtk_focus_in_event(widget, event);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return result;
    }

    @Override
    long gtk_focus_out_event(long widget, long event) {
        long result = super.gtk_focus_out_event(widget, event);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return result;
    }

    @Override
    long gtk_preedit_changed(long imcontext) {
        long result;
        if (this.ime != null && (result = this.ime.gtk_preedit_changed(imcontext)) != 0L) {
            return result;
        }
        return super.gtk_preedit_changed(imcontext);
    }

    @Override
    void redrawWidget(int x, int y, int width, int height, boolean redrawAll, boolean all, boolean trim) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        super.redrawWidget(x, y, width, height, redrawAll, all, trim);
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.caret != null) {
            this.caret.reskin(flags);
        }
        if (this.ime != null) {
            this.ime.reskin(flags);
        }
        super.reskinChildren(flags);
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        int result = super.setBounds(x, y, width, height, move, resize);
        if (isFocus) {
            this.caret.setFocus();
        }
        return result;
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret newCaret = caret;
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.hasFocus()) {
            if (oldCaret != null) {
                oldCaret.killFocus();
            }
            if (newCaret != null) {
                if (newCaret.isDisposed()) {
                    this.error(5);
                }
                newCaret.setFocus();
            }
        }
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    public void setIME(IME ime) {
        this.checkWidget();
        if (ime != null && ime.isDisposed()) {
            this.error(5);
        }
        this.ime = ime;
    }
}

