/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_kxv extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "grinwic m\u012bn bel\u0101",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "epi\u0101 m\u0101n\u0101nka bel\u0101",
               "",
               "epi\u0101 del\u0101it bel\u0101",
               "",
               "epi\u0101 bel\u0101",
               "",
            };
        final String[] Cook = new String[] {
               "kuk d\u012bp m\u0101n\u0101nka bel\u0101",
               "",
               "kuk d\u012bp \u0101d\u0101 k\u0101r~\u0101 bel\u0101",
               "",
               "kuk d\u012bp bel\u0101",
               "",
            };
        final String[] Cuba = new String[] {
               "kub\u0101 m\u0101n\u0101nka bel\u0101",
               "CST",
               "kub\u0101 del\u0101i\u1e6d bel\u0101",
               "CDT",
               "kub\u0101 bel\u0101",
               "CT",
            };
        final String[] Fiji = new String[] {
               "piji m\u0101n\u0101nka bel\u0101",
               "",
               "piji k\u0101r~\u0101 bel\u0101",
               "",
               "piji bel\u0101",
               "",
            };
        final String[] Gulf = new String[] {
               "galp m\u0101n\u0101nka bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "hwo\u1e0d m\u0101n\u0101nka bel\u0101",
               "",
               "hwo\u1e0d k\u0101r~\u0101 bel\u0101",
               "",
               "hwo\u1e0d bel\u0101",
               "",
            };
        final String[] Iran = new String[] {
               "ir\u0101n m\u0101n\u0101nka bel\u0101",
               "",
               "ir\u0101n \u1e0del\u0101i\u1e6d bel\u0101",
               "",
               "ir\u0101n bel\u0101",
               "",
            };
        final String[] Niue = new String[] {
               "ni\u016b bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "amska m\u0101n\u0101nka bel\u0101",
               "",
               "amska k\u0101r~\u0101 bel\u0101",
               "",
               "amska bel\u0101",
               "",
            };
        final String[] Peru = new String[] {
               "peru m\u0101n\u0101nka bel\u0101",
               "",
               "peru k\u0101r~\u0101 bel\u0101",
               "",
               "peru bel\u0101",
               "",
            };
        final String[] Truk = new String[] {
               "cuk bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "waka d\u012bpa bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "cili m\u0101n\u0101nka bel\u0101",
               "",
               "cili k\u0101r~\u0101 bel\u0101",
               "",
               "cini bel\u0101",
               "",
            };
        final String[] China = new String[] {
               "cin m\u0101n\u0101nka bel\u0101",
               "CST",
               "cin del\u0101i\u1e6d bel\u0101",
               "CDT",
               "cin bel\u0101",
               "CT",
            };
        final String[] Cocos = new String[] {
               "kokos d\u012bp bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "debis bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "b\u0101rat m\u0101n\u0101nka bel\u0101",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "j\u0101p\u0101n m\u0101n\u0101nka bel\u0101",
               "JST",
               "j\u0101p\u0101n \u1e0del\u0101i\u1e6d bel\u0101",
               "JDT",
               "j\u0101p\u0101n bel\u0101",
               "JT",
            };
        final String[] Korea = new String[] {
               "kori\u0101n m\u0101n\u0101nka bel\u0101",
               "KST",
               "kori\u0101n \u1e0del\u0101i\u1e6d bel\u0101",
               "KST",
               "kori\u0101n bel\u0101",
               "KST",
            };
        final String[] Nauru = new String[] {
               "n\u0101ur\u016b bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "nep\u0101l bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "p\u0101l\u0101u bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "sa\u0101moa m\u0101n\u0101nka bel\u0101",
               "SST",
               "sa\u0101moa \u1e0del\u0101i\u1e6d",
               "SST",
               "sa\u0101moa bel\u0101",
               "SST",
            };
        final String[] Syowa = new String[] {
               "saw\u0101 bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "\u1e6dang\u0101 m\u0101n\u0101nka bel\u0101",
               "",
               "\u1e6dang\u0101 k\u0101r~\u0101 bel\u0101",
               "",
               "\u1e6dang\u0101 bel\u0101",
               "",
            };
        final String[] Alaska = new String[] {
               "alaska mananka bel\u0101",
               "AKST",
               "alaska \u1e0delaai\u1e6d bel\u0101",
               "AKDT",
               "alaska bel\u0101",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "\u0101majon mananka bel\u0101",
               "",
               "\u0101majon kar\u00e3 masa bel\u0101",
               "",
               "\u0101majon bel\u0101",
               "",
            };
        final String[] Azores = new String[] {
               "ajores m\u0101n\u0101nka bel\u0101",
               "",
               "ajores k\u0101r~\u0101 bel\u0101",
               "",
               "ajores bel\u0101",
               "",
            };
        final String[] Bhutan = new String[] {
               "but\u0101n bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "bruneti d\u0101rus\u0101l\u0101m bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "is\u1e6dr d\u012bp m\u0101n\u0101nka bel\u0101",
               "",
               "is\u1e6dr d\u012bp k\u0101r~\u0101 bel\u0101",
               "",
               "is\u1e6dr d\u012bp bel\u0101",
               "",
            };
        final String[] Guyana = new String[] {
               "guy\u0101n bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "ijar\u0101\u012bl m\u0101n\u0101nka bel\u0101",
               "IST",
               "ijar\u0101\u012bl \u1e0del\u0101i\u1e6d bel\u0101",
               "IDT",
               "ijar\u0101\u012bl bel\u0101",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "kasr\u0101\u0113 bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "m\u0101wosn bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "mosko m\u0101n\u0101nka bel\u0101",
               "MSK",
               "mosko k\u0101r~\u0101 bel\u0101",
               "MSK",
               "mosko bel\u0101",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "pon\u0101pe bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "t\u0101hiti bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "t\u0101ip\u0113 m\u0101n\u0101nka bel\u0101",
               "CST",
               "t\u0101ip\u0113 \u1e0del\u0101i\u1e6d",
               "CDT",
               "t\u0101ip\u0113 bel\u0101",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "tuwal\u016b bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "wostak bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "walis a\u1e0d\u0113 pu\u1e6dun\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "\u0101rbi\u0101ti m\u0101n\u0101nka bel\u0101",
               "",
               "\u0101rbi\u0101ti del\u0101it bel\u0101",
               "",
               "\u0101rbi\u0101ti bel\u0101",
               "",
            };
        final String[] Armenia = new String[] {
               "\u0101rmeni\u0101 m\u0101n\u0101nka bel\u0101",
               "",
               "\u0101rmeni\u0101 k\u0101r~\u0101 bel\u0101",
               "",
               "\u0101rmeni\u0101 bel\u0101",
               "",
            };
        final String[] Bolivia = new String[] {
               "bolwi\u0101 bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "cy\u0101t\u0101m m\u0101n\u0101nka bel\u0101",
               "",
               "cy\u0101t\u0101m del\u0101it bel\u0101",
               "",
               "cy\u0101t\u0101m bel\u0101",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "smani jaga pruti bel\u0101",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "iqu\u0101\u1e0dor bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "gambiyr bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "jarji\u0101 m\u0101n\u0101nka bel\u0101",
               "",
               "jarji\u0101 k\u0101r~\u0101 bel\u0101",
               "",
               "jarj\u012b\u0101 bel\u0101",
               "",
            };
        final String[] Irkutsk = new String[] {
               "\u012brkustak m\u0101n\u0101nka bel\u0101",
               "",
               "\u012brkustak k\u0101r~\u0101 bel\u0101",
               "",
               "\u012brkustak bel\u0101",
               "",
            };
        final String[] Magadan = new String[] {
               "m\u0101g\u0101dan m\u0101n\u0101nka bel\u0101",
               "",
               "m\u0101g\u0101dan \u1e0del\u0101it bel\u0101",
               "",
               "m\u0101g\u0101dan bel\u0101",
               "",
            };
        final String[] Myanmar = new String[] {
               "mi\u00f1y\u0101m\u0101r bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "norpok d\u012bp m\u0101n\u0101nka bel\u0101",
               "",
               "norpok d\u012bp \u1e0del\u0101i\u1e6d bel\u0101",
               "",
               "norpok d\u012bp bel\u0101",
               "",
            };
        final String[] Noronha = new String[] {
               "parn~\u1e0do \u1e0de noroh\u0101~ m\u0101n\u0101nka bel\u0101",
               "",
               "parn~\u1e0do \u1e0de noroh\u0101~ k\u0101r~\u0101 bel\u0101",
               "",
               "parn~\u1e0do \u1e0de noroh\u0101~ bel\u0101",
               "",
            };
        final String[] Reunion = new String[] {
               "r\u012b\u016bn\u012ban bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "rot\u0113r\u0101 bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "soloman d\u012bpati bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "\u1e6dokel\u0101u bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "urguw\u0113 manaka bel\u0101",
               "",
               "urguw\u0113 k\u0101r~\u0101 bel\u0101",
               "",
               "urguw\u0113 bel\u0101",
               "",
            };
        final String[] Vanuatu = new String[] {
               "wanu\u0101t\u016b m\u0101n\u0101nka bel\u0101",
               "",
               "wanu\u0101t\u016b k\u0101r~\u0101 bel\u0101",
               "",
               "wanu\u0101t\u016b bel\u0101",
               "",
            };
        final String[] Yakutsk = new String[] {
               "yakustuk m\u0101n\u0101nka bel\u0101",
               "",
               "yakustuk k\u0101r~\u0101 bel\u0101",
               "",
               "yakustuk bel\u0101",
               "",
            };
        final String[] Atlantic = new String[] {
               "\u0101\u1e6dl\u0101n\u1e6dik m\u0101n\u0101nka bel\u0101",
               "AST",
               "\u0101\u1e6dl\u0101n\u1e6dik del\u0101i\u1e6d bel\u0101",
               "AST",
               "\u0101\u1e6dl\u0101n\u1e6dik bel\u0101",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "br\u0101jili\u0101 m\u0101n\u0101nka bel\u0101",
               "",
               "br\u0101jili\u0101 k\u0101r~\u0101 bel\u0101",
               "",
               "br\u0101jili\u0101 bel\u0101",
               "",
            };
        final String[] Chamorro = new String[] {
               "c\u0101mor m\u0101n\u0101nka bel\u0101",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "kolombi\u0101 m\u0101n\u0101nka bel\u0101",
               "",
               "kolombi\u0101 k\u0101r~\u0101 bel\u0101",
               "",
               "kolombi\u0101 bel\u0101",
               "",
            };
        final String[] Falkland = new String[] {
               "pakly\u0101n\u1e0d d\u012bpati m\u0101n\u0101nka bel\u0101",
               "",
               "pakly\u0101n\u1e0d d\u012bpati k\u0101r~\u0101 bel\u0101",
               "",
               "pakly\u0101n\u1e0d d\u012bpati bel\u0101",
               "",
            };
        final String[] Malaysia = new String[] {
               "malesi\u0101 bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "m\u0101ld\u012bp bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "\u016bl\u0101nbator m\u0101n\u0101nka bel\u0101",
               "",
               "\u016bl\u0101nbator k\u0101r~\u0101 bel\u0101",
               "",
               "\u016bl\u0101nbator bel\u0101",
               "",
            };
        final String[] Pakistan = new String[] {
               "p\u0101kist\u0101n m\u0101n\u0101nka bel\u0101",
               "PKT",
               "p\u0101kist\u0101n k\u0101r~\u0101 bel\u0101",
               "PKST",
               "p\u0101kist\u0101n bel\u0101",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "p\u0101r\u0101guy\u0113 m\u0101n\u0101nka bel\u0101",
               "",
               "p\u0101r\u0101guy\u0113 k\u0101r~\u0101 bel\u0101",
               "",
               "p\u0101r\u0101guy\u0113 bel\u0101",
               "",
            };
        final String[] Pitcairn = new String[] {
               "pi\u1e6dk\u0113ran bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "sak\u0101lin m\u0101n\u0101nka bel\u0101",
               "",
               "sak\u0101lin k\u0101r~\u0101 bel\u0101",
               "",
               "sak\u0101lin bel\u0101",
               "",
            };
        final String[] Suriname = new String[] {
               "sur\u012bn\u0101m bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "\u0101rjen\u1e6din\u0101 m\u0101n\u0101nka bel\u0101",
               "",
               "\u0101rjen\u1e6din\u0101 k\u0101r~\u0101 bel\u0101 bel\u0101",
               "",
               "\u0101rjen\u1e6din\u0101 bel\u0101",
               "",
            };
        final String[] Christmas = new String[] {
               "krism\u0101s d\u012bp bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "g\u0101l\u0101pogs bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hang kang m\u0101n\u0101nka bel\u0101",
               "HKT",
               "hang kang k\u0101r~\u0101 bel\u0101",
               "HKST",
               "hang kang bel\u0101",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "in\u1e0docin\u0101 bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "kirgijst\u0101n bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "la\u1e5b hawe m\u0101n\u0101nka bel\u0101",
               "",
               "la\u1e5b hawe \u1e0del\u0101i\u1e6d bel\u0101",
               "",
               "la\u1e5b hawe bel\u0101",
               "",
            };
        final String[] Marquesas = new String[] {
               "m\u0101rksas bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "mar\u012bsasm\u0101n\u0101nka bel\u0101",
               "",
               "mar\u012bsas k\u0101r~\u0101 bel\u0101",
               "",
               "mar\u012bsas bel\u0101",
               "",
            };
        final String[] Singapore = new String[] {
               "sing\u0101pur m\u0101n\u0101nka bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "wen\u0113zuel\u0101 bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "w\u0101lgogr\u0101\u1e0d m\u0101n\u0101nka bel\u0101",
               "MSK",
               "w\u0101lgogr\u0101\u1e0d k\u0101r~\u0101 bel\u0101",
               "MSK",
               "w\u0101lgogr\u0101\u1e0d bel\u0101",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "\u0101jerb\u0101ij\u0101n m\u0101n\u0101nka bel\u0101",
               "",
               "\u0101jerb\u0101ij\u0101n k\u0101r~\u0101 bel\u0101",
               "",
               "\u0101jerb\u0101ij\u0101n bel\u0101",
               "",
            };
        final String[] Bangladesh = new String[] {
               "b\u0101ngl\u0101des m\u0101n\u0101nka bel\u0101",
               "",
               "b\u0101ngl\u0101des k\u0101r~\u0101 bel\u0101",
               "",
               "b\u0101ngl\u0101des bel\u0101",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "kep b\u1e0d m\u0101n\u0101nka bel\u0101",
               "",
               "kep b\u1e0d k\u0101r~\u0101 bel\u0101",
               "",
               "kep b\u1e0d bel\u0101",
               "",
            };
        final String[] East_Timor = new String[] {
               "we\u1e0d\u0101hapu timor bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "s\u0113sels bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "t\u0101jikist\u0101n bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "uzw\u0113kist\u0101n m\u0101n\u0101nka bel\u0101",
               "",
               "uzw\u0113kist\u0101n k\u0101r\u00e3 bel\u0101",
               "",
               "uzw\u0113kist\u0101n bel\u0101",
               "",
            };
        final String[] Afghanistan = new String[] {
               "aapganistan bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "kr\u0101sn\u014drska m\u0101n\u0101nka bel\u0101",
               "",
               "kr\u0101sn\u014drska k\u0101r~\u0101 bel\u0101",
               "",
               "kr\u0101sn\u014drska bel\u0101",
               "",
            };
        final String[] New_Zealand = new String[] {
               "ni\u016bjil\u0101n\u1e0d m\u0101n\u0101nka bel\u0101",
               "NZST",
               "ni\u016bjil\u0101n\u1e0d \u1e0del\u0101i\u1e6d bel\u0101",
               "NZDT",
               "ni\u016bjil\u0101n\u1e0d bel\u0101",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "nawosibisrk m\u0101n\u0101nka bel\u0101",
               "",
               "nawosibisrk k\u0101r~\u0101 bel\u0101",
               "",
               "nawosibisrk bel\u0101",
               "",
            };
        final String[] Philippines = new String[] {
               "pilipin m\u0101n\u0101nka bel\u0101",
               "PST",
               "pilipin k\u0101r~\u0101 bel\u0101",
               "PDT",
               "pilipin bel\u0101",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "wl\u0101diwostak m\u0101n\u0101nka bel\u0101",
               "",
               "wl\u0101diwostak k\u0101r~\u0101 bel\u0101",
               "",
               "wl\u0101diwostak bel\u0101",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "b\u0101rat k\u0101j\u0101 bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "l\u0101in d\u012bp bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "ni\u016bpaun\u1e0dly\u0101n\u1e0d m\u0101n\u0101nka bel\u0101",
               "NST",
               "ni\u016bpaun\u1e0dly\u0101n\u1e0d \u1e0del\u0101i\u1e6d bel\u0101",
               "NDT",
               "ni\u016bpaun\u1e0dly\u0101n\u1e0d bel\u0101",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "turkmenist\u0101n manaka bel\u0101",
               "",
               "turkmenist\u0101n k\u0101r~\u0101 bel\u0101",
               "",
               "turkmenist\u0101n bel\u0101",
               "",
            };
        final String[] French_Guiana = new String[] {
               "prench guy\u0101n bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "ni\u016b kele\u1e0doni\u0101 m\u0101n\u0101nka bel\u0101",
               "",
               "ni\u016b kele\u1e0doni\u0101 k\u0101r~\u0101 bel\u0101",
               "",
               "ni\u016b kele\u1e0doni\u0101 bel\u0101",
               "",
            };
        final String[] South_Georgia = new String[] {
               "dk\u012b\u1e47a jarj\u012b\u0101 bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "yakaterinbarg m\u0101n\u0101nka bel\u0101",
               "",
               "yakaterinbarg k\u0101r~\u0101 bel\u0101",
               "",
               "yakaterinbarg bel\u0101",
               "",
            };
        final String[] Africa_Central = new String[] {
               "madini aaprika bel\u0101",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "ve\u1e0da hpu aaprika bel\u0101",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "ve\u1e0da ku\u1e47pu aaprika mananka bel\u0101",
               "WAT",
               "ve\u1e0da ku\u1e47pu aaprika kar\u00e3 bel\u0101",
               "WAT",
               "ve\u1e0daku\u1e47pu aaprika bel\u0101",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "\u1e0dumon\u1e6d \u1e0di arwil\u0113 bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "m\u0101din\u0101 yuropi\u0101ti m\u0101n\u0101nka bel\u0101",
               "CET",
               "m\u0101din\u0101 yuropi\u0101ti k\u0101r~\u0101 bel\u0101",
               "CEST",
               "m\u0101din\u0101 yuropi\u0101ti bel\u0101",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "we\u1e0d\u0101hpu yuropi\u0101ti m\u0101n\u0101nka bel\u0101",
               "EET",
               "we\u1e0d\u0101hpu yuropi\u0101ti k\u0101r~\u0101 bel\u0101",
               "EEST",
               "we\u1e0d\u0101hpu yuropi\u0101ti bel\u0101",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "we\u1e0d\u0101k\u016b\u1e47\u016bpu yuropi\u0101ti m\u0101n\u0101nka bel\u0101",
               "WET",
               "we\u1e0d\u0101k\u016b\u1e47\u016bpu yuropi\u0101ti k\u0101r~\u0101 bel\u0101",
               "WEST",
               "we\u1e0d\u0101k\u016b\u1e47\u016bpu yuropi\u0101ti bel\u0101",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "meksik\u0101n pesipic m\u0101n\u0101nka bel\u0101",
               "MST",
               "meksik\u0101n pesipic \u1e0del\u0101i\u1e6d bel\u0101",
               "MDT",
               "meksik\u0101n pesipic bel\u0101",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "dki\u1e47 aaprika bel\u0101",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "madin\u012b mananka bel\u0101",
               "CST",
               "madin\u012b \u1e0delaai\u1e6d bel\u0101",
               "CDT",
               "madin\u012b bel\u0101",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "ve\u1e0dahapu mananka bel\u0101",
               "EST",
               "ve\u1e0dahapu \u1e0delaai\u1e6d bel\u0101",
               "EST",
               "ve\u1e0dahapu bel\u0101",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "pesipik mananka bel\u0101",
               "PST",
               "pesipik \u1e0delaai\u1e6d bel\u0101",
               "PDT",
               "pesipik bel\u0101",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "prenc daki\u1e47 a\u1e0de aan\u1e6d\u0101rk\u1e6dik bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "g\u012blbr\u1e6d d\u012bp bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "h\u0101w\u0101e- aal\u016bs\u0101n m\u0101n\u0101nka bel\u0101",
               "HST",
               "h\u0101w\u0101e- aal\u016bs\u0101n \u1e0del\u0101i\u1e6d bel\u0101",
               "HST",
               "h\u0101w\u0101e- aal\u016bs\u0101n bel\u0101",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "piniksa d\u012bpati bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "s\u0113n\u1e6d pier\u0113 a\u1e0d\u0113 mekw\u0113l\u0101n m\u0101n\u0101nka bel\u0101",
               "",
               "s\u0113n\u1e6d pier\u0113 a\u1e0d\u0113 mekw\u0113l\u0101n \u1e0del\u0101i\u1e6d bel\u0101",
               "",
               "s\u0113n\u1e6d pier\u0113 a\u1e0d\u0113 mekw\u0113l\u0101n bel\u0101",
               "",
            };
        final String[] America_Mountain = new String[] {
               "harka mananka bel\u0101",
               "MST",
               "harka \u1e0delaai\u1e6d bel\u0101",
               "MST",
               "harka bel\u0101",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "m\u0101rs\u0101l d\u012bpa bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "p\u0101pu\u0101 niu gun\u012b\u0101 bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "\u0101streli\u0101ti m\u0101din\u0101 m\u0101n\u0101nka bel\u0101",
               "ACST",
               "\u0101streli\u0101ti m\u0101din\u0101 del\u0101i\u1e6d bel\u0101",
               "ACDT",
               "m\u0101din\u0101 \u0101streli\u0101 bel\u0101",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0101streli\u0101ti we\u1e0d\u0101hap\u016b m\u0101n\u0101nka bel\u0101",
               "AEST",
               "\u0101streli\u0101ti we\u1e0d\u0101hap\u016b del\u0101iti bel\u0101",
               "AEDT",
               "we\u1e0d\u0101hapu \u0101strali\u0101 bel\u0101",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "\u0101streli\u0101ti we\u1e0d\u0101ku\u1e47up\u016b m\u0101n\u0101nka bel\u0101",
               "AWST",
               "\u0101streli\u0101ti we\u1e0d\u0101ku\u1e47up\u016b del\u0101i\u1e6d bel\u0101",
               "AWDT",
               "we\u1e0d\u0101ku\u1e47up\u016b \u0101streli\u0101 bel\u0101",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "m\u0101dini in\u1e0dnesi\u0101 bel\u0101",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "we\u1e0d\u0101hpu in\u1e0dnesi\u0101 bel\u0101",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "we\u1e0d\u0101k\u016b\u1e47p\u016b in\u1e0dnesi\u0101 bel\u0101",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "we\u1e0d\u0101k\u016b\u1e47p\u016b k\u0101j\u0101kst\u0101n bel\u0101",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0101streli\u0101ti m\u0101din\u0101 we\u1e0d\u0101ku\u1e47upu m\u0101n\u0101nka bel\u0101",
               "",
               "\u0101streli\u0101ti m\u0101din\u0101 we\u1e0d\u0101ku\u1e47upu del\u0101i\u1e6d bel\u0101",
               "",
               "\u0101streli\u0101ti m\u0101din\u0101 we\u1e0d\u0101ku\u1e47upu bel\u0101",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "grinwic m\u012bn bel\u0101",
                    "GMT",
                    "bri\u1e6dis kar\u00e3 masa bel\u0101",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "smani jaga pruti bel\u0101",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "grinwic m\u012bn bel\u0101",
                    "GMT",
                    "aairis manaka bel\u0101",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "smani jaga pruti bel\u0101",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "smani jaga pruti bel\u0101",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "grinwic m\u012bn bel\u0101",
                    "GMT",
                    "bri\u1e6dis kar\u00e3 masa bel\u0101",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "smani jaga pruti bel\u0101",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "smani jaga pruti bel\u0101",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "smani jaga pruti bel\u0101",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "grinwic m\u012bn bel\u0101",
                    "GMT",
                    "aairis manaka bel\u0101",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "grinwic m\u012bn bel\u0101",
                    "GMT",
                    "bri\u1e6dis kar\u00e3 masa bel\u0101",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "grinwic m\u012bn bel\u0101",
                    "GMT",
                    "bri\u1e6dis kar\u00e3 masa bel\u0101",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "grinwic m\u012bn bel\u0101",
                    "GMT",
                    "bri\u1e6dis kar\u00e3 masa bel\u0101",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "grinwic m\u012bn bel\u0101",
                    "GMT",
                    "bri\u1e6dis kar\u00e3 masa bel\u0101",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "grinwic m\u012bn bel\u0101",
                    "GMT",
                    "bri\u1e6dis kar\u00e3 masa bel\u0101",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "e\u1e0den" },
            { "timezone.excity.Asia/Baku", "baku" },
            { "timezone.excity.Asia/Dili", "\u1e0dili" },
            { "timezone.excity.Asia/Gaza", "gaja" },
            { "timezone.excity.Asia/Hovd", "hovd" },
            { "timezone.excity.Asia/Omsk", "omsk" },
            { "timezone.excity.Asia/Oral", "oral" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "amman" },
            { "timezone.excity.Asia/Aqtau", "aktau" },
            { "timezone.excity.Asia/Chita", "cita" },
            { "timezone.excity.Asia/Dhaka", "\u1e0daka" },
            { "timezone.excity.Asia/Dubai", "dubai" },
            { "timezone.excity.Asia/Kabul", "kabul" },
            { "timezone.excity.Asia/Macau", "mkao" },
            { "timezone.excity.Asia/Qatar", "katar" },
            { "timezone.excity.Asia/Seoul", "seol" },
            { "timezone.excity.Asia/Tokyo", "\u1e6dokyo" },
            { "timezone.excity.Asia/Tomsk", "\u1e6domsk" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "juba" },
            { "timezone.excity.Africa/Lome", "lom" },
            { "timezone.excity.Asia/Almaty", "alma\u1e6dy" },
            { "timezone.excity.Asia/Anadyr", "ana\u1e0dir" },
            { "timezone.excity.Asia/Aqtobe", "aaktobe" },
            { "timezone.excity.Asia/Atyrau", "atarau" },
            { "timezone.excity.Asia/Beirut", "beirut" },
            { "timezone.excity.Asia/Brunei", "brunei" },
            { "timezone.excity.Asia/Hebron", "hebron" },
            { "timezone.excity.Asia/Kuwait", "kuvait" },
            { "timezone.excity.Asia/Manila", "man\u012bla" },
            { "timezone.excity.Asia/Muscat", "maskat" },
            { "timezone.excity.Asia/Riyadh", "riyad" },
            { "timezone.excity.Asia/Saigon", "ho ci minh siti" },
            { "timezone.excity.Asia/Taipei", "taipei" },
            { "timezone.excity.Asia/Tehran", "tehran" },
            { "timezone.excity.Asia/Urumqi", "urumci" },
            { "timezone.excity.Etc/Unknown", "pu\u1e47a\u00e3 ti ga\u1e0da" },
            { "timezone.excity.Europe/Kiev", "kiyv" },
            { "timezone.excity.Europe/Oslo", "oslo" },
            { "timezone.excity.Europe/Riga", "riga" },
            { "timezone.excity.Europe/Rome", "rom" },
            { "timezone.excity.Indian/Mahe", "mahe" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "ecra" },
            { "timezone.excity.Africa/Cairo", "kairo" },
            { "timezone.excity.Africa/Ceuta", "seu\u1e6da" },
            { "timezone.excity.Africa/Dakar", "\u1e0dkar" },
            { "timezone.excity.Africa/Lagos", "lagos" },
            { "timezone.excity.Africa/Tunis", "\u1e6dunis" },
            { "timezone.excity.America/Adak", "a\u1e0dak" },
            { "timezone.excity.America/Lima", "lima" },
            { "timezone.excity.America/Nome", "nom" },
            { "timezone.excity.Asia/Baghdad", "bagdad" },
            { "timezone.excity.Asia/Bahrain", "bahrain" },
            { "timezone.excity.Asia/Bangkok", "bangkok" },
            { "timezone.excity.Asia/Barnaul", "barnaul" },
            { "timezone.excity.Asia/Bishkek", "biskek" },
            { "timezone.excity.Asia/Colombo", "kolombo" },
            { "timezone.excity.Asia/Irkutsk", "irku\u1e6dsk" },
            { "timezone.excity.Asia/Jakarta", "jakarta" },
            { "timezone.excity.Asia/Karachi", "karac\u012b" },
            { "timezone.excity.Asia/Kuching", "kucing" },
            { "timezone.excity.Asia/Magadan", "mega\u1e0dan" },
            { "timezone.excity.Asia/Nicosia", "nikosiya" },
            { "timezone.excity.Asia/Rangoon", "yangon" },
            { "timezone.excity.Asia/Tbilisi", "tbilisi" },
            { "timezone.excity.Asia/Thimphu", "timphu" },
            { "timezone.excity.Asia/Yakutsk", "yaku\u1e6dsk" },
            { "timezone.excity.Asia/Yerevan", "yerevan" },
            { "timezone.excity.Europe/Kirov", "kirov" },
            { "timezone.excity.Europe/Malta", "mal\u1e6da" },
            { "timezone.excity.Europe/Minsk", "minsk" },
            { "timezone.excity.Europe/Paris", "paris" },
            { "timezone.excity.Europe/Sofia", "sopiya" },
            { "timezone.excity.Europe/Vaduz", "va\u1e0duj" },
            { "timezone.excity.Indian/Cocos", "kokos" },
            { "timezone.excity.Pacific/Apia", "apia" },
            { "timezone.excity.Pacific/Fiji", "piji" },
            { "timezone.excity.Pacific/Guam", "guam" },
            { "timezone.excity.Pacific/Niue", "niue" },
            { "timezone.excity.Pacific/Truk", "c\u016bk" },
            { "timezone.excity.Pacific/Wake", "vek" },
            { "timezone.excity.Africa/Asmera", "asmara" },
            { "timezone.excity.Africa/Bamako", "bamako" },
            { "timezone.excity.Africa/Bangui", "bangui" },
            { "timezone.excity.Africa/Banjul", "banjul" },
            { "timezone.excity.Africa/Bissau", "bissau" },
            { "timezone.excity.Africa/Douala", "duala" },
            { "timezone.excity.Africa/Harare", "hrare" },
            { "timezone.excity.Africa/Kigali", "kigali" },
            { "timezone.excity.Africa/Luanda", "luan\u1e0da" },
            { "timezone.excity.Africa/Lusaka", "lusaka" },
            { "timezone.excity.Africa/Malabo", "malabo" },
            { "timezone.excity.Africa/Maputo", "mapu\u1e6du" },
            { "timezone.excity.Africa/Maseru", "maseru" },
            { "timezone.excity.Africa/Niamey", "niyame" },
            { "timezone.excity.America/Aruba", "aruba" },
            { "timezone.excity.America/Bahia", "bahia" },
            { "timezone.excity.America/Belem", "belem" },
            { "timezone.excity.America/Boise", "bois\u012b" },
            { "timezone.excity.America/Jujuy", "huhue" },
            { "timezone.excity.America/Sitka", "sitka" },
            { "timezone.excity.America/Thule", "tule" },
            { "timezone.excity.Asia/Ashgabat", "asgaba\u1e6d" },
            { "timezone.excity.Asia/Calcutta", "kolkata" },
            { "timezone.excity.Asia/Damascus", "\u1e0damaskus" },
            { "timezone.excity.Asia/Dushanbe", "dusambe" },
            { "timezone.excity.Asia/Jayapura", "jayapura" },
            { "timezone.excity.Asia/Katmandu", "ka\u1e6dman\u1e0du" },
            { "timezone.excity.Asia/Khandyga", "kandiga" },
            { "timezone.excity.Asia/Makassar", "makasar" },
            { "timezone.excity.Asia/Qostanay", "kos\u1e6dane" },
            { "timezone.excity.Asia/Sakhalin", "sahalin" },
            { "timezone.excity.Asia/Shanghai", "sengai" },
            { "timezone.excity.Asia/Tashkent", "tasken\u1e6d" },
            { "timezone.excity.Asia/Ust-Nera", "yust-nera" },
            { "timezone.excity.Europe/Athens", "etens" },
            { "timezone.excity.Europe/Berlin", "berlin" },
            { "timezone.excity.Europe/Dublin", "\u1e0dblin" },
            { "timezone.excity.Europe/Jersey", "jersi" },
            { "timezone.excity.Europe/Lisbon", "lisbon" },
            { "timezone.excity.Europe/London", "ln\u1e0dn" },
            { "timezone.excity.Europe/Madrid", "me\u1e0dri\u1e0d" },
            { "timezone.excity.Europe/Monaco", "monako" },
            { "timezone.excity.Europe/Moscow", "mosko" },
            { "timezone.excity.Europe/Prague", "prag" },
            { "timezone.excity.Europe/Samara", "samara" },
            { "timezone.excity.Europe/Skopje", "skopi" },
            { "timezone.excity.Europe/Tirane", "\u1e6dirane" },
            { "timezone.excity.Europe/Vienna", "vienna" },
            { "timezone.excity.Europe/Warsaw", "varsa" },
            { "timezone.excity.Europe/Zagreb", "tegusigalpa" },
            { "timezone.excity.Europe/Zurich", "juric" },
            { "timezone.excity.Indian/Chagos", "chagos" },
            { "timezone.excity.Indian/Comoro", "komoro" },
            { "timezone.excity.Pacific/Efate", "ipe\u1e6de" },
            { "timezone.excity.Pacific/Nauru", "nauru" },
            { "timezone.excity.Pacific/Palau", "palau" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "abidjan" },
            { "timezone.excity.Africa/Algiers", "alj\u012byrs" },
            { "timezone.excity.Africa/Conakry", "konakr\u012b" },
            { "timezone.excity.Africa/Kampala", "kmpala" },
            { "timezone.excity.Africa/Mbabane", "mbabane" },
            { "timezone.excity.Africa/Nairobi", "nairobi" },
            { "timezone.excity.Africa/Tripoli", "tripoli" },
            { "timezone.excity.America/Belize", "belij" },
            { "timezone.excity.America/Bogota", "bogo\u1e6da" },
            { "timezone.excity.America/Cancun", "kankun" },
            { "timezone.excity.America/Cayman", "keiman" },
            { "timezone.excity.America/Cuiaba", "kuaaba" },
            { "timezone.excity.America/Dawson", "\u1e0daosn" },
            { "timezone.excity.America/Denver", "\u1e0denver" },
            { "timezone.excity.America/Guyana", "guyana" },
            { "timezone.excity.America/Havana", "havana" },
            { "timezone.excity.America/Inuvik", "in\u016bvik" },
            { "timezone.excity.America/Juneau", "junov" },
            { "timezone.excity.America/La_Paz", "la paj" },
            { "timezone.excity.America/Maceio", "mas\u012bo" },
            { "timezone.excity.America/Manaus", "manaus" },
            { "timezone.excity.America/Merida", "meri\u1e0da" },
            { "timezone.excity.America/Nassau", "nasau" },
            { "timezone.excity.America/Panama", "panama" },
            { "timezone.excity.America/Recife", "resipi" },
            { "timezone.excity.America/Regina", "rejina" },
            { "timezone.excity.Asia/Famagusta", "pamagusta" },
            { "timezone.excity.Asia/Hong_Kong", "hong kong" },
            { "timezone.excity.Asia/Jerusalem", "jerusalem" },
            { "timezone.excity.Asia/Kamchatka", "kamca\u1e6dka" },
            { "timezone.excity.Asia/Pontianak", "pon\u1e6dianak" },
            { "timezone.excity.Asia/Pyongyang", "pyongyang" },
            { "timezone.excity.Asia/Qyzylorda", "kijuorda" },
            { "timezone.excity.Asia/Samarkand", "samarkand" },
            { "timezone.excity.Asia/Singapore", "singapor" },
            { "timezone.excity.Asia/Vientiane", "vien\u1e6diaan" },
            { "timezone.excity.Europe/Andorra", "aa\u1e47\u1e0dora" },
            { "timezone.excity.Europe/Saratov", "sara\u1e6dov" },
            { "timezone.excity.Europe/Tallinn", "talin" },
            { "timezone.excity.Europe/Vatican", "va\u1e6dikan" },
            { "timezone.excity.Europe/Vilnius", "vilnius" },
            { "timezone.excity.Indian/Mayotte", "mayo\u1e6d" },
            { "timezone.excity.Indian/Reunion", "reunion" },
            { "timezone.excity.Pacific/Easter", "\u012bster" },
            { "timezone.excity.Pacific/Kanton", "kan\u1e6don" },
            { "timezone.excity.Pacific/Kosrae", "kisrae" },
            { "timezone.excity.Pacific/Majuro", "majuro" },
            { "timezone.excity.Pacific/Midway", "mi\u1e0dvay" },
            { "timezone.excity.Pacific/Noumea", "numie" },
            { "timezone.excity.Pacific/Ponape", "ponpei" },
            { "timezone.excity.Pacific/Saipan", "saipan" },
            { "timezone.excity.Pacific/Tahiti", "\u1e6dahi\u1e6di" },
            { "timezone.excity.Pacific/Tarawa", "tarava" },
            { "timezone.excity.Pacific/Wallis", "vallis" },
            { "timezone.excity.Africa/Blantyre", "blan\u1e6daer" },
            { "timezone.excity.Africa/Djibouti", "jibuti" },
            { "timezone.excity.Africa/El_Aaiun", "el aaiyun" },
            { "timezone.excity.Africa/Freetown", "pr\u012b\u1e6daun" },
            { "timezone.excity.Africa/Gaborone", "gaboron" },
            { "timezone.excity.Africa/Khartoum", "kar\u1e6doum" },
            { "timezone.excity.Africa/Kinshasa", "kinsasa" },
            { "timezone.excity.Africa/Monrovia", "monrovia" },
            { "timezone.excity.Africa/Ndjamena", "njamena" },
            { "timezone.excity.Africa/Sao_Tome", "sao \u1e6dom" },
            { "timezone.excity.Africa/Windhoek", "vindhuk" },
            { "timezone.excity.America/Antigua", "en\u1e6digua" },
            { "timezone.excity.America/Caracas", "karakas" },
            { "timezone.excity.America/Cayenne", "keyen" },
            { "timezone.excity.America/Chicago", "cikago" },
            { "timezone.excity.America/Cordoba", "kor\u1e0daba" },
            { "timezone.excity.America/Creston", "kres\u1e6don" },
            { "timezone.excity.America/Curacao", "kyuraso" },
            { "timezone.excity.America/Detroit", "\u1e0de\u1e6droi\u1e6d" },
            { "timezone.excity.America/Godthab", "n\u016bk" },
            { "timezone.excity.America/Grenada", "grena\u1e0da" },
            { "timezone.excity.America/Halifax", "helipaks" },
            { "timezone.excity.America/Iqaluit", "ikalui\u1e6d" },
            { "timezone.excity.America/Jamaica", "jamaika" },
            { "timezone.excity.America/Managua", "managua" },
            { "timezone.excity.America/Marigot", "marigo\u1e6d" },
            { "timezone.excity.America/Mendoza", "men\u1e0doja" },
            { "timezone.excity.America/Moncton", "monk\u1e6don" },
            { "timezone.excity.America/Noronha", "noronha" },
            { "timezone.excity.America/Ojinaga", "ojinaga" },
            { "timezone.excity.America/Phoenix", "piniks" },
            { "timezone.excity.America/Tijuana", "tihvana" },
            { "timezone.excity.America/Toronto", "\u1e6doron\u1e6do" },
            { "timezone.excity.America/Tortola", "\u1e6dor\u1e6dola" },
            { "timezone.excity.America/Yakutat", "yaku\u1e6da\u1e6d" },
            { "timezone.excity.Asia/Choibalsan", "koibalsan" },
            { "timezone.excity.Asia/Phnom_Penh", "pnom penh" },
            { "timezone.excity.Atlantic/Azores", "ajores" },
            { "timezone.excity.Atlantic/Canary", "keneri" },
            { "timezone.excity.Atlantic/Faeroe", "pero" },
            { "timezone.excity.Australia/Eucla", "yukla" },
            { "timezone.excity.Australia/Perth", "pert" },
            { "timezone.excity.Europe/Belgrade", "belgra\u1e0de" },
            { "timezone.excity.Europe/Brussels", "brussels" },
            { "timezone.excity.Europe/Budapest", "bu\u1e0dapest" },
            { "timezone.excity.Europe/Busingen", "busingen" },
            { "timezone.excity.Europe/Chisinau", "kisinau" },
            { "timezone.excity.Europe/Guernsey", "gernsi" },
            { "timezone.excity.Europe/Helsinki", "helsinki" },
            { "timezone.excity.Europe/Istanbul", "istanbul" },
            { "timezone.excity.Europe/Sarajevo", "sarajevo" },
            { "timezone.excity.Indian/Maldives", "maldives" },
            { "timezone.excity.Pacific/Chatham", "ce\u1e6dam" },
            { "timezone.excity.Pacific/Fakaofo", "pakaopo" },
            { "timezone.excity.Pacific/Gambier", "gambier" },
            { "timezone.excity.Pacific/Norfolk", "norpok" },
            { "timezone.excity.Africa/Bujumbura", "bujumbura" },
            { "timezone.excity.Africa/Mogadishu", "moga\u1e0disu" },
            { "timezone.excity.America/Anguilla", "enguilla" },
            { "timezone.excity.America/Asuncion", "esunsion" },
            { "timezone.excity.America/Barbados", "barba\u1e0dos" },
            { "timezone.excity.America/Dominica", "\u1e0dominika" },
            { "timezone.excity.America/Edmonton", "e\u1e0dmon\u1e6don" },
            { "timezone.excity.America/Eirunepe", "eirunepe" },
            { "timezone.excity.America/Mazatlan", "masa\u1e6dlan" },
            { "timezone.excity.America/Miquelon", "mikvil\u00f5" },
            { "timezone.excity.America/New_York", "niyu york" },
            { "timezone.excity.America/Resolute", "rejalyu\u1e6d" },
            { "timezone.excity.America/Santarem", "satari" },
            { "timezone.excity.America/Santiago", "san\u1e6diago" },
            { "timezone.excity.America/St_Johns", "sen\u1e6d jons" },
            { "timezone.excity.America/St_Kitts", "sent ki\u1e6d\u1e6ds" },
            { "timezone.excity.America/St_Lucia", "sent lusia" },
            { "timezone.excity.America/Winnipeg", "vinnipeg" },
            { "timezone.excity.Antarctica/Casey", "kesee" },
            { "timezone.excity.Antarctica/Davis", "\u1e0devis" },
            { "timezone.excity.Antarctica/Syowa", "syova" },
            { "timezone.excity.Antarctica/Troll", "\u1e6droll" },
            { "timezone.excity.Asia/Krasnoyarsk", "krasneyarsk" },
            { "timezone.excity.Asia/Novosibirsk", "novosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "ulanba\u1e6dar" },
            { "timezone.excity.Asia/Vladivostok", "vla\u1e0divos\u1e6dok" },
            { "timezone.excity.Atlantic/Bermuda", "berm\u016bda" },
            { "timezone.excity.Atlantic/Madeira", "ma\u1e0diera" },
            { "timezone.excity.Atlantic/Stanley", "s\u1e6danli" },
            { "timezone.excity.Australia/Darwin", "\u1e0darvin" },
            { "timezone.excity.Australia/Hobart", "hobar\u1e6d" },
            { "timezone.excity.Australia/Sydney", "sy\u1e0dn\u012b" },
            { "timezone.excity.Europe/Amsterdam", "ams\u1e6der\u1e0dam" },
            { "timezone.excity.Europe/Astrakhan", "aas\u1e6drahan" },
            { "timezone.excity.Europe/Bucharest", "bukarest" },
            { "timezone.excity.Europe/Gibraltar", "jibral\u1e6dar" },
            { "timezone.excity.Europe/Ljubljana", "lyublyana" },
            { "timezone.excity.Europe/Mariehamn", "marieham" },
            { "timezone.excity.Europe/Podgorica", "p\u1e0dgoritsa" },
            { "timezone.excity.Europe/Stockholm", "s\u1e6dokhom" },
            { "timezone.excity.Europe/Ulyanovsk", "ulyanovsk" },
            { "timezone.excity.Europe/Volgograd", "volgogra\u1e0d" },
            { "timezone.excity.Indian/Christmas", "kris\u1e6dmas" },
            { "timezone.excity.Indian/Kerguelen", "kerguelen" },
            { "timezone.excity.Indian/Mauritius", "maurisius" },
            { "timezone.excity.Pacific/Auckland", "\u0101klan\u1e0d" },
            { "timezone.excity.Pacific/Funafuti", "punaputi" },
            { "timezone.excity.Pacific/Pitcairn", "pi\u1e6dkern" },
            { "timezone.excity.Africa/Casablanca", "kasablanka" },
            { "timezone.excity.Africa/Libreville", "librevill" },
            { "timezone.excity.Africa/Lubumbashi", "lubumbasi" },
            { "timezone.excity.Africa/Nouakchott", "nueksa" },
            { "timezone.excity.Africa/Porto-Novo", "por\u1e6do-\u1e47ovo" },
            { "timezone.excity.America/Anchorage", "ankoraj" },
            { "timezone.excity.America/Araguaina", "aragvaina" },
            { "timezone.excity.America/Boa_Vista", "boa vista" },
            { "timezone.excity.America/Catamarca", "katamarka" },
            { "timezone.excity.America/Chihuahua", "chihuahua" },
            { "timezone.excity.America/Fortaleza", "portaleja" },
            { "timezone.excity.America/Glace_Bay", "glas bay" },
            { "timezone.excity.America/Goose_Bay", "goos be" },
            { "timezone.excity.America/Guatemala", "guatemala" },
            { "timezone.excity.America/Guayaquil", "guajakil" },
            { "timezone.excity.America/Matamoros", "ma\u1e6damoros" },
            { "timezone.excity.America/Menominee", "menomin\u012b" },
            { "timezone.excity.America/Monterrey", "mon\u1e6derre" },
            { "timezone.excity.America/Sao_Paulo", "sao paulo" },
            { "timezone.excity.America/St_Thomas", "sen\u1e6d tomas" },
            { "timezone.excity.America/Vancouver", "vank\u016bver" },
            { "timezone.excity.Antarctica/Mawson", "mavson" },
            { "timezone.excity.Antarctica/Palmer", "palmer" },
            { "timezone.excity.Antarctica/Vostok", "vos\u1e6dok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "kuala lumpur" },
            { "timezone.excity.Asia/Novokuznetsk", "nevokujne\u1e6dsk" },
            { "timezone.excity.Europe/Bratislava", "bra\u1e6dislava" },
            { "timezone.excity.Europe/Copenhagen", "kopenhagen" },
            { "timezone.excity.Europe/Luxembourg", "lksembrg" },
            { "timezone.excity.Europe/San_Marino", "san marino" },
            { "timezone.excity.Europe/Simferopol", "simperopol" },
            { "timezone.excity.Pacific/Galapagos", "galapagos" },
            { "timezone.excity.Pacific/Kwajalein", "kvajalein" },
            { "timezone.excity.Pacific/Marquesas", "markisas" },
            { "timezone.excity.Pacific/Pago_Pago", "pango pango" },
            { "timezone.excity.Pacific/Rarotonga", "rarotonga" },
            { "timezone.excity.Pacific/Tongatapu", "\u1e6donga\u1e6dapu" },
            { "timezone.excity.Africa/Addis_Ababa", "a\u1e0dis ababa" },
            { "timezone.excity.Africa/Brazzaville", "brajavill" },
            { "timezone.excity.Africa/Ouagadougou", "vagdugu" },
            { "timezone.excity.America/Costa_Rica", "kos\u1e6da rika" },
            { "timezone.excity.America/Grand_Turk", "gran\u1e0d \u1e6durk" },
            { "timezone.excity.America/Guadeloupe", "gua\u1e0deloupe" },
            { "timezone.excity.America/Hermosillo", "ermosijo" },
            { "timezone.excity.America/Kralendijk", "krelen\u1e0deik" },
            { "timezone.excity.America/Louisville", "louiville" },
            { "timezone.excity.America/Martinique", "mar\u1e6dinik" },
            { "timezone.excity.America/Metlakatla", "me\u1e6dlaka\u1e6dla" },
            { "timezone.excity.America/Montevideo", "mon\u1e6devidio" },
            { "timezone.excity.America/Montserrat", "mon\u1e6dserre\u1e6d" },
            { "timezone.excity.America/Paramaribo", "paramaribo" },
            { "timezone.excity.America/Rio_Branco", "rio branko" },
            { "timezone.excity.America/St_Vincent", "sen\u1e6d vinsen\u1e6d" },
            { "timezone.excity.America/Whitehorse", "vhai\u1e6dhors" },
            { "timezone.excity.Antarctica/McMurdo", "mek mur\u1e0do" },
            { "timezone.excity.Antarctica/Rothera", "rotera" },
            { "timezone.excity.Asia/Srednekolymsk", "sre\u1e0dnekolymsk" },
            { "timezone.excity.Asia/Yekaterinburg", "yikaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "reykyavik" },
            { "timezone.excity.Atlantic/St_Helena", "sent helena" },
            { "timezone.excity.Australia/Adelaide", "aedileid" },
            { "timezone.excity.Australia/Brisbane", "brisbane" },
            { "timezone.excity.Australia/Lindeman", "lin\u1e0derman" },
            { "timezone.excity.Europe/Isle_of_Man", "aail ap man" },
            { "timezone.excity.Europe/Kaliningrad", "kaliningra\u1e0d" },
            { "timezone.excity.Pacific/Kiritimati", "kiritimati" },
            { "timezone.excity.Africa/Johannesburg", "johannesburg" },
            { "timezone.excity.America/El_Salvador", "el salva\u1e0dor" },
            { "timezone.excity.America/Fort_Nelson", "phort nelsn" },
            { "timezone.excity.America/Los_Angeles", "los anjeles" },
            { "timezone.excity.America/Mexico_City", "meksico si\u1e6dy" },
            { "timezone.excity.America/Porto_Velho", "por\u1e6dp velho" },
            { "timezone.excity.America/Puerto_Rico", "puerto riko" },
            { "timezone.excity.America/Tegucigalpa", "tegu" },
            { "timezone.excity.Arctic/Longyearbyen", "lngyarbyen" },
            { "timezone.excity.Atlantic/Cape_Verde", "kep ver\u1e0de" },
            { "timezone.excity.Australia/Lord_Howe", "lor\u1e0d hove" },
            { "timezone.excity.Australia/Melbourne", "melborne" },
            { "timezone.excity.Indian/Antananarivo", "\u1e6dananariv" },
            { "timezone.excity.Pacific/Guadalcanal", "gua\u1e0dalkenal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "dar es salaam" },
            { "timezone.excity.America/Blanc-Sablon", "blank-sablon" },
            { "timezone.excity.America/Buenos_Aires", "buenous aires" },
            { "timezone.excity.America/Campo_Grande", "kampo gran\u1e0de" },
            { "timezone.excity.America/Danmarkshavn", "\u1e0danmarksavn" },
            { "timezone.excity.America/Dawson_Creek", "\u1e0daoson kr\u012bk" },
            { "timezone.excity.America/Indiana/Knox", "noks, in\u1e0diyana" },
            { "timezone.excity.America/Indianapolis", "in\u1e0dianapolis" },
            { "timezone.excity.America/Punta_Arenas", "pu\u1e47\u1e6da erenas" },
            { "timezone.excity.America/Rankin_Inlet", "rankin inled\u1e6d" },
            { "timezone.excity.America/Scoresbysund", "i\u1e6doko\u1e6dormi\u1e6d" },
            { "timezone.excity.Antarctica/Macquarie", "mekvari" },
            { "timezone.excity.Pacific/Bougainville", "bouganvill" },
            { "timezone.excity.Pacific/Port_Moresby", "por\u1e6d moresbi" },
            { "timezone.excity.America/Cambridge_Bay", "kembrij be" },
            { "timezone.excity.America/Coral_Harbour", "e\u1e6dikoken" },
            { "timezone.excity.America/Indiana/Vevay", "vivi, in\u1e0diyana" },
            { "timezone.excity.America/Lower_Princes", "lover princ\u2019s kuva\u1e6dar" },
            { "timezone.excity.America/Port_of_Spain", "por\u1e6d ap spain" },
            { "timezone.excity.America/Santo_Domingo", "sento \u1e0domingo" },
            { "timezone.excity.America/St_Barthelemy", "sen\u1e6d bartelemi" },
            { "timezone.excity.America/Swift_Current", "svip\u1e6d kurren\u1e6d" },
            { "timezone.excity.Australia/Broken_Hill", "broken hill" },
            { "timezone.excity.America/Bahia_Banderas", "baia ban\u1e0deras" },
            { "timezone.excity.America/Port-au-Prince", "port-au-prinse" },
            { "timezone.excity.Atlantic/South_Georgia", "dki\u1e47 jorjia" },
            { "timezone.excity.America/Argentina/Salta", "sal\u1e6da" },
            { "timezone.excity.America/Indiana/Marengo", "marengo, in\u1e0diyana" },
            { "timezone.excity.America/Indiana/Winamac", "vinamak, in\u1e0diyana" },
            { "timezone.excity.America/Argentina/Tucuman", "\u1e6duk\u016bmn" },
            { "timezone.excity.America/Argentina/Ushuaia", "usvaiya" },
            { "timezone.excity.America/Indiana/Tell_City", "\u1e6dell sity, in\u1e0diyana" },
            { "timezone.excity.America/Indiana/Vincennes", "vincens, in\u1e0diyana" },
            { "timezone.excity.Antarctica/DumontDUrville", "\u1e0dyumont de urvill" },
            { "timezone.excity.America/Argentina/La_Rioja", "la rioja" },
            { "timezone.excity.America/Argentina/San_Juan", "san huan" },
            { "timezone.excity.America/Argentina/San_Luis", "san luis" },
            { "timezone.excity.America/Indiana/Petersburg", "pi\u1e6dtrsberg, in\u1e0diyana" },
            { "timezone.excity.America/Kentucky/Monticello", "mon\u1e6disello, ken\u1e6duk\u012b" },
            { "timezone.excity.America/North_Dakota/Beulah", "biyula, uttar \u1e0dako\u1e6da" },
            { "timezone.excity.America/North_Dakota/Center", "ma\u1e0din\u012b uttar \u1e0dako\u1e6da" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "riyo gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "neu salem, uttar \u1e0dako\u1e6da" },
        };
        return data;
    }
}
