/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.launcher;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.launcher.AbstractLanguageLauncher;
import org.graalvm.launcher.Launcher;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Instrument;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotException;

public abstract class LanguageLauncherBase
extends Launcher {
    private static Engine tempEngine;
    private boolean seenPolyglot;
    private boolean helpTools;
    private boolean helpLanguages;
    private Launcher.VersionAction versionAction = Launcher.VersionAction.None;

    final boolean isPolyglot() {
        return this.seenPolyglot;
    }

    final void setPolyglot(boolean polyglot) {
        this.seenPolyglot = polyglot;
    }

    final void setupContextBuilder(Context.Builder builder) {
        Path logFile = this.getLogFile();
        if (logFile != null) {
            try {
                builder.logHandler(LanguageLauncherBase.newLogStream(logFile));
            }
            catch (IOException ioe) {
                throw this.abort(ioe);
            }
        }
        if (System.err != this.getError()) {
            builder.err((OutputStream)this.getError());
        }
        if (System.out != this.getOutput()) {
            builder.out((OutputStream)this.getOutput());
        }
    }

    static Engine getTempEngine() {
        if (tempEngine == null) {
            tempEngine = Engine.create();
        }
        return tempEngine;
    }

    protected void argumentsProcessingDone() {
        if (tempEngine != null) {
            tempEngine.close();
            tempEngine = null;
        }
    }

    @Override
    protected boolean runLauncherAction() {
        switch (this.versionAction) {
            case PrintAndExit: {
                this.printPolyglotVersions();
                return true;
            }
            case PrintAndContinue: {
                this.printPolyglotVersions();
                break;
            }
        }
        return super.runLauncherAction();
    }

    @Override
    protected boolean parseCommonOption(String defaultOptionPrefix, Map<String, String> polyglotOptions, boolean experimentalOptions, String arg) {
        switch (arg) {
            case "--help:tools": {
                this.helpTools = true;
                break;
            }
            case "--help:languages": {
                this.helpLanguages = true;
                break;
            }
            case "--polyglot": {
                this.seenPolyglot = true;
                break;
            }
            case "--version:graalvm": {
                this.versionAction = Launcher.VersionAction.PrintAndExit;
                break;
            }
            case "--show-version:graalvm": {
                this.versionAction = Launcher.VersionAction.PrintAndContinue;
                break;
            }
            default: {
                return super.parseCommonOption(defaultOptionPrefix, polyglotOptions, experimentalOptions, arg);
            }
        }
        return true;
    }

    void handlePolyglotException(PolyglotException e) {
        if (e.getMessage() != null) {
            System.err.println("ERROR: " + e.getMessage());
        }
        if (e.isInternalError()) {
            e.printStackTrace();
        }
        if (e.isExit()) {
            System.exit(e.getExitStatus());
        } else {
            System.exit(1);
        }
    }

    @Override
    protected void printDefaultHelp(OptionCategory helpCategory) {
        super.printDefaultHelp(helpCategory);
        this.launcherOption("--version:graalvm", "Print GraalVM version information and exit.");
        this.launcherOption("--show-version:graalvm", "Print GraalVM version information and continue execution.");
        this.launcherOption("--help:languages", "Print options for all installed languages.");
        this.launcherOption("--help:tools", "Print options for all installed tools.");
        this.launcherOption("--help:expert", "Print additional options for experts.");
        this.launcherOption("--help:internal", "Print internal options for debugging language implementations and tools.");
        this.printEngineOptions(LanguageLauncherBase.getTempEngine(), helpCategory);
    }

    @Override
    protected void maybePrintAdditionalHelp(OptionCategory helpCategory) {
        if (this.helpLanguages) {
            this.printLanguageOptions(LanguageLauncherBase.getTempEngine(), helpCategory);
            this.printOtherHelpCategory("language", "--help:languages");
        }
        if (this.helpTools) {
            this.printInstrumentOptions(LanguageLauncherBase.getTempEngine(), helpCategory);
            this.printOtherHelpCategory("tool", "--help:tools");
        }
    }

    protected void printPolyglotVersions() {
        Engine engine = LanguageLauncherBase.getTempEngine();
        String mode = LanguageLauncherBase.isAOT() ? "Native" : "JVM";
        this.println(engine.getImplementationName() + " " + mode + " Polyglot Engine Version " + engine.getVersion());
        this.println("Java Version " + System.getProperty("java.version"));
        this.println("Java VM Version " + System.getProperty("java.vm.version"));
        Path graalVMHome = Engine.findHome();
        if (graalVMHome != null) {
            this.println("GraalVM Home " + graalVMHome);
        }
        this.printLanguages(engine, true);
        this.printInstruments(engine, true);
    }

    @Override
    protected OptionDescriptor findOptionDescriptor(String group, String key) {
        OptionDescriptors descriptors = null;
        switch (group) {
            case "engine": {
                descriptors = LanguageLauncherBase.getTempEngine().getOptions();
                break;
            }
            default: {
                Engine engine = LanguageLauncherBase.getTempEngine();
                if (engine.getLanguages().containsKey(group)) {
                    descriptors = ((Language)engine.getLanguages().get(group)).getOptions();
                    break;
                }
                if (!engine.getInstruments().containsKey(group)) break;
                descriptors = ((Instrument)engine.getInstruments().get(group)).getOptions();
            }
        }
        if (descriptors == null) {
            return null;
        }
        return descriptors.get(key);
    }

    private void printEngineOptions(Engine engine, OptionCategory optionCategory) {
        List<Launcher.PrintableOption> engineOptions = LanguageLauncherBase.filterOptions(engine.getOptions(), optionCategory);
        if (!engineOptions.isEmpty()) {
            this.println(new String[0]);
            this.printOptions(engineOptions, LanguageLauncherBase.optionsTitle("engine", optionCategory), 2);
        }
    }

    private void printInstrumentOptions(Engine engine, OptionCategory optionCategory) {
        List options;
        HashMap<Instrument, List> instrumentsOptions = new HashMap<Instrument, List>();
        List<Instrument> instruments = LanguageLauncherBase.sortedInstruments(engine);
        for (Instrument instrument : instruments) {
            options = LanguageLauncherBase.filterOptions(instrument.getOptions(), optionCategory);
            if (options.isEmpty()) continue;
            instrumentsOptions.put(instrument, options);
        }
        if (!instrumentsOptions.isEmpty()) {
            this.println(new String[0]);
            this.println(LanguageLauncherBase.optionsTitle("tool", optionCategory));
            for (Instrument instrument : instruments) {
                options = (List)instrumentsOptions.get(instrument);
                if (options == null) continue;
                this.printOptions(options, "  " + instrument.getName() + ":", 4);
            }
        }
    }

    private void printLanguageOptions(Engine engine, OptionCategory optionCategory) {
        List options;
        HashMap<Language, List> languagesOptions = new HashMap<Language, List>();
        List<Language> languages = LanguageLauncherBase.sortedLanguages(engine);
        for (Language language : languages) {
            options = LanguageLauncherBase.filterOptions(language.getOptions(), optionCategory);
            if (options.isEmpty()) continue;
            languagesOptions.put(language, options);
        }
        if (!languagesOptions.isEmpty()) {
            this.println(new String[0]);
            this.println(LanguageLauncherBase.optionsTitle("language", optionCategory));
            for (Language language : languages) {
                options = (List)languagesOptions.get(language);
                if (options == null) continue;
                this.printOptions(options, "  " + language.getName() + ":", 4);
            }
        }
    }

    private void printLanguages(Engine engine, boolean printWhenEmpty) {
        if (engine.getLanguages().isEmpty()) {
            if (printWhenEmpty) {
                this.println("  Installed Languages: none");
            }
        } else {
            this.println("  Installed Languages:");
            ArrayList<Language> languages = new ArrayList<Language>(engine.getLanguages().size());
            int nameLength = 0;
            for (Language language : engine.getLanguages().values()) {
                languages.add(language);
                nameLength = Integer.max(nameLength, language.getName().length());
            }
            languages.sort(Comparator.comparing(Language::getId));
            String langFormat = "    %-" + nameLength + "s%s version %s%n";
            for (Language language : languages) {
                String host = "";
                String version = language.getVersion();
                if (version == null || version.length() == 0) {
                    version = "";
                }
                System.out.printf(langFormat, language.getName().isEmpty() ? "Unnamed" : language.getName(), host, version);
            }
        }
    }

    private void printInstruments(Engine engine, boolean printWhenEmpty) {
        if (engine.getInstruments().isEmpty()) {
            if (printWhenEmpty) {
                this.println("  Installed Tools: none");
            }
        } else {
            this.println("  Installed Tools:");
            List<Instrument> instruments = LanguageLauncherBase.sortedInstruments(engine);
            int nameLength = 0;
            for (Instrument instrument : instruments) {
                nameLength = Integer.max(nameLength, instrument.getName().length());
            }
            String instrumentFormat = "    %-" + nameLength + "s version %s%n";
            for (Instrument instrument : instruments) {
                String version = instrument.getVersion();
                if (version == null || version.length() == 0) {
                    version = "";
                }
                System.out.printf(instrumentFormat, instrument.getName().isEmpty() ? instrument.getId() : instrument.getName(), version);
            }
        }
    }

    private static List<Launcher.PrintableOption> filterOptions(OptionDescriptors descriptors, OptionCategory optionCategory) {
        ArrayList<Launcher.PrintableOption> options = new ArrayList<Launcher.PrintableOption>();
        for (OptionDescriptor descriptor : descriptors) {
            if (descriptor.isDeprecated() || !LanguageLauncherBase.sameCategory(descriptor, optionCategory)) continue;
            options.add(LanguageLauncherBase.asPrintableOption(descriptor));
        }
        return options;
    }

    private static boolean sameCategory(OptionDescriptor descriptor, OptionCategory optionCategory) {
        return descriptor.getCategory().ordinal() == optionCategory.ordinal();
    }

    void printOption(OptionCategory optionCategory, OptionDescriptor descriptor) {
        if (!descriptor.isDeprecated() && LanguageLauncherBase.sameCategory(descriptor, optionCategory)) {
            this.printOption(LanguageLauncherBase.asPrintableOption(descriptor));
        }
    }

    private static Launcher.PrintableOption asPrintableOption(OptionDescriptor descriptor) {
        StringBuilder key = new StringBuilder("--");
        key.append(descriptor.getName());
        Object defaultValue = descriptor.getKey().getDefaultValue();
        if (!(defaultValue instanceof Boolean) || defaultValue != Boolean.FALSE) {
            key.append("=<");
            key.append(descriptor.getKey().getType().getName());
            key.append(">");
        }
        return new Launcher.PrintableOption(key.toString(), descriptor.getHelp());
    }

    @Override
    protected void collectArguments(Set<String> options) {
        options.add("--help:languages");
        options.add("--help:tools");
        options.add("--version:graalvm");
        options.add("--show-version:graalvm");
        Engine engine = LanguageLauncherBase.getTempEngine();
        LanguageLauncherBase.addOptions(engine.getOptions(), options);
        for (Instrument instrument : engine.getInstruments().values()) {
            LanguageLauncherBase.addOptions(instrument.getOptions(), options);
        }
        String languageId = null;
        if (this instanceof AbstractLanguageLauncher) {
            languageId = ((AbstractLanguageLauncher)this).getLanguageId();
        }
        for (Language language : engine.getLanguages().values()) {
            if (language.getId().equals(languageId)) {
                for (OptionDescriptor descriptor : language.getOptions()) {
                    options.add("--" + descriptor.getName().substring(languageId.length() + 1));
                }
            }
            LanguageLauncherBase.addOptions(language.getOptions(), options);
        }
    }

    private static void addOptions(OptionDescriptors descriptors, Set<String> target) {
        for (OptionDescriptor descriptor : descriptors) {
            target.add("--" + descriptor.getName());
        }
    }

    static List<Language> sortedLanguages(Engine engine) {
        ArrayList<Language> languages = new ArrayList<Language>(engine.getLanguages().values());
        languages.sort(Comparator.comparing(Language::getId));
        return languages;
    }

    static List<Instrument> sortedInstruments(Engine engine) {
        ArrayList<Instrument> instruments = new ArrayList<Instrument>();
        for (Instrument instrument : engine.getInstruments().values()) {
            if (!instrument.getOptions().iterator().hasNext()) continue;
            instruments.add(instrument);
        }
        instruments.sort(Comparator.comparing(Instrument::getId));
        return instruments;
    }
}

