/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.impl;

import com.paterva.maltego.util.MachineIDProvider;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class MacAddressIDProvider
extends MachineIDProvider {
    private static String[] _macAddresses;

    @Override
    public String[] getIDCandidates(boolean appendRnd) {
        if (_macAddresses == null) {
            _macAddresses = this.findMacAddresses();
        }
        return _macAddresses;
    }

    private String[] findMacAddresses() {
        String[] addresses = null;
        try {
            addresses = MacAddressIDProvider.findByHostName(true);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (addresses != null && addresses.length > 0) {
            return addresses;
        }
        try {
            addresses = MacAddressIDProvider.findByInterface(true);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (addresses != null && addresses.length > 0) {
            return addresses;
        }
        try {
            addresses = MacAddressIDProvider.findByInterface(false);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (addresses != null && addresses.length > 0) {
            return addresses;
        }
        return new String[0];
    }

    private static String[] findByInterface(boolean ignoreVirtual) throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        ArrayList<String> candidates = new ArrayList<String>();
        while (interfaces.hasMoreElements()) {
            MacAddressIDProvider.addMacAddress(interfaces.nextElement(), candidates, ignoreVirtual);
        }
        return candidates.toArray(new String[candidates.size()]);
    }

    private static String[] findByHostName(boolean ignoreVirtual) throws UnknownHostException {
        InetAddress[] addresses = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
        ArrayList<String> candidates = new ArrayList<String>();
        for (InetAddress address : addresses) {
            try {
                NetworkInterface ni = NetworkInterface.getByInetAddress(address);
                MacAddressIDProvider.addMacAddress(ni, candidates, ignoreVirtual);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return candidates.toArray(new String[candidates.size()]);
    }

    private static void addMacAddress(NetworkInterface ni, List<String> candidates, boolean ignoreVirtual) throws SocketException {
        String mac = null;
        if (ni != null) {
            if (ignoreVirtual) {
                String display = ni.getDisplayName();
                if (!(display == null || (display = display.toLowerCase()).contains("virtual") || display.contains("vmware") || ni.isVirtual())) {
                    mac = MacAddressIDProvider.getMac(ni);
                }
            } else {
                mac = MacAddressIDProvider.getMac(ni);
            }
        }
        if (mac != null && !"00-00-00-00-00-00".equals(mac) && !candidates.contains(mac)) {
            candidates.add(mac);
        }
    }

    private static String getMac(NetworkInterface ni) throws SocketException {
        byte[] mac = ni.getHardwareAddress();
        if (mac == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            buffer.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
        }
        return buffer.toString();
    }
}

