/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.core.PrefixedFormInjector;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public abstract class AbstractCollectionFormInjector<T>
extends PrefixedFormInjector {
    private final Class collectionType;
    private final Pattern pattern;

    protected AbstractCollectionFormInjector(Class collectionType, Class genericType, String prefix, Pattern pattern, ResteasyProviderFactory factory) {
        super(genericType, prefix, factory);
        this.collectionType = collectionType;
        this.pattern = pattern;
    }

    @Override
    public Object inject(HttpRequest request, HttpResponse response, boolean unwrapAsync) {
        Object result = this.createInstance(this.collectionType);
        CompletionStage<Object> ret = null;
        for (String collectionPrefix : this.findMatchingPrefixesWithNoneEmptyValues((MultivaluedMap<String, String>)request.getDecodedFormParameters())) {
            Matcher matcher = this.pattern.matcher(collectionPrefix);
            matcher.matches();
            String key = matcher.group(1);
            Object value = super.doInject(collectionPrefix, request, response, unwrapAsync);
            if (value != null && value instanceof CompletionStage) {
                if (ret == null) {
                    ret = CompletableFuture.completedFuture(null);
                }
                ret = ret.thenCompose(v -> (CompletionStage)value).thenAccept(val -> this.addTo(result, key, val));
                continue;
            }
            this.addTo(result, key, value);
        }
        if (ret == null) {
            return result;
        }
        return ret.thenApply(v -> result);
    }

    private Set<String> findMatchingPrefixesWithNoneEmptyValues(MultivaluedMap<String, String> parameters) {
        HashSet<String> result = new HashSet<String>();
        for (String parameterName : parameters.keySet()) {
            Matcher matcher = this.pattern.matcher(parameterName);
            if (!matcher.lookingAt() || !this.hasValue((List)parameters.get((Object)parameterName))) continue;
            result.add(matcher.group(0));
        }
        return result;
    }

    protected abstract T createInstance(Class var1);

    protected abstract void addTo(T var1, String var2, Object var3);
}

