/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chat.box;

import com.paterva.maltego.chatapi.ChatRoom;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.util.Lookup;

public abstract class ChatWindowAddOns {
    public static final String PROP_ADDED = "chatWindowAddOnAdded";
    public static final String PROP_REMOVED = "chatWindowAddOnRemoved";
    private static ChatWindowAddOns _default;

    public static ChatWindowAddOns getDefault() {
        if (_default == null && (_default = (ChatWindowAddOns)Lookup.getDefault().lookup(ChatWindowAddOns.class)) == null) {
            _default = new Default();
        }
        return _default;
    }

    public abstract void add(ChatRoom var1, Component var2);

    public abstract void remove(ChatRoom var1, Component var2);

    public abstract Collection<Component> get(ChatRoom var1);

    public abstract void addPropertyChangeListener(ChatRoom var1, PropertyChangeListener var2);

    public abstract void removePropertyChangeListener(ChatRoom var1, PropertyChangeListener var2);

    private static class Default
    extends ChatWindowAddOns {
        private Map<ChatRoom, List<Component>> _addOns = new WeakHashMap<ChatRoom, List<Component>>();
        private Map<ChatRoom, List<PropertyChangeListener>> _listeners = new WeakHashMap<ChatRoom, List<PropertyChangeListener>>();

        private Default() {
        }

        @Override
        public void add(ChatRoom chatRoom, Component component) {
            List<Component> addOns = this._addOns.get(chatRoom);
            if (addOns == null) {
                addOns = new ArrayList<Component>();
                this._addOns.put(chatRoom, addOns);
            }
            addOns.add(component);
            this.fireAdded(chatRoom, component);
        }

        @Override
        public void remove(ChatRoom chatRoom, Component component) {
            List<Component> addOns = this._addOns.get(chatRoom);
            if (addOns != null) {
                addOns.remove(component);
                this.fireRemoved(chatRoom, component);
            }
        }

        @Override
        public Collection<Component> get(ChatRoom chatRoom) {
            List<Component> addOns = this._addOns.get(chatRoom);
            return addOns != null ? Collections.unmodifiableList(addOns) : Collections.EMPTY_LIST;
        }

        @Override
        public void addPropertyChangeListener(ChatRoom chatRoom, PropertyChangeListener listener) {
            List<PropertyChangeListener> listeners = this._listeners.get(chatRoom);
            if (listeners == null) {
                listeners = new ArrayList<PropertyChangeListener>();
                this._listeners.put(chatRoom, listeners);
            }
            listeners.add(listener);
        }

        @Override
        public void removePropertyChangeListener(ChatRoom chatRoom, PropertyChangeListener listener) {
            List<PropertyChangeListener> listeners = this._listeners.get(chatRoom);
            if (listeners != null) {
                listeners.remove(listener);
            }
        }

        private void fireAdded(ChatRoom chatRoom, Component component) {
            List<PropertyChangeListener> listeners = this._listeners.get(chatRoom);
            if (listeners != null) {
                for (PropertyChangeListener listener : listeners) {
                    listener.propertyChange(new PropertyChangeEvent(this, ChatWindowAddOns.PROP_ADDED, null, component));
                }
            }
        }

        private void fireRemoved(ChatRoom chatRoom, Component component) {
            List<PropertyChangeListener> listeners = this._listeners.get(chatRoom);
            if (listeners != null) {
                for (PropertyChangeListener listener : listeners) {
                    listener.propertyChange(new PropertyChangeEvent(this, ChatWindowAddOns.PROP_REMOVED, component, null));
                }
            }
        }
    }
}

