/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.control.AbstractBlockNode;
import com.oracle.truffle.js.nodes.control.YieldException;

public abstract class AbstractGeneratorBlockNode
extends AbstractBlockNode {
    @Node.Child
    protected JavaScriptNode readStateNode;
    @Node.Child
    protected WriteNode writeStateNode;

    protected AbstractGeneratorBlockNode(JavaScriptNode[] statements, JavaScriptNode readStateNode, WriteNode writeStateNode) {
        super(statements);
        this.readStateNode = readStateNode;
        this.writeStateNode = writeStateNode;
    }

    protected final int getStateAndReset(VirtualFrame frame) {
        Object value = this.readStateNode.execute(frame);
        int index = value instanceof Integer ? (Integer)value : 0;
        this.setState(frame, 0);
        return index;
    }

    protected final void setState(VirtualFrame frame, int index) {
        this.writeStateNode.executeWrite(frame, index);
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        int index = this.getStateAndReset(frame);
        assert (index < this.getStatements().length);
        this.block.executeVoid(frame, index);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int index = this.getStateAndReset(frame);
        assert (index < this.getStatements().length);
        return this.block.executeGeneric(frame, index);
    }

    @Override
    public void executeVoid(VirtualFrame frame, JavaScriptNode node, int index, int startIndex) {
        if (index < startIndex) {
            return;
        }
        try {
            node.executeVoid(frame);
        }
        catch (YieldException e) {
            this.setState(frame, index);
            throw e;
        }
    }

    @Override
    public Object executeGeneric(VirtualFrame frame, JavaScriptNode node, int index, int startIndex) {
        assert (index == this.getStatements().length - 1);
        try {
            return node.execute(frame);
        }
        catch (YieldException e) {
            this.setState(frame, index);
            throw e;
        }
    }
}

