/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.ui.view;

import com.paterva.maltego.certificates.CertificateRepository;
import com.paterva.maltego.certificates.CertificateTrustHandler;
import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.certificates.ui.view.CertificateTabbedView;
import com.paterva.maltego.util.ui.components.PanelWithMatteBorderAllSides;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.windows.WindowManager;

public class DefaultCertificateTrustHandler
extends CertificateTrustHandler {
    private static final Logger LOG = Logger.getLogger(DefaultCertificateTrustHandler.class.getName());
    private static final long BACKOFF_TIME = Duration.ofSeconds(1L).toMillis();
    private static long lastTrustPromptMillis = 0L;
    private final AtomicBoolean _showing = new AtomicBoolean(false);
    private final AtomicBoolean _uiReady = new AtomicBoolean(false);

    public DefaultCertificateTrustHandler() {
        WindowManager.getDefault().invokeWhenUIReady(() -> this._uiReady.set(true));
    }

    public CertificateTrustHandler.TrustResult handleCertificate(String message, X509Certificate[] chain, String url, boolean forceShowCertAction, boolean noTrustedCert, boolean testing, boolean overrideBackoff) {
        boolean backedOffEnough;
        X509Certificate cert = chain[0];
        CertificateTrustHandler.TrustResult trustResult = CertificateTrustHandler.TrustResult.CANCEL;
        CertificateTrustHandler.CertificateActions certAction = forceShowCertAction ? CertificateTrustHandler.CertificateActions.SHOW_STORE : this.mustShowTrustPrompt(cert, url, noTrustedCert);
        long time = System.currentTimeMillis();
        boolean bl = backedOffEnough = time - lastTrustPromptMillis > BACKOFF_TIME;
        if (this.mustShowTrustPrompt(certAction) && !testing && (backedOffEnough || overrideBackoff) && this._uiReady.get() && this._showing.compareAndSet(false, true)) {
            trustResult = CertificateTrustHandler.TrustResult.STILL_TO_CHOOSE;
            if (SwingUtilities.isEventDispatchThread()) {
                trustResult = this.showTrustPrompt(message, cert, url, certAction);
                this._showing.set(false);
            } else {
                CertificateTrustHandler.CertificateActions certActionLambda = certAction;
                try {
                    TrustResultHolder trh = new TrustResultHolder();
                    SwingUtilities.invokeAndWait(() -> {
                        CertificateTrustHandler.TrustResult result = this.showTrustPrompt(message, cert, url, certActionLambda);
                        this._showing.set(false);
                        trh.setTrustResult(result);
                    });
                    trustResult = trh.getTrustResult();
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return trustResult;
    }

    public CertificateTrustHandler.CertificateActions mustShowTrustPrompt(X509Certificate cert, String url, boolean noTrustedCert) {
        url = url == null ? null : CertificateUtils.stripUrl((String)url);
        CertificateTrustHandler.CertificateActions certAction = CertificateTrustHandler.CertificateActions.BLOCK;
        CertificateRepository certRepo = CertificateRepository.getDefault();
        URL urlObject = null;
        try {
            urlObject = new URL(url);
        }
        catch (MalformedURLException ex) {
            LOG.log(Level.WARNING, "Cannot create URL from string.", ex);
        }
        if (CertificateUtils.isValid((X509Certificate)cert)) {
            boolean shippedCert = CertificateUtils.isShippedCert((CertificateRepository)certRepo, (X509Certificate)cert);
            if (shippedCert) {
                certAction = CertificateTrustHandler.CertificateActions.ALLOW;
            } else if (CertificateUtils.isBlackListedInCertRepo((CertificateRepository)certRepo, (X509Certificate)cert)) {
                certAction = CertificateTrustHandler.CertificateActions.BLACKLISTED;
            } else if (CertificateUtils.hasParsableSansOrCN((X509Certificate)cert) && !CertificateUtils.urlMatchesSansOrCN((X509Certificate)cert, (URL)urlObject)) {
                certAction = CertificateTrustHandler.CertificateActions.BLOCK;
            } else if (!certRepo.contains(cert) && !certRepo.containsCa(cert)) {
                if (CertificateUtils.hasParsableSansOrCN((X509Certificate)cert)) {
                    if (CertificateUtils.urlMatchesSansOrCN((X509Certificate)cert, (URL)urlObject)) {
                        certAction = noTrustedCert ? CertificateTrustHandler.CertificateActions.SHOW_STORE : CertificateTrustHandler.CertificateActions.ALLOW;
                    }
                } else {
                    certAction = CertificateTrustHandler.CertificateActions.SHOW_STORE_ATTACH_HOSTNAME;
                }
            } else if (certRepo.contains(cert, true) || certRepo.containsCa(cert, true) && !certRepo.contains(cert)) {
                if (certRepo.containsCa(cert, true) && !certRepo.contains(cert) && !certRepo.isCaValid(cert)) {
                    certAction = CertificateTrustHandler.CertificateActions.DATE_INVALID;
                } else if (!CertificateUtils.hasParsableSansOrCN((X509Certificate)cert)) {
                    certAction = certRepo.urlMatchesCertHostnames(cert, urlObject) ? CertificateTrustHandler.CertificateActions.ALLOW : CertificateTrustHandler.CertificateActions.SHOW_ATTACH_HOSTNAME;
                } else if (CertificateUtils.urlMatchesSansOrCN((X509Certificate)cert, (URL)urlObject)) {
                    certAction = CertificateTrustHandler.CertificateActions.ALLOW;
                }
            }
        } else {
            certAction = CertificateTrustHandler.CertificateActions.DATE_INVALID;
        }
        return certAction;
    }

    private CertificateTrustHandler.TrustResult showTrustPrompt(String message, X509Certificate newCert, String url, CertificateTrustHandler.CertificateActions action) {
        String title = "Trust Certificate?";
        JButton trustButton = new JButton("Trust");
        JButton dontTrustButton = new JButton("Don't Trust");
        JButton cancelButton = new JButton("Cancel");
        Object[] options = new Object[]{trustButton, dontTrustButton, cancelButton};
        AtomicReference result = new AtomicReference();
        AtomicReference<Dialog> dialogRef = new AtomicReference<Dialog>();
        ActionListener listener = e -> {
            if (e.getSource() == trustButton) {
                result.set(CertificateTrustHandler.TrustResult.TRUST);
            } else if (e.getSource() == dontTrustButton) {
                result.set(CertificateTrustHandler.TrustResult.DONT_TRUST);
            } else {
                result.set(CertificateTrustHandler.TrustResult.CANCEL);
            }
            Dialog dialog = (Dialog)dialogRef.get();
            dialog.setVisible(false);
            dialog.dispose();
        };
        PanelWithMatteBorderAllSides panel = new PanelWithMatteBorderAllSides((LayoutManager)new BorderLayout());
        panel.add(new CertificateTabbedView(newCert, message));
        DialogDescriptor dd = new DialogDescriptor((Object)panel, title, true, options, (Object)trustButton, 0, HelpCtx.DEFAULT_HELP, listener);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialogRef.set(dialog);
        dialog.setVisible(true);
        CertificateTrustHandler.TrustResult trustResult = (CertificateTrustHandler.TrustResult)result.get();
        trustResult = trustResult != null ? trustResult : CertificateTrustHandler.TrustResult.STILL_TO_CHOOSE;
        lastTrustPromptMillis = System.currentTimeMillis();
        boolean updateCert = true;
        boolean forceTrust = false;
        CertificateRepository certRepo = CertificateRepository.getDefault();
        if (action != null) {
            switch (action) {
                case SHOW_STORE: {
                    url = null;
                    break;
                }
                case SHOW_STORE_ATTACH_HOSTNAME: {
                    if (trustResult == CertificateTrustHandler.TrustResult.TRUST) break;
                    url = null;
                    break;
                }
                case SHOW_ATTACH_HOSTNAME: {
                    if (trustResult == CertificateTrustHandler.TrustResult.TRUST) break;
                    updateCert = false;
                    boolean contains = certRepo.contains(newCert);
                    if (contains) break;
                    updateCert = true;
                    forceTrust = true;
                    url = null;
                    break;
                }
                default: {
                    updateCert = false;
                }
            }
        }
        if (updateCert) {
            switch (trustResult) {
                case TRUST: {
                    certRepo.update(newCert, true, url);
                    LOG.log(Level.INFO, "Trust Certificate? - trusting");
                    break;
                }
                case DONT_TRUST: {
                    certRepo.update(newCert, forceTrust, url);
                    LOG.log(Level.INFO, "Trust Certificate? - don't trust");
                    break;
                }
            }
        }
        return trustResult;
    }

    private class TrustResultHolder {
        private CertificateTrustHandler.TrustResult _trustResult = CertificateTrustHandler.TrustResult.STILL_TO_CHOOSE;

        private TrustResultHolder() {
        }

        public CertificateTrustHandler.TrustResult getTrustResult() {
            return this._trustResult;
        }

        public void setTrustResult(CertificateTrustHandler.TrustResult trustResult) {
            this._trustResult = trustResult;
        }
    }
}

