/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.matching.TypeToPropertiesMapMatchingRuleDescriptor;
import com.paterva.maltego.transform.protocol.v2api.EntityTranslator;
import com.paterva.maltego.transform.protocol.v2api.V2EntitySpecTranslator;
import com.paterva.maltego.transform.protocol.v2api.messaging.AdditionalField;
import com.paterva.maltego.transform.protocol.v2api.messaging.EntityDescriptor;
import com.paterva.maltego.util.Args;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class V2MatchingRuleDescriptor
extends TypeToPropertiesMapMatchingRuleDescriptor {
    public synchronized void reset(Set<String> types) {
        Args.notNull(types, (String)"types");
        types = types.stream().map(V2EntitySpecTranslator.getDefault()::getV3TypeName).collect(Collectors.toSet());
        super.reset(types);
    }

    public void update(Collection<EntityDescriptor> entities, EntityRegistry registry) {
        TreeSet<String> done = new TreeSet<String>();
        for (EntityDescriptor entity : entities) {
            if (done.contains(entity.getTypeName())) continue;
            this.update(entity, registry);
            done.add(entity.getTypeName());
        }
    }

    private void update(EntityDescriptor entity, EntityRegistry registry) {
        ArrayList<String> strictFields = new ArrayList<String>();
        EntityTranslator translator = EntityTranslator.instance();
        String type = V2EntitySpecTranslator.getDefault().getV3TypeName(entity.getTypeName());
        for (AdditionalField field : entity.getFields()) {
            if (!"strict".equals(field.getMatchingRule())) continue;
            strictFields.add(translator.v3PropertyName(entity, field.getName(), field.getName(), registry));
        }
        this.update(type, strictFields, true);
    }

    public boolean equals(Object obj) {
        return obj == null || obj instanceof V2MatchingRuleDescriptor;
    }
}

