/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.types;

import inet.ipaddr.IPAddressString;
import inet.ipaddr.ipv4.IPv4Address;
import java.util.Objects;

public class IPAddress {
    public static final int IPv4_BYTES = 4;
    public static final int IPv6_BYTES = 16;
    private final String creationString;
    private final inet.ipaddr.IPAddress address;
    private final String uncompressedIPv6;

    public static IPAddress parse(String value) {
        inet.ipaddr.IPAddress address = null;
        if (value != null) {
            value = value.trim().replace("-", "");
            IPAddressString ipStr = new IPAddressString(value);
            address = ipStr.getAddress();
        }
        if (address == null) {
            throw new IllegalArgumentException("Not an IP address: " + value);
        }
        return new IPAddress(value, address, address.toIPv6().toFullString());
    }

    private IPAddress(String creationString, inet.ipaddr.IPAddress address, String uncompressedIPv6) {
        this.creationString = creationString;
        this.address = address;
        this.uncompressedIPv6 = uncompressedIPv6;
    }

    public String getCreationString() {
        return this.creationString;
    }

    public String toStringCompressed() {
        return this.address.toCompressedString();
    }

    public String toStringIPv6Uncompressed() {
        return this.uncompressedIPv6;
    }

    public String toStringIPv4Compressed() {
        IPv4Address v4Address = this.address.toIPv4();
        return v4Address != null ? v4Address.toCompressedString() : this.address.toCompressedString();
    }

    public String toStringIPv6Compressed() {
        return this.address.toIPv6().toCompressedString();
    }

    public String toString() {
        return this.toStringCompressed();
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.uncompressedIPv6);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPAddress other = (IPAddress)obj;
        return Objects.equals(this.uncompressedIPv6, other.uncompressedIPv6);
    }
}

