/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, @CheckForNull Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, char p12) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12)));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, int p12) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, long p12) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, @CheckForNull Object p12) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, char p12, char p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), Character.valueOf(p22)));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, char p12, int p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), p22));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, char p12, long p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), p22));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, char p12, @CheckForNull Object p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), p22));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, int p12, char p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12, Character.valueOf(p22)));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, int p12, int p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, int p12, long p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, int p12, @CheckForNull Object p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, long p12, char p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12, Character.valueOf(p22)));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, long p12, int p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, long p12, long p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, long p12, @CheckForNull Object p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, char p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12, Character.valueOf(p22)));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, int p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, long p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, @CheckForNull Object p22) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, @CheckForNull Object p22, @CheckForNull Object p32) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12, p22, p32));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, @CheckForNull Object p22, @CheckForNull Object p32, @CheckForNull Object p42) {
        if (!expression) {
            throw new IllegalArgumentException(Strings.lenientFormat(errorMessageTemplate, p12, p22, p32, p42));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, @CheckForNull Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression, @CheckForNull String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, char p12) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12)));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, int p12) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, long p12) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, @CheckForNull Object p12) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, char p12, char p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), Character.valueOf(p22)));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, char p12, int p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), p22));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, char p12, long p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), p22));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, char p12, @CheckForNull Object p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), p22));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, int p12, char p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12, Character.valueOf(p22)));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, int p12, int p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, int p12, long p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, int p12, @CheckForNull Object p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, long p12, char p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12, Character.valueOf(p22)));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, long p12, int p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, long p12, long p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, long p12, @CheckForNull Object p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, char p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12, Character.valueOf(p22)));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, int p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, long p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, @CheckForNull Object p22) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, @CheckForNull Object p22, @CheckForNull Object p32) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12, p22, p32));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, @CheckForNull Object p22, @CheckForNull Object p32, @CheckForNull Object p42) {
        if (!expression) {
            throw new IllegalStateException(Strings.lenientFormat(errorMessageTemplate, p12, p22, p32, p42));
        }
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, @CheckForNull Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, char p12) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12)));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, int p12) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, long p12) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, @CheckForNull Object p12) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, char p12, char p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), Character.valueOf(p22)));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, char p12, int p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), p22));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, char p12, long p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), p22));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, char p12, @CheckForNull Object p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), p22));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, int p12, char p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12, Character.valueOf(p22)));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, int p12, int p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, int p12, long p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, int p12, @CheckForNull Object p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, long p12, char p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12, Character.valueOf(p22)));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, long p12, int p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, long p12, long p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, long p12, @CheckForNull Object p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, @CheckForNull Object p12, char p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12, Character.valueOf(p22)));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, @CheckForNull Object p12, int p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, @CheckForNull Object p12, long p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, @CheckForNull Object p12, @CheckForNull Object p22) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, @CheckForNull Object p12, @CheckForNull Object p22, @CheckForNull Object p32) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12, p22, p32));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, @CheckForNull Object p12, @CheckForNull Object p22, @CheckForNull Object p32, @CheckForNull Object p42) {
        if (reference == null) {
            throw new NullPointerException(Strings.lenientFormat(errorMessageTemplate, p12, p22, p32, p42));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int index, int size) {
        return Preconditions.checkElementIndex(index, size, "index");
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int index, int size, String desc) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(index, size, desc));
        }
        return index;
    }

    private static String badElementIndex(int index, int size, String desc) {
        if (index < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return Strings.lenientFormat("%s (%s) must be less than size (%s)", desc, index, size);
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int index, int size) {
        return Preconditions.checkPositionIndex(index, size, "index");
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int index, int size, String desc) {
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(index, size, desc));
        }
        return index;
    }

    private static String badPositionIndex(int index, int size, String desc) {
        if (index < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return Strings.lenientFormat("%s (%s) must not be greater than size (%s)", desc, index, size);
    }

    public static void checkPositionIndexes(int start, int end, int size) {
        if (start < 0 || end < start || end > size) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(start, end, size));
        }
    }

    private static String badPositionIndexes(int start, int end, int size) {
        if (start < 0 || start > size) {
            return Preconditions.badPositionIndex(start, size, "start index");
        }
        if (end < 0 || end > size) {
            return Preconditions.badPositionIndex(end, size, "end index");
        }
        return Strings.lenientFormat("end index (%s) must not be less than start index (%s)", end, start);
    }
}

