/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.i18nformatter.qual;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum I18nConversionCategory {
    UNUSED(null, null),
    GENERAL(null, null),
    DATE(new Class[]{Date.class, Number.class}, new String[]{"date", "time"}),
    NUMBER(new Class[]{Number.class}, new String[]{"number", "choice"});

    public final Class<?> @Nullable [] types;
    public final String @Nullable [] strings;
    private static final I18nConversionCategory[] namedCategories;
    private static final I18nConversionCategory[] conversionCategoriesForIntersect;

    private I18nConversionCategory(Class<?>[] types, String[] strings) {
        this.types = types;
        this.strings = strings;
    }

    public static I18nConversionCategory stringToI18nConversionCategory(String string) {
        string = string.toLowerCase();
        for (I18nConversionCategory v11 : namedCategories) {
            for (String s11 : v11.strings) {
                if (!s11.equals(string)) continue;
                return v11;
            }
        }
        throw new IllegalArgumentException("Invalid format type " + string);
    }

    private static <E> Set<E> arrayToSet(E[] a11) {
        return new HashSet<E>(Arrays.asList(a11));
    }

    public static boolean isSubsetOf(I18nConversionCategory a11, I18nConversionCategory b11) {
        return I18nConversionCategory.intersect(a11, b11) == a11;
    }

    public static I18nConversionCategory intersect(I18nConversionCategory a11, I18nConversionCategory b11) {
        if (a11 == UNUSED) {
            return b11;
        }
        if (b11 == UNUSED) {
            return a11;
        }
        if (a11 == GENERAL) {
            return b11;
        }
        if (b11 == GENERAL) {
            return a11;
        }
        Set<Class<Class<?>>> as2 = I18nConversionCategory.arrayToSet(a11.types);
        Set<Class<?>> bs2 = I18nConversionCategory.arrayToSet(b11.types);
        as2.retainAll(bs2);
        for (I18nConversionCategory v11 : conversionCategoriesForIntersect) {
            Set<Class<?>> vs2 = I18nConversionCategory.arrayToSet(v11.types);
            if (!vs2.equals(as2)) continue;
            return v11;
        }
        throw new RuntimeException();
    }

    public static I18nConversionCategory union(I18nConversionCategory a11, I18nConversionCategory b11) {
        if (a11 == UNUSED || b11 == UNUSED) {
            return UNUSED;
        }
        if (a11 == GENERAL || b11 == GENERAL) {
            return GENERAL;
        }
        if (a11 == DATE || b11 == DATE) {
            return DATE;
        }
        return NUMBER;
    }

    public boolean isAssignableFrom(Class<?> argType) {
        if (this.types == null) {
            return true;
        }
        if (argType == Void.TYPE) {
            return true;
        }
        for (Class<?> c11 : this.types) {
            if (!c11.isAssignableFrom(argType)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder(this.name());
        if (this.types == null) {
            sb2.append(" conversion category (all types)");
        } else {
            StringJoiner sj2 = new StringJoiner(", ", " conversion category (one of: ", ")");
            for (Class<?> cls : this.types) {
                sj2.add(cls.getCanonicalName());
            }
            sb2.append(sj2);
        }
        return sb2.toString();
    }

    static {
        namedCategories = new I18nConversionCategory[]{DATE, NUMBER};
        conversionCategoriesForIntersect = new I18nConversionCategory[]{DATE, NUMBER};
    }
}

