/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer.pool;

import com.android.tools.smali.dexlib2.HiddenApiRestriction;
import com.android.tools.smali.dexlib2.builder.MutableMethodImplementation;
import com.android.tools.smali.dexlib2.formatter.DexFormatter;
import com.android.tools.smali.dexlib2.iface.Annotation;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.ExceptionHandler;
import com.android.tools.smali.dexlib2.iface.Field;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.MethodImplementation;
import com.android.tools.smali.dexlib2.iface.MethodParameter;
import com.android.tools.smali.dexlib2.iface.TryBlock;
import com.android.tools.smali.dexlib2.iface.debug.DebugItem;
import com.android.tools.smali.dexlib2.iface.debug.EndLocal;
import com.android.tools.smali.dexlib2.iface.debug.LineNumber;
import com.android.tools.smali.dexlib2.iface.debug.RestartLocal;
import com.android.tools.smali.dexlib2.iface.debug.SetSourceFile;
import com.android.tools.smali.dexlib2.iface.debug.StartLocal;
import com.android.tools.smali.dexlib2.iface.instruction.DualReferenceInstruction;
import com.android.tools.smali.dexlib2.iface.instruction.Instruction;
import com.android.tools.smali.dexlib2.iface.instruction.ReferenceInstruction;
import com.android.tools.smali.dexlib2.iface.reference.CallSiteReference;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodHandleReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodProtoReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.dexlib2.iface.reference.StringReference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.iface.value.ArrayEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.EncodedValue;
import com.android.tools.smali.dexlib2.writer.ClassSection;
import com.android.tools.smali.dexlib2.writer.DebugWriter;
import com.android.tools.smali.dexlib2.writer.pool.AnnotationSetPool;
import com.android.tools.smali.dexlib2.writer.pool.BasePool;
import com.android.tools.smali.dexlib2.writer.pool.CallSitePool;
import com.android.tools.smali.dexlib2.writer.pool.DexPool;
import com.android.tools.smali.dexlib2.writer.pool.EncodedArrayPool;
import com.android.tools.smali.dexlib2.writer.pool.FieldPool;
import com.android.tools.smali.dexlib2.writer.pool.MethodHandlePool;
import com.android.tools.smali.dexlib2.writer.pool.MethodPool;
import com.android.tools.smali.dexlib2.writer.pool.PoolClassDef;
import com.android.tools.smali.dexlib2.writer.pool.PoolMethod;
import com.android.tools.smali.dexlib2.writer.pool.ProtoPool;
import com.android.tools.smali.dexlib2.writer.pool.StringPool;
import com.android.tools.smali.dexlib2.writer.pool.TypeListPool;
import com.android.tools.smali.dexlib2.writer.pool.TypePool;
import com.android.tools.smali.dexlib2.writer.util.StaticInitializerUtil;
import com.android.tools.smali.util.AbstractForwardSequentialList;
import com.android.tools.smali.util.CollectionUtils;
import com.android.tools.smali.util.ExceptionWithContext;
import com.android.tools.smali.util.TransformedIterable;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClassPool
extends BasePool<String, PoolClassDef>
implements ClassSection<CharSequence, CharSequence, TypeListPool.Key<? extends Collection<? extends CharSequence>>, PoolClassDef, Field, PoolMethod, Set<? extends Annotation>, ArrayEncodedValue> {
    private List<PoolClassDef> sortedClasses = null;
    private static final Predicate<MethodParameter> HAS_PARAMETER_ANNOTATIONS = new Predicate<MethodParameter>(){

        @Override
        public boolean test(MethodParameter input) {
            return input.getAnnotations().size() > 0;
        }
    };
    private static final Function<MethodParameter, Set<? extends Annotation>> PARAMETER_ANNOTATIONS = new Function<MethodParameter, Set<? extends Annotation>>(){

        @Override
        public Set<? extends Annotation> apply(MethodParameter input) {
            return input.getAnnotations();
        }
    };

    public ClassPool(@Nonnull DexPool dexPool) {
        super(dexPool);
    }

    public void intern(@Nonnull ClassDef classDef) {
        PoolClassDef poolClassDef = new PoolClassDef(classDef);
        PoolClassDef prev = this.internedItems.put(poolClassDef.getType(), poolClassDef);
        if (prev != null) {
            throw new ExceptionWithContext("Class %s has already been interned", poolClassDef.getType());
        }
        ((TypePool)this.dexPool.typeSection).intern(poolClassDef.getType());
        ((TypePool)this.dexPool.typeSection).internNullable(poolClassDef.getSuperclass());
        ((TypeListPool)this.dexPool.typeListSection).intern(poolClassDef.getInterfaces());
        ((StringPool)this.dexPool.stringSection).internNullable(poolClassDef.getSourceFile());
        HashSet<String> fields = new HashSet<String>();
        for (Field field : poolClassDef.getFields()) {
            String fieldDescriptor = DexFormatter.INSTANCE.getShortFieldDescriptor(field);
            if (!fields.add(fieldDescriptor)) {
                throw new ExceptionWithContext("Multiple definitions for field %s->%s", poolClassDef.getType(), fieldDescriptor);
            }
            ((FieldPool)this.dexPool.fieldSection).intern(field);
            EncodedValue initialValue = field.getInitialValue();
            if (initialValue != null) {
                this.dexPool.internEncodedValue(initialValue);
            }
            ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(field.getAnnotations());
            ArrayEncodedValue staticInitializers = this.getStaticInitializers(poolClassDef);
            if (staticInitializers == null) continue;
            ((EncodedArrayPool)this.dexPool.encodedArraySection).intern(staticInitializers);
        }
        HashSet<String> methods = new HashSet<String>();
        for (PoolMethod method : poolClassDef.getMethods()) {
            String methodDescriptor = DexFormatter.INSTANCE.getShortMethodDescriptor(method);
            if (!methods.add(methodDescriptor)) {
                throw new ExceptionWithContext("Multiple definitions for method %s->%s", poolClassDef.getType(), methodDescriptor);
            }
            ((MethodPool)this.dexPool.methodSection).intern(method);
            this.internCode(method);
            this.internDebug(method);
            ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(method.getAnnotations());
            for (MethodParameter methodParameter : method.getParameters()) {
                ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(methodParameter.getAnnotations());
            }
        }
        ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(poolClassDef.getAnnotations());
    }

    private void internCode(@Nonnull Method method) {
        boolean hasInstruction = false;
        MethodImplementation methodImpl = method.getImplementation();
        if (methodImpl != null) {
            for (Instruction instruction : methodImpl.getInstructions()) {
                hasInstruction = true;
                if (instruction instanceof ReferenceInstruction) {
                    ReferenceInstruction referenceInstruction = (ReferenceInstruction)instruction;
                    this.internReference(referenceInstruction.getReference(), referenceInstruction.getReferenceType());
                }
                if (!(instruction instanceof DualReferenceInstruction)) continue;
                DualReferenceInstruction dualReferenceInstruction = (DualReferenceInstruction)instruction;
                this.internReference(dualReferenceInstruction.getReference2(), dualReferenceInstruction.getReferenceType2());
            }
            List<? extends TryBlock<? extends ExceptionHandler>> tryBlocks = methodImpl.getTryBlocks();
            if (!hasInstruction && tryBlocks.size() > 0) {
                throw new ExceptionWithContext("Method %s has no instructions, but has try blocks.", method);
            }
            for (TryBlock<? extends ExceptionHandler> tryBlock : methodImpl.getTryBlocks()) {
                for (ExceptionHandler exceptionHandler : tryBlock.getExceptionHandlers()) {
                    ((TypePool)this.dexPool.typeSection).internNullable(exceptionHandler.getExceptionType());
                }
            }
        }
    }

    private void internReference(@Nonnull Reference reference, int referenceType) {
        switch (referenceType) {
            case 0: {
                ((StringPool)this.dexPool.stringSection).intern((StringReference)reference);
                break;
            }
            case 1: {
                ((TypePool)this.dexPool.typeSection).intern(((TypeReference)reference).getType());
                break;
            }
            case 2: {
                ((FieldPool)this.dexPool.fieldSection).intern((FieldReference)reference);
                break;
            }
            case 3: {
                ((MethodPool)this.dexPool.methodSection).intern((MethodReference)reference);
                break;
            }
            case 4: {
                ((ProtoPool)this.dexPool.protoSection).intern((MethodProtoReference)reference);
                break;
            }
            case 6: {
                ((MethodHandlePool)this.dexPool.methodHandleSection).intern((MethodHandleReference)reference);
                break;
            }
            case 5: {
                ((CallSitePool)this.dexPool.callSiteSection).intern((CallSiteReference)reference);
                break;
            }
            default: {
                throw new ExceptionWithContext("Unrecognized reference type: %d", referenceType);
            }
        }
    }

    private void internDebug(@Nonnull Method method) {
        for (MethodParameter methodParameter : method.getParameters()) {
            String string = methodParameter.getName();
            if (string == null) continue;
            ((StringPool)this.dexPool.stringSection).intern(string);
        }
        MethodImplementation methodImpl = method.getImplementation();
        if (methodImpl != null) {
            for (DebugItem debugItem : methodImpl.getDebugItems()) {
                switch (debugItem.getDebugItemType()) {
                    case 3: {
                        StartLocal startLocal = (StartLocal)debugItem;
                        ((StringPool)this.dexPool.stringSection).internNullable(startLocal.getName());
                        ((TypePool)this.dexPool.typeSection).internNullable(startLocal.getType());
                        ((StringPool)this.dexPool.stringSection).internNullable(startLocal.getSignature());
                        break;
                    }
                    case 9: {
                        ((StringPool)this.dexPool.stringSection).internNullable(((SetSourceFile)debugItem).getSourceFile());
                    }
                }
            }
        }
    }

    @Override
    @Nonnull
    public Collection<? extends PoolClassDef> getSortedClasses() {
        if (this.sortedClasses == null) {
            this.sortedClasses = CollectionUtils.immutableSortedCopy(this.internedItems.values(), CollectionUtils.usingToStringOrdering());
        }
        return this.sortedClasses;
    }

    @Override
    @Nullable
    public Map.Entry<? extends PoolClassDef, Integer> getClassEntryByType(@Nullable CharSequence name) {
        if (name == null) {
            return null;
        }
        final PoolClassDef classDef = (PoolClassDef)this.internedItems.get(name.toString());
        if (classDef == null) {
            return null;
        }
        return new Map.Entry<PoolClassDef, Integer>(){
            final /* synthetic */ ClassPool this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public PoolClassDef getKey() {
                return classDef;
            }

            @Override
            public Integer getValue() {
                return classDef.classDefIndex;
            }

            @Override
            public Integer setValue(Integer value) {
                classDef.classDefIndex = value;
                return classDef.classDefIndex;
            }
        };
    }

    @Override
    @Nonnull
    public CharSequence getType(@Nonnull PoolClassDef classDef) {
        return classDef.getType();
    }

    @Override
    public int getAccessFlags(@Nonnull PoolClassDef classDef) {
        return classDef.getAccessFlags();
    }

    @Override
    @Nullable
    public CharSequence getSuperclass(@Nonnull PoolClassDef classDef) {
        return classDef.getSuperclass();
    }

    @Override
    @Nullable
    public TypeListPool.Key<List<String>> getInterfaces(@Nonnull PoolClassDef classDef) {
        return classDef.interfaces;
    }

    @Override
    @Nullable
    public CharSequence getSourceFile(@Nonnull PoolClassDef classDef) {
        return classDef.getSourceFile();
    }

    @Override
    @Nullable
    public ArrayEncodedValue getStaticInitializers(@Nonnull PoolClassDef classDef) {
        return StaticInitializerUtil.getStaticInitializers((SortedSet<? extends Field>)classDef.getStaticFields());
    }

    @Override
    @Nonnull
    public Collection<? extends Field> getSortedStaticFields(@Nonnull PoolClassDef classDef) {
        return classDef.getStaticFields();
    }

    @Override
    @Nonnull
    public Collection<? extends Field> getSortedInstanceFields(@Nonnull PoolClassDef classDef) {
        return classDef.getInstanceFields();
    }

    @Override
    @Nonnull
    public Collection<? extends Field> getSortedFields(@Nonnull PoolClassDef classDef) {
        return classDef.getFields();
    }

    @Override
    @Nonnull
    public Collection<PoolMethod> getSortedDirectMethods(@Nonnull PoolClassDef classDef) {
        return classDef.getDirectMethods();
    }

    @Override
    @Nonnull
    public Collection<PoolMethod> getSortedVirtualMethods(@Nonnull PoolClassDef classDef) {
        return classDef.getVirtualMethods();
    }

    @Override
    @Nonnull
    public Collection<? extends PoolMethod> getSortedMethods(@Nonnull PoolClassDef classDef) {
        return classDef.getMethods();
    }

    @Override
    public int getFieldAccessFlags(@Nonnull Field field) {
        return field.getAccessFlags();
    }

    @Override
    public int getMethodAccessFlags(@Nonnull PoolMethod method) {
        return method.getAccessFlags();
    }

    @Override
    @Nonnull
    public Set<HiddenApiRestriction> getFieldHiddenApiRestrictions(@Nonnull Field field) {
        return field.getHiddenApiRestrictions();
    }

    @Override
    @Nonnull
    public Set<HiddenApiRestriction> getMethodHiddenApiRestrictions(@Nonnull PoolMethod poolMethod) {
        return poolMethod.getHiddenApiRestrictions();
    }

    @Override
    @Nullable
    public Set<? extends Annotation> getClassAnnotations(@Nonnull PoolClassDef classDef) {
        Set<? extends Annotation> annotations = classDef.getAnnotations();
        if (annotations.size() == 0) {
            return null;
        }
        return annotations;
    }

    @Override
    @Nullable
    public Set<? extends Annotation> getFieldAnnotations(@Nonnull Field field) {
        Set<? extends Annotation> annotations = field.getAnnotations();
        if (annotations.size() == 0) {
            return null;
        }
        return annotations;
    }

    @Override
    @Nullable
    public Set<? extends Annotation> getMethodAnnotations(@Nonnull PoolMethod method) {
        Set<? extends Annotation> annotations = method.getAnnotations();
        if (annotations.size() == 0) {
            return null;
        }
        return annotations;
    }

    @Override
    @Nullable
    public List<? extends Set<? extends Annotation>> getParameterAnnotations(@Nonnull PoolMethod method) {
        final List<? extends MethodParameter> parameters = method.getParameters();
        boolean hasParameterAnnotations = parameters.stream().anyMatch(HAS_PARAMETER_ANNOTATIONS);
        if (hasParameterAnnotations) {
            return new AbstractForwardSequentialList<Set<? extends Annotation>>(this){
                final /* synthetic */ ClassPool this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                @Nonnull
                public Iterator<Set<? extends Annotation>> iterator() {
                    return new TransformedIterable.TransformedIterator(parameters.iterator(), PARAMETER_ANNOTATIONS);
                }

                @Override
                public int size() {
                    return parameters.size();
                }
            };
        }
        return null;
    }

    @Override
    @Nullable
    public Iterable<? extends DebugItem> getDebugItems(@Nonnull PoolMethod method) {
        MethodImplementation impl = method.getImplementation();
        if (impl != null) {
            return impl.getDebugItems();
        }
        return null;
    }

    @Override
    @Nullable
    public Iterable<CharSequence> getParameterNames(@Nonnull PoolMethod method) {
        return new TransformedIterable<MethodParameter, CharSequence>(method.getParameters(), new Function<MethodParameter, CharSequence>(){

            @Override
            @Nullable
            public CharSequence apply(MethodParameter input) {
                return input.getName();
            }
        });
    }

    @Override
    public int getRegisterCount(@Nonnull PoolMethod method) {
        MethodImplementation impl = method.getImplementation();
        if (impl != null) {
            return impl.getRegisterCount();
        }
        return 0;
    }

    @Override
    @Nullable
    public Iterable<? extends Instruction> getInstructions(@Nonnull PoolMethod method) {
        MethodImplementation impl = method.getImplementation();
        if (impl != null) {
            return impl.getInstructions();
        }
        return null;
    }

    @Override
    @Nonnull
    public List<? extends TryBlock<? extends ExceptionHandler>> getTryBlocks(@Nonnull PoolMethod method) {
        MethodImplementation impl = method.getImplementation();
        if (impl != null) {
            return impl.getTryBlocks();
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public CharSequence getExceptionType(@Nonnull ExceptionHandler handler) {
        return handler.getExceptionType();
    }

    @Override
    @Nonnull
    public MutableMethodImplementation makeMutableMethodImplementation(@Nonnull PoolMethod poolMethod) {
        return new MutableMethodImplementation(poolMethod.getImplementation());
    }

    @Override
    public void setAnnotationDirectoryOffset(@Nonnull PoolClassDef classDef, int offset) {
        classDef.annotationDirectoryOffset = offset;
    }

    @Override
    public int getAnnotationDirectoryOffset(@Nonnull PoolClassDef classDef) {
        return classDef.annotationDirectoryOffset;
    }

    @Override
    public void setAnnotationSetRefListOffset(@Nonnull PoolMethod method, int offset) {
        method.annotationSetRefListOffset = offset;
    }

    @Override
    public int getAnnotationSetRefListOffset(@Nonnull PoolMethod method) {
        return method.annotationSetRefListOffset;
    }

    @Override
    public void setCodeItemOffset(@Nonnull PoolMethod method, int offset) {
        method.codeItemOffset = offset;
    }

    @Override
    public int getCodeItemOffset(@Nonnull PoolMethod method) {
        return method.codeItemOffset;
    }

    @Override
    public void writeDebugItem(@Nonnull DebugWriter<CharSequence, CharSequence> writer, DebugItem debugItem) throws IOException {
        switch (debugItem.getDebugItemType()) {
            case 3: {
                StartLocal startLocal = (StartLocal)debugItem;
                writer.writeStartLocal(startLocal.getCodeAddress(), startLocal.getRegister(), startLocal.getName(), startLocal.getType(), startLocal.getSignature());
                break;
            }
            case 5: {
                EndLocal endLocal = (EndLocal)debugItem;
                writer.writeEndLocal(endLocal.getCodeAddress(), endLocal.getRegister());
                break;
            }
            case 6: {
                RestartLocal restartLocal = (RestartLocal)debugItem;
                writer.writeRestartLocal(restartLocal.getCodeAddress(), restartLocal.getRegister());
                break;
            }
            case 7: {
                writer.writePrologueEnd(debugItem.getCodeAddress());
                break;
            }
            case 8: {
                writer.writeEpilogueBegin(debugItem.getCodeAddress());
                break;
            }
            case 10: {
                LineNumber lineNumber = (LineNumber)debugItem;
                writer.writeLineNumber(lineNumber.getCodeAddress(), lineNumber.getLineNumber());
                break;
            }
            case 9: {
                SetSourceFile setSourceFile = (SetSourceFile)debugItem;
                writer.writeSetSourceFile(setSourceFile.getCodeAddress(), setSourceFile.getSourceFile());
            }
            default: {
                throw new ExceptionWithContext("Unexpected debug item type: %d", debugItem.getDebugItemType());
            }
        }
    }

    @Override
    public int getItemIndex(@Nonnull PoolClassDef classDef) {
        return classDef.classDefIndex;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<PoolClassDef, Integer>> getItems() {
        return new AbstractCollection<Map.Entry<PoolClassDef, Integer>>(){

            @Override
            @Nonnull
            public Iterator<Map.Entry<PoolClassDef, Integer>> iterator() {
                return new Iterator<Map.Entry<PoolClassDef, Integer>>(){
                    Iterator<PoolClassDef> iter;
                    {
                        this.iter = ClassPool.this.internedItems.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public Map.Entry<PoolClassDef, Integer> next() {
                        class MapEntry
                        implements Map.Entry<PoolClassDef, Integer> {
                            @Nonnull
                            private final PoolClassDef classDef;

                            public MapEntry(PoolClassDef classDef) {
                                this.classDef = classDef;
                            }

                            @Override
                            public PoolClassDef getKey() {
                                return this.classDef;
                            }

                            @Override
                            public Integer getValue() {
                                return this.classDef.classDefIndex;
                            }

                            @Override
                            public Integer setValue(Integer value) {
                                int prev = this.classDef.classDefIndex;
                                this.classDef.classDefIndex = value;
                                return prev;
                            }
                        }
                        return new MapEntry(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ClassPool.this.internedItems.size();
            }
        };
    }
}

