# Generated by Django 5.1.1 on 2024-12-05 12:29

import uuid

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import api.rls


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0003_update_provider_unique_constraint_with_is_deleted"),
    ]

    operations = [
        migrations.CreateModel(
            name="Role",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                ("manage_users", models.BooleanField(default=False)),
                ("manage_account", models.BooleanField(default=False)),
                ("manage_billing", models.BooleanField(default=False)),
                ("manage_providers", models.BooleanField(default=False)),
                ("manage_integrations", models.BooleanField(default=False)),
                ("manage_scans", models.BooleanField(default=False)),
                ("unlimited_visibility", models.BooleanField(default=False)),
                ("inserted_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "tenant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.tenant"
                    ),
                ),
            ],
            options={
                "db_table": "roles",
            },
        ),
        migrations.CreateModel(
            name="RoleProviderGroupRelationship",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("inserted_at", models.DateTimeField(auto_now_add=True)),
                (
                    "tenant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.tenant"
                    ),
                ),
            ],
            options={
                "db_table": "role_provider_group_relationship",
            },
        ),
        migrations.CreateModel(
            name="UserRoleRelationship",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("inserted_at", models.DateTimeField(auto_now_add=True)),
                (
                    "tenant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.tenant"
                    ),
                ),
            ],
            options={
                "db_table": "role_user_relationship",
            },
        ),
        migrations.AddField(
            model_name="roleprovidergrouprelationship",
            name="provider_group",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="api.providergroup"
            ),
        ),
        migrations.AddField(
            model_name="roleprovidergrouprelationship",
            name="role",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="api.role"
            ),
        ),
        migrations.AddField(
            model_name="role",
            name="provider_groups",
            field=models.ManyToManyField(
                related_name="roles",
                through="api.RoleProviderGroupRelationship",
                to="api.providergroup",
            ),
        ),
        migrations.AddField(
            model_name="userrolerelationship",
            name="role",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="api.role"
            ),
        ),
        migrations.AddField(
            model_name="userrolerelationship",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
            ),
        ),
        migrations.AddField(
            model_name="role",
            name="users",
            field=models.ManyToManyField(
                related_name="roles",
                through="api.UserRoleRelationship",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddConstraint(
            model_name="roleprovidergrouprelationship",
            constraint=models.UniqueConstraint(
                fields=("role_id", "provider_group_id"),
                name="unique_role_provider_group_relationship",
            ),
        ),
        migrations.AddConstraint(
            model_name="roleprovidergrouprelationship",
            constraint=api.rls.RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_roleprovidergrouprelationship",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
        migrations.AddConstraint(
            model_name="userrolerelationship",
            constraint=models.UniqueConstraint(
                fields=("role_id", "user_id"), name="unique_role_user_relationship"
            ),
        ),
        migrations.AddConstraint(
            model_name="userrolerelationship",
            constraint=api.rls.RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_userrolerelationship",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
        migrations.AddConstraint(
            model_name="role",
            constraint=models.UniqueConstraint(
                fields=("tenant_id", "name"), name="unique_role_per_tenant"
            ),
        ),
        migrations.AddConstraint(
            model_name="role",
            constraint=api.rls.RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_role",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
        migrations.CreateModel(
            name="InvitationRoleRelationship",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("inserted_at", models.DateTimeField(auto_now_add=True)),
                (
                    "invitation",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.invitation"
                    ),
                ),
                (
                    "role",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.role"
                    ),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.tenant"
                    ),
                ),
            ],
            options={
                "db_table": "role_invitation_relationship",
            },
        ),
        migrations.AddConstraint(
            model_name="invitationrolerelationship",
            constraint=models.UniqueConstraint(
                fields=("role_id", "invitation_id"),
                name="unique_role_invitation_relationship",
            ),
        ),
        migrations.AddConstraint(
            model_name="invitationrolerelationship",
            constraint=api.rls.RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_invitationrolerelationship",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
        migrations.AddField(
            model_name="role",
            name="invitations",
            field=models.ManyToManyField(
                related_name="roles",
                through="api.InvitationRoleRelationship",
                to="api.invitation",
            ),
        ),
    ]
