# Generated by Django 5.1.5 on 2025-03-03 15:46

from functools import partial

from django.db import migrations

from api.db_utils import PostgresEnumMigration, ProcessorTypeEnum, register_enum
from api.models import Processor

ProcessorTypeEnumMigration = PostgresEnumMigration(
    enum_name="processor_type",
    enum_values=tuple(
        processor_type[0] for processor_type in Processor.ProcessorChoices.choices
    ),
)


class Migration(migrations.Migration):
    atomic = False

    dependencies = [
        ("api", "0032_saml"),
    ]

    operations = [
        migrations.RunPython(
            ProcessorTypeEnumMigration.create_enum_type,
            reverse_code=ProcessorTypeEnumMigration.drop_enum_type,
        ),
        migrations.RunPython(
            partial(register_enum, enum_class=ProcessorTypeEnum),
            reverse_code=migrations.RunPython.noop,
        ),
    ]
