from prowler.lib.check.models import Check, Check_Report_AWS
from prowler.providers.aws.services.cognito.cognito_idp_client import cognito_idp_client


class cognito_user_pool_password_policy_uppercase(Check):
    def execute(self):
        findings = []
        for pool in cognito_idp_client.user_pools.values():
            report = Check_Report_AWS(metadata=self.metadata(), resource=pool)
            if pool.password_policy:
                if pool.password_policy.require_uppercase:
                    report.status = "PASS"
                    report.status_extended = f"User pool {pool.name} has a password policy with an uppercase requirement."
                else:
                    report.status = "FAIL"
                    report.status_extended = f"User pool {pool.name} does not have a password policy with an uppercase requirement."
            else:
                report.status = "FAIL"
                report.status_extended = (
                    f"User pool {pool.name} has not a password policy set."
                )
            findings.append(report)

        return findings
