"""Multilingual User Interface (MUI) translations for Windows en-US timezone strings.

This dictionary was exported from a ``tzres.dll.mui`` file from Windows Server 2019.

References:
    - Reversing DLL String Table in ``C:/Windows/System32/en-US/tzres.dll.mui``.
    - https://learn.microsoft.com/en-us/windows/win32/intl/using-registry-string-redirection
    - https://learn.microsoft.com/en-us/windows/win32/api/winnls/ns-winnls-filemuiinfo
"""

MUI_TZ_MAP = {
    10: "(UTC-01:00) Azores",
    11: "Azores Daylight Time",
    12: "Azores Standard Time",
    20: "(UTC-01:00) Cape Verde Is.",
    21: "Cape Verde Daylight Time",
    22: "Cape Verde Standard Time",
    30: "(UTC-02:00) Mid-Atlantic",
    31: "Mid-Atlantic Daylight Time",
    32: "Mid-Atlantic Standard Time",
    40: "(UTC-03:00) Brasilia",
    41: "E. South America Daylight Time",
    42: "E. South America Standard Time",
    50: "(UTC-03:00) Greenland",
    51: "Greenland Daylight Time",
    52: "Greenland Standard Time",
    60: "(UTC-03:00) Buenos Aires, Georgetown",
    61: "SA Eastern Daylight Time",
    62: "SA Eastern Standard Time",
    70: "(UTC-03:30) Newfoundland",
    71: "Newfoundland Daylight Time",
    72: "Newfoundland Standard Time",
    80: "(UTC-04:00) Atlantic Time (Canada)",
    81: "Atlantic Daylight Time",
    82: "Atlantic Standard Time",
    90: "(UTC-04:00) Santiago",
    91: "Pacific SA Daylight Time",
    92: "Pacific SA Standard Time",
    100: "(UTC-04:00) Caracas, La Paz",
    101: "SA Western Daylight Time",
    102: "SA Western Standard Time",
    103: "(UTC-04:00) Manaus",
    104: "Central Brazilian Daylight Time",
    105: "Central Brazilian Standard Time",
    110: "(UTC-05:00) Eastern Time (US & Canada)",
    111: "Eastern Daylight Time",
    112: "Eastern Standard Time",
    120: "(UTC-05:00) Bogota, Lima, Quito, Rio Branco",
    121: "SA Pacific Daylight Time",
    122: "SA Pacific Standard Time",
    130: "(UTC-05:00) Indiana (East)",
    131: "US Eastern Daylight Time",
    132: "US Eastern Standard Time",
    140: "(UTC-06:00) Saskatchewan",
    141: "Canada Central Daylight Time",
    142: "Canada Central Standard Time",
    150: "(UTC-06:00) Central America",
    151: "Central America Daylight Time",
    152: "Central America Standard Time",
    160: "(UTC-06:00) Central Time (US & Canada)",
    161: "Central Daylight Time",
    162: "Central Standard Time",
    170: "(UTC-06:00) Guadalajara, Mexico City, Monterrey",
    171: "Central Daylight Time (Mexico)",
    172: "Central Standard Time (Mexico)",
    180: "(UTC-07:00) Chihuahua, La Paz, Mazatlan",
    181: "Mountain Daylight Time (Mexico)",
    182: "Mountain Standard Time (Mexico)",
    190: "(UTC-07:00) Mountain Time (US & Canada)",
    191: "Mountain Daylight Time",
    192: "Mountain Standard Time",
    200: "(UTC-07:00) Arizona",
    201: "US Mountain Daylight Time",
    202: "US Mountain Standard Time",
    210: "(UTC-08:00) Pacific Time (US & Canada)",
    211: "Pacific Daylight Time",
    212: "Pacific Standard Time",
    213: "(UTC-08:00) Tijuana, Baja California",
    214: "Pacific Daylight Time (Mexico)",
    215: "Pacific Standard Time (Mexico)",
    220: "(UTC-09:00) Alaska",
    221: "Alaskan Daylight Time",
    222: "Alaskan Standard Time",
    230: "(UTC-10:00) Hawaii",
    231: "Hawaiian Daylight Time",
    232: "Hawaiian Standard Time",
    240: "(UTC-11:00) Midway Island, Samoa",
    241: "Samoa Daylight Time",
    242: "Samoa Standard Time",
    250: "(UTC-12:00) International Date Line West",
    251: "Dateline Daylight Time",
    252: "Dateline Standard Time",
    260: "(UTC) Dublin, Edinburgh, Lisbon, London",
    261: "GMT Daylight Time",
    262: "GMT Standard Time",
    270: "(UTC) Casablanca, Monrovia, Reykjavik",
    271: "Greenwich Daylight Time",
    272: "Greenwich Standard Time",
    280: "(UTC+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague",
    281: "Central Europe Daylight Time",
    282: "Central Europe Standard Time",
    290: "(UTC+01:00) Sarajevo, Skopje, Warsaw, Zagreb",
    291: "Central European Daylight Time",
    292: "Central European Standard Time",
    300: "(UTC+01:00) Brussels, Copenhagen, Madrid, Paris",
    301: "Romance Daylight Time",
    302: "Romance Standard Time",
    310: "(UTC+01:00) West Central Africa",
    311: "W. Central Africa Daylight Time",
    312: "W. Central Africa Standard Time",
    320: "(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna",
    321: "W. Europe Daylight Time",
    322: "W. Europe Standard Time",
    330: "(UTC+02:00) Minsk",
    331: "E. Europe Daylight Time",
    332: "E. Europe Standard Time",
    333: "(UTC+02:00) Amman",
    334: "Jordan Daylight Time",
    335: "Jordan Standard Time",
    340: "(UTC+02:00) Cairo",
    341: "Egypt Daylight Time",
    342: "Egypt Standard Time",
    350: "(UTC+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius",
    351: "FLE Daylight Time",
    352: "FLE Standard Time",
    360: "(UTC+02:00) Athens, Bucharest, Istanbul",
    361: "GTB Daylight Time",
    362: "GTB Standard Time",
    363: "(UTC+02:00) Beirut",
    364: "Middle East Daylight Time",
    365: "Middle East Standard Time",
    370: "(UTC+02:00) Jerusalem",
    371: "Jerusalem Daylight Time",
    372: "Jerusalem Standard Time",
    380: "(UTC+02:00) Harare, Pretoria",
    381: "South Africa Daylight Time",
    382: "South Africa Standard Time",
    383: "(UTC+02:00) Windhoek",
    384: "Namibia Daylight Time",
    385: "Namibia Standard Time",
    390: "(UTC+03:00) Kuwait, Riyadh",
    391: "Arab Daylight Time",
    392: "Arab Standard Time",
    400: "(UTC+03:00) Baghdad",
    401: "Arabic Daylight Time",
    402: "Arabic Standard Time",
    410: "(UTC+03:00) Nairobi",
    411: "E. Africa Daylight Time",
    412: "E. Africa Standard Time",
    420: "(UTC+03:00) Moscow, St. Petersburg, Volgograd",
    421: "Russian Daylight Time",
    422: "Russian Standard Time",
    430: "(UTC+03:30) Tehran",
    431: "Iran Daylight Time",
    432: "Iran Standard Time",
    433: "(UTC+03:00) Tbilisi",
    434: "Georgian Daylight Time",
    435: "Georgian Standard Time",
    440: "(UTC+04:00) Abu Dhabi, Muscat",
    441: "Arabian Daylight Time",
    442: "Arabian Standard Time",
    447: "(UTC+04:00) Baku",
    448: "Azerbaijan Daylight Time",
    449: "Azerbaijan Standard Time",
    450: "(UTC+04:00) Yerevan",
    451: "Caucasus Daylight Time",
    452: "Caucasus Standard Time",
    460: "(UTC+04:30) Kabul",
    461: "Afghanistan Daylight Time",
    462: "Afghanistan Standard Time",
    470: "(UTC+05:00) Ekaterinburg",
    471: "Ekaterinburg Daylight Time",
    472: "Ekaterinburg Standard Time",
    480: "(UTC+05:00) Islamabad, Karachi, Tashkent",
    481: "West Asia Daylight Time",
    482: "West Asia Standard Time",
    490: "(UTC+05:30) Chennai, Kolkata, Mumbai, New Delhi",
    491: "India Daylight Time",
    492: "India Standard Time",
    500: "(UTC+05:45) Kathmandu",
    501: "Nepal Daylight Time",
    502: "Nepal Standard Time",
    510: "(UTC+06:00) Astana, Dhaka",
    511: "Central Asia Daylight Time",
    512: "Central Asia Standard Time",
    520: "(UTC+06:00) Almaty, Novosibirsk",
    521: "N. Central Asia Daylight Time",
    522: "N. Central Asia Standard Time",
    530: "(UTC+05:30) Sri Jayawardenepura",
    531: "Sri Lanka Daylight Time",
    532: "Sri Lanka Standard Time",
    540: "(UTC+06:30) Yangon (Rangoon)",
    541: "Myanmar Daylight Time",
    542: "Myanmar Standard Time",
    550: "(UTC+07:00) Krasnoyarsk",
    551: "North Asia Daylight Time",
    552: "North Asia Standard Time",
    560: "(UTC+07:00) Bangkok, Hanoi, Jakarta",
    561: "SE Asia Daylight Time",
    562: "SE Asia Standard Time",
    570: "(UTC+08:00) Beijing, Chongqing, Hong Kong, Urumqi",
    571: "China Daylight Time",
    572: "China Standard Time",
    580: "(UTC+08:00) Irkutsk, Ulaan Bataar",
    581: "North Asia East Daylight Time",
    582: "North Asia East Standard Time",
    590: "(UTC+08:00) Kuala Lumpur, Singapore",
    591: "Malay Peninsula Daylight Time",
    592: "Malay Peninsula Standard Time",
    600: "(UTC+08:00) Taipei",
    601: "Taipei Daylight Time",
    602: "Taipei Standard Time",
    610: "(UTC+08:00) Perth",
    611: "W. Australia Daylight Time",
    612: "W. Australia Standard Time",
    620: "(UTC+09:00) Seoul",
    621: "Korea Daylight Time",
    622: "Korea Standard Time",
    630: "(UTC+09:00) Osaka, Sapporo, Tokyo",
    631: "Tokyo Daylight Time",
    632: "Tokyo Standard Time",
    640: "(UTC+09:00) Yakutsk",
    641: "Yakutsk Daylight Time",
    642: "Yakutsk Standard Time",
    650: "(UTC+09:30) Darwin",
    651: "AUS Central Daylight Time",
    652: "AUS Central Standard Time",
    660: "(UTC+09:30) Adelaide",
    661: "Cen. Australia Daylight Time",
    662: "Cen. Australia Standard Time",
    670: "(UTC+10:00) Canberra, Melbourne, Sydney",
    671: "AUS Eastern Daylight Time",
    672: "AUS Eastern Standard Time",
    680: "(UTC+10:00) Brisbane",
    681: "E. Australia Daylight Time",
    682: "E. Australia Standard Time",
    690: "(UTC+10:00) Hobart",
    691: "Tasmania Daylight Time",
    692: "Tasmania Standard Time",
    700: "(UTC+10:00) Vladivostok",
    701: "Vladivostok Daylight Time",
    702: "Vladivostok Standard Time",
    710: "(UTC+10:00) Guam, Port Moresby",
    711: "West Pacific Daylight Time",
    712: "West Pacific Standard Time",
    720: "(UTC+11:00) Magadan, Solomon Is., New Caledonia",
    721: "Central Pacific Daylight Time",
    722: "Central Pacific Standard Time",
    730: "(UTC+12:00) Fiji, Kamchatka, Marshall Is.",
    731: "Fiji Daylight Time",
    732: "Fiji Standard Time",
    740: "(UTC+12:00) Auckland, Wellington",
    741: "New Zealand Daylight Time",
    742: "New Zealand Standard Time",
    750: "(UTC+13:00) Nuku'alofa",
    751: "Tonga Daylight Time",
    752: "Tonga Standard Time",
    770: "(UTC-03:00) Montevideo",
    771: "Montevideo Daylight Time",
    772: "Montevideo Standard Time",
    790: "(UTC-04:00) La Paz",
    791: "SA Western Daylight Time",
    792: "SA Western Standard Time",
    810: "(UTC-04:30) Caracas",
    811: "Venezuela Daylight Time",
    812: "Venezuela Standard Time",
    830: "(UTC-03:00) Georgetown",
    831: "SA Eastern Daylight Time",
    832: "SA Eastern Standard Time",
    840: "(UTC-03:00) Buenos Aires",
    841: "Argentina Daylight Time",
    842: "Argentina Standard Time",
    860: "(UTC+05:00) Tashkent",
    870: "(UTC+05:00) Islamabad, Karachi",
    871: "Pakistan Daylight Time",
    872: "Pakistan Standard Time",
    880: "(UTC) Monrovia, Reykjavik",
    890: "(UTC) Casablanca",
    891: "Morocco Daylight Time",
    892: "Morocco Standard Time",
    910: "(UTC+04:00) Port Louis",
    911: "Mauritius Daylight Time",
    912: "Mauritius Standard Time",
    930: "(UTC) Coordinated Universal Time",
    931: "Coordinated Universal Time",
    932: "Coordinated Universal Time",
    940: "(UTC-03:00) Cayenne",
    950: "(UTC-04:00) Georgetown, La Paz, San Juan",
    960: "(UTC-04:00) Asuncion",
    961: "Paraguay Daylight Time",
    962: "Paraguay Standard Time",
    970: "(UTC+12:00) Fiji, Marshall Is.",
    980: "(UTC+12:00) Petropavlovsk-Kamchatsky",
    981: "Kamchatka Daylight Time",
    982: "Kamchatka Standard Time",
    990: "(UTC-05:00) Bogota, Lima, Quito",
    1010: "(UTC+06:00) Astana",
    1020: "(UTC+06:00) Dhaka",
    1021: "Bangladesh Daylight Time",
    1022: "Bangladesh Standard Time",
    1030: "(UTC+08:00) Irkutsk",
    1040: "(UTC+08:00) Ulaanbaatar",
    1041: "Ulaanbaatar Daylight Time",
    1042: "Ulaanbaatar Standard Time",
    1050: "(UTC-11:00) Samoa",
    1060: "(UTC-11:00) Midway Islands",
    1061: "North Pacific Daylight Time",
    1062: "North Pacific Standard Time",
    1070: "(UTC+04:00) Tbilisi",
    1080: "(UTC+06:00) Novosibirsk",
    1100: "(UTC-08:00) Baja California",
    1110: "(UTC-03:00) Cayenne, Fortaleza",
    1120: "(UTC-04:00) Cuiaba",
    1130: "(UTC-04:00) Georgetown, La Paz, Manaus, San Juan",
    1140: "(UTC+12:00) Fiji",
    1150: "(UTC-01:00) Coordinated Universal Time-01",
    1151: "UTC-01",
    1152: "UTC-01",
    1160: "(UTC-02:00) Coordinated Universal Time-02",
    1161: "UTC-02",
    1162: "UTC-02",
    1170: "(UTC-03:00) Coordinated Universal Time-03",
    1171: "UTC-03",
    1172: "UTC-03",
    1180: "(UTC-04:00) Coordinated Universal Time-04",
    1181: "UTC-04",
    1182: "UTC-04",
    1190: "(UTC-05:00) Coordinated Universal Time-05",
    1191: "UTC-05",
    1192: "UTC-05",
    1200: "(UTC-06:00) Coordinated Universal Time-06",
    1201: "UTC-06",
    1202: "UTC-06",
    1210: "(UTC-07:00) Coordinated Universal Time-07",
    1211: "UTC-07",
    1212: "UTC-07",
    1220: "(UTC-08:00) Coordinated Universal Time-08",
    1221: "UTC-08",
    1222: "UTC-08",
    1230: "(UTC-09:00) Coordinated Universal Time-09",
    1231: "UTC-09",
    1232: "UTC-09",
    1240: "(UTC-10:00) Coordinated Universal Time-10",
    1241: "UTC-10",
    1242: "UTC-10",
    1250: "(UTC-11:00) Coordinated Universal Time-11",
    1251: "UTC-11",
    1252: "UTC-11",
    1260: "(UTC-12:00) Coordinated Universal Time-12",
    1261: "UTC-12",
    1262: "UTC-12",
    1270: "(UTC+01:00) Coordinated Universal Time+01",
    1271: "UTC+01",
    1272: "UTC+01",
    1280: "(UTC+02:00) Coordinated Universal Time+02",
    1281: "UTC+02",
    1282: "UTC+02",
    1290: "(UTC+03:00) Coordinated Universal Time+03",
    1291: "UTC+03",
    1292: "UTC+03",
    1300: "(UTC+04:00) Coordinated Universal Time+04",
    1301: "UTC+04",
    1302: "UTC+04",
    1310: "(UTC+05:00) Coordinated Universal Time+05",
    1311: "UTC+05",
    1312: "UTC+05",
    1320: "(UTC+06:00) Coordinated Universal Time+06",
    1321: "UTC+06",
    1322: "UTC+06",
    1330: "(UTC+07:00) Coordinated Universal Time+07",
    1331: "UTC+07",
    1332: "UTC+07",
    1340: "(UTC+08:00) Coordinated Universal Time+08",
    1341: "UTC+08",
    1342: "UTC+08",
    1350: "(UTC+09:00) Coordinated Universal Time+09",
    1351: "UTC+09",
    1352: "UTC+09",
    1360: "(UTC+10:00) Coordinated Universal Time+10",
    1361: "UTC+10",
    1362: "UTC+10",
    1370: "(UTC+11:00) Coordinated Universal Time+11",
    1371: "UTC+11",
    1372: "UTC+11",
    1380: "(UTC+12:00) Coordinated Universal Time+12",
    1381: "UTC+12",
    1382: "UTC+12",
    1390: "(UTC+13:00) Coordinated Universal Time+13",
    1391: "UTC+13",
    1392: "UTC+13",
    1410: "(UTC+02:00) Damascus",
    1411: "Syria Daylight Time",
    1412: "Syria Standard Time",
    1420: "(UTC+12:00) Petropavlovsk-Kamchatsky - Old",
    1440: "(UTC+01:00) Windhoek",
    1460: "(UTC+11:00) Solomon Is., New Caledonia",
    1470: "(UTC+11:00) Magadan",
    1471: "Magadan Daylight Time",
    1472: "Magadan Standard Time",
    1490: "(UTC+02:00) Athens, Bucharest",
    1500: "(UTC+02:00) Istanbul",
    1501: "Turkey Daylight Time",
    1502: "Turkey Standard Time",
    1520: "(UTC+04:00) Moscow, St. Petersburg, Volgograd",
    1530: "(UTC+06:00) Ekaterinburg",
    1540: "(UTC+07:00) Novosibirsk",
    1550: "(UTC+08:00) Krasnoyarsk",
    1560: "(UTC+09:00) Irkutsk",
    1570: "(UTC+10:00) Yakutsk",
    1580: "(UTC+11:00) Vladivostok",
    1590: "(UTC+12:00) Magadan",
    1600: "(UTC+03:00) Kaliningrad",
    1601: "Kaliningrad Daylight Time",
    1602: "Kaliningrad Standard Time",
    1620: "(UTC+03:00) Kaliningrad, Minsk",
    1630: "(UTC+02:00) Nicosia",
    1640: "(UTC+13:00) Samoa",
    1660: "(UTC-03:00) Salvador",
    1661: "Bahia Daylight Time",
    1662: "Bahia Standard Time",
    1680: "(UTC+02:00) E. Europe",
    1700: "(UTC+03:00) Amman",
    1720: "(UTC+02:00) Tripoli",
    1721: "Libya Daylight Time",
    1722: "Libya Standard Time",
    1740: "(UTC+05:00) Ashgabat, Tashkent",
    1760: "(UTC-02:00) Mid-Atlantic - Old",
    1780: "(UTC+02:00) Tripoli",
    1800: "(UTC+14:00) Kiritimati Island",
    1801: "Line Islands Daylight Time",
    1802: "Line Islands Standard Time",
    1820: "(UTC+02:00) Kaliningrad (RTZ 1)",
    1821: "Russia TZ 1 Daylight Time",
    1822: "Russia TZ 1 Standard Time",
    1830: "(UTC+03:00) Moscow, St. Petersburg, Volgograd (RTZ 2)",
    1831: "Russia TZ 2 Daylight Time",
    1832: "Russia TZ 2 Standard Time",
    1840: "(UTC+05:00) Ekaterinburg (RTZ 4)",
    1841: "Russia TZ 4 Daylight Time",
    1842: "Russia TZ 4 Standard Time",
    1850: "(UTC+06:00) Novosibirsk (RTZ 5)",
    1851: "Russia TZ 5 Daylight Time",
    1852: "Russia TZ 5 Standard Time",
    1860: "(UTC+07:00) Krasnoyarsk (RTZ 6)",
    1861: "Russia TZ 6 Daylight Time",
    1862: "Russia TZ 6 Standard Time",
    1870: "(UTC+08:00) Irkutsk (RTZ 7)",
    1871: "Russia TZ 7 Daylight Time",
    1872: "Russia TZ 7 Standard Time",
    1880: "(UTC+09:00) Yakutsk (RTZ 8)",
    1881: "Russia TZ 8 Daylight Time",
    1882: "Russia TZ 8 Standard Time",
    1890: "(UTC+04:00) Izhevsk, Samara (RTZ 3)",
    1891: "Russia TZ 3 Daylight Time",
    1892: "Russia TZ 3 Standard Time",
    1910: "(UTC+11:00) Chokurdakh (RTZ 10)",
    1911: "Russia TZ 10 Daylight Time",
    1912: "Russia TZ 10 Standard Time",
    1930: "(UTC+12:00) Anadyr, Petropavlovsk-Kamchatsky (RTZ 11)",
    1931: "Russia TZ 11 Daylight Time",
    1932: "Russia TZ 11 Standard Time",
    1950: "(UTC+10:00) Vladivostok, Magadan (RTZ 9)",
    1951: "Russia TZ 9 Daylight Time",
    1952: "Russia TZ 9 Standard Time",
    1970: "(UTC+03:00) Minsk",
    1971: "Belarus Daylight Time",
    1972: "Belarus Standard Time",
    1980: "(UTC+10:00) Magadan",
    2000: "(UTC-01:00) Cabo Verde Is.",
    2001: "Cabo Verde Daylight Time",
    2002: "Cabo Verde Standard Time",
    2020: "(UTC-03:00) Santiago",
    2040: "(UTC-05:00) Chetumal",
    2041: "Eastern Daylight Time (Mexico)",
    2042: "Eastern Standard Time (Mexico)",
    2060: "(UTC+08:30) Pyongyang",
    2061: "North Korea Daylight Time",
    2062: "North Korea Standard Time",
    2080: "(UTC-03:00) City of Buenos Aires",
    2120: "(UTC+10:00) Vladivostok",
    2140: "(UTC+09:00) Chita",
    2141: "Transbaikal Daylight Time",
    2142: "Transbaikal Standard Time",
    2160: "(UTC+07:00) Barnaul, Gorno-Altaysk",
    2161: "Altai Daylight Time",
    2162: "Altai Standard Time",
    2180: "(UTC+04:00) Astrakhan, Ulyanovsk",
    2181: "Astrakhan Daylight Time",
    2182: "Astrakhan Standard Time",
    2190: "(UTC+05:00) Ekaterinburg",
    2200: "(UTC+02:00) Kaliningrad",
    2220: "(UTC+06:00) Novosibirsk",
    2230: "(UTC+08:00) Irkutsk",
    2240: "(UTC+07:00) Krasnoyarsk",
    2250: "(UTC+11:00) Chokurdakh",
    2260: "(UTC+12:00) Anadyr, Petropavlovsk-Kamchatsky",
    2270: "(UTC+04:00) Izhevsk, Samara",
    2280: "(UTC+03:00) Moscow, St. Petersburg, Volgograd",
    2290: "(UTC+09:00) Yakutsk",
    2310: "(UTC+11:00) Magadan, Sakhalin",
    2320: "(UTC+11:00) Sakhalin",
    2321: "Sakhalin Daylight Time",
    2322: "Sakhalin Standard Time",
    2340: "(UTC-05:00) Haiti",
    2341: "Haiti Daylight Time",
    2342: "Haiti Standard Time",
    2370: "(UTC-06:00) Easter Island",
    2371: "Easter Island Daylight Time",
    2372: "Easter Island Standard Time",
    2390: "(UTC-10:00) Aleutian Islands",
    2391: "Aleutian Daylight Time",
    2392: "Aleutian Standard Time",
    2410: "(UTC-09:30) Marquesas Islands",
    2411: "Marquesas Daylight Time",
    2412: "Marquesas Standard Time",
    2430: "(UTC-05:00) Havana",
    2431: "Cuba Daylight Time",
    2432: "Cuba Standard Time",
    2450: "(UTC-03:00) Saint Pierre and Miquelon",
    2451: "Saint Pierre Daylight Time",
    2452: "Saint Pierre Standard Time",
    2470: "(UTC+02:00) Gaza, Hebron",
    2471: "West Bank Gaza Daylight Time",
    2472: "West Bank Gaza Standard Time",
    2490: "(UTC+08:45) Eucla",
    2491: "Aus Central W. Daylight Time",
    2492: "Aus Central W. Standard Time",
    2510: "(UTC+10:30) Lord Howe Island",
    2511: "Lord Howe Daylight Time",
    2512: "Lord Howe Standard Time",
    2530: "(UTC+12:45) Chatham Islands",
    2531: "Chatham Islands Daylight Time",
    2532: "Chatham Islands Standard Time",
    2550: "(UTC+07:00) Hovd",
    2551: "W. Mongolia Daylight Time",
    2552: "W. Mongolia Standard Time",
    2570: "(UTC-04:00) Turks and Caicos",
    2571: "Turks and Caicos Daylight Time",
    2572: "Turks and Caicos Standard Time",
    2590: "(UTC-03:00) Araguaina",
    2591: "Tocantins Daylight Time",
    2592: "Tocantins Standard Time",
    2610: "(UTC+11:00) Bougainville Island",
    2611: "Bougainville Daylight Time",
    2612: "Bougainville Standard Time",
    2630: "(UTC+11:00) Norfolk Island",
    2631: "Norfolk Daylight Time",
    2632: "Norfolk Standard Time",
    2650: "(UTC+00:00) Casablanca",
    2670: "(UTC+00:00) Dublin, Edinburgh, Lisbon, London",
    2690: "(UTC+00:00) Monrovia, Reykjavik",
    2710: "(UTC+02:00) Chisinau",
    2730: "(UTC-04:00) Caracas",
    2750: "(UTC+07:00) Tomsk",
    2751: "Tomsk Daylight Time",
    2752: "Tomsk Standard Time",
    2770: "(UTC+06:00) Omsk",
    2771: "Omsk Daylight Time",
    2772: "Omsk Standard Time",
    2790: "(UTC+07:00) Novosibirsk",
    2791: "Novosibirsk Daylight Time",
    2792: "Novosibirsk Standard Time",
    2810: "(UTC+03:00) Istanbul",
    2840: "(UTC+04:00) Saratov",
    2841: "Saratov Daylight Time",
    2842: "Saratov Standard Time",
    2870: "(UTC-03:00) Punta Arenas",
    2871: "Magallanes Daylight Time",
    2872: "Magallanes Standard Time",
    2890: "(UTC+02:00) Khartoum",
    2891: "Sudan Daylight Time",
    2892: "Sudan Standard Time",
    2910: "(UTC-05:00) Turks and Caicos",
    2940: "(UTC+01:00) Sao Tome",
    2941: "Sao Tome Daylight Time",
    2942: "Sao Tome Standard Time",
    2960: "(UTC+09:00) Pyongyang",
    2980: "(UTC+03:00) Moscow, St. Petersburg",
    2990: "(UTC+04:00) Volgograd",
    2991: "Volgograd Daylight Time",
    2992: "Volgograd Standard Time",
    3010: "(UTC+01:00) Casablanca",
    3030: "(UTC+00:00) Sao Tome",
    3050: "(UTC+05:00) Qyzylorda",
    3051: "Qyzylorda Daylight Time",
    3052: "Qyzylorda Standard Time",
    3080: "(UTC-08:00) Yukon",
    3081: "Yukon Daylight Time",
    3082: "Yukon Standard Time",
    3090: "(UTC-07:00) Yukon",
    3110: "(UTC+03:00) Volgograd",
    3140: "(UTC+02:00) Juba",
    3141: "South Sudan Daylight Time",
    3142: "South Sudan Standard Time",
}
