#!/usr/bin/perl
eval ("use IO::Socket;");die "[error] IO::Socket perl module is not installed \n" if $@;
eval ("use Net::hostent;");die "[error] Net::hostent  perl module is not installed \n" if $@;
eval ("use Getopt::Long;");die "[error] Getopt::Long perl module is not installed \n" if $@;

######################## Config option #############################################
$tmplogprefix = "/tmp/tmplog"; #Temp file directory
$logfile="scan.log"; #Log file filename 
$llevel="cdv"; #Log level
$timeout = 1; # Timeout
$retries=2; # Retries send packets
####################################################################################
my $VERSION = "0.1";
print "$0, $PgmName, V $VERSION \n";
  # handle the commandline options

GetOptions ( 
			"help" => \$usage, 
            "snmp" => \$snmp,
            "snmpencode" => \$smpencode,
            "trap" => \$trap,
            "ping" => \$ping,
            "trapencoded" => \$trapencode,
            "file=s" => \$single,
            "fork" => \$fork,
            "timeout=n" => \$timeout,
            "retries=n" => \$retries,
            "host=s" => \$server, 
            "maxprocess=i" => \$max_processes,
            "port=i" => \$port,
            "nodos" => \$nodos,
            "kill" => \$kiledt
           );

if (!$server)
{
  print "Hostname please ;-) \n";
  &usage;
  exit (0);    
}  	
if (!($snmp || $smpencode || $trap || $trapencode || $single) )
{
	print "Please define a scan type or RTFM !!! ;-) \n";
    &usage;
    exit (0);
}	
if (($nodos ) && !($ping) && !($fork))  { 
 "Warning [--nodos ] option only for [--ping] witch [--fork] \n";
&usage;
exit (0); 
}
	
if ($usage)
{
	&usage;
	exit(0);
}

if ($snmp)
{
$pdudir="snmp" ;

} 

if ($smpencode)
{
$pdudir="snmpencoded" ;	
}

if ($trap)
{
$pdudir="trap" ;	

}

if ($trapencode)
{
$pdudir="trapencoded" ;	

}

if ($max_processes eq "") {
$max_processes = 10;
}

if ($port eq "") {
$port = 161;
}


#Load database files

if (!$single){		
opendir(DIR, "$pdudir")|| die " PDU dir not found";
@f = readdir(DIR);
@files = grep {  !/^\./   } @f; # strip (.) and (..) special files
closedir(DIR);


print "PDU testcase database dir : $pdudir \n";
}

  
 if ($server =~ /[a-zA-Z]/) {
  my $i = gethostbyname($server);
  $server = inet_ntoa($i);
}
 
  
    
  print "SNMP server: $server \n";
  print "Max processes: $max_processes \n";
  print "SNMP port: $port \n"; 

&banner;
############################# Core scan ##########################################
#Start Listener
die  "can`t fork: $! " unless defined ($kidpid =fork());
if ($kidpid ){
 icmp_serv();}
sleep 3;
if ($nodos) {   # No DOS mode  
 print "\nNo DOS mode defined\n Starting single SNMP ping process\n" ;	
die  "can`t fork: $! " unless defined ($spid =fork());
while ($spid) {
snmp_ping()	
}	
sleep 2;
forked();	
}
	
	
# If single testcase

if ($single) {	
my $file = $single;
pdu_decode($file);
snmp_ping() if $ping;
sleep 3;
kill_all()

}  else   {   # full testcase 
if ($fork){
forked();
} else {

	foreach $file (@files)
	{   

	    pdu_decode($file);
		if ($ping){ snmp_ping ();}
	
	}
}
banner_end();
print " Killing ICMP listener \n";
kill ("TERM" => $kidpid);
}

###################################################################################




############################## ICMP listiner ##############################
sub fork_server {

die  "can`t fork: $! " unless defined ($kidpid =fork());
if ($kidpid ){
 icmp_serv();
 exit 0;	 
}	
	
}
 
sub icmp_serv {
	# create ICMP socket to listen for icmp packets
my($sock,$data, $newmsg,$MAXLEN);
$MAXLEN = 4096;

$sock = IO::Socket::INET->new( "Proto" => 'icmp')
    or die "You mast bee root! Cant create an ICMP listen socket ($!)"; 
print " ICMP listiner started\n";
while ($sock->recv($pkt, $MAXLEN)) {
    my($ipaddr) = sockaddr_in($sock->peername);
    if (defined $pkt) {
        ( $src_ip, $dest_ip, $data)=IP_decode($pkt); 
         
        } 
          if ((defined $data) && ($src_ip =~ /$server/ )) {
           $pkt = $data;
         ($data, $code, $type)=ICMP_decode ($pkt);
 print "ICMP packet <<  Sorce : $src_ip Dest: $dest_ip Code: $code   Type:$type   >> \n";
           if ((defined $data) && ($type == 3) ){
           	$pkt = $data;
           	 ( $src_ip, $dest_ip, $data)=IP_decode($pkt);
           	 $pkt = $data;
           ( $src_ip, $dest_ip, $data)=udp_decode($pkt);
             $data=unpack "H*",($pkt);
            print "\n******************Lost SNMP packet ************** \n $data \n";
            exit 0;
             kill ("TERM" => $pid);
           
           }
    
          
          }       
                                    } die "recv: $!";
	
	
}
 


#########################IP decode Utils #############################################

# Convert 32-bit IP address to dotted notation

sub to_dotquad {
    my($net) = @_ ;
    my($na, $nb, $nc, $nd);

    $na = $net >> 24 & 255;
    $nb = $net >> 16 & 255;
    $nc = $net >>  8 & 255;
    $nd = $net & 255;

    return ("$na.$nb.$nc.$nd");
}

sub uri_escape {
	my $data = shift;

	# Build a char to hex map
	my %escapes = ();
	for (0..255) {
		$escapes{chr($_)} = sprintf("%%%02X", $_);
	}

	# Default unsafe characters.  RFC 2732 ^(uric - reserved)
	$data =~ s/([^A-Za-z0-9\-_.!~*'()])/$escapes{$1}/g;
	return $data
}

#ICMP decode 
sub ICMP_decode {
my $pkt= shift;  
my ($type, $code, $cksum, $data);
     if (defined($pkt)) {
my ($type,$code,$cksum); 
     
       ($type, $code, $cksum, $data) =
            unpack("CCna*", $pkt);   
 
  return ($data, $code, $type) ;        
    
    }  
	
}

#IP decode 

sub IP_decode {

my $pkt = shift ;
        my ($tmp,$tos,$len, $id, $foffset,
         $ttl, $proto, $cksum, $src_ip,
         $dest_ip, $options);
 
    if (defined($pkt)) {


        ($tmp, $tos,$len, $id, $foffset,
         $ttl, $proto, $cksum, $src_ip,
         $dest_ip, $options) = unpack('CCnnnCCnNNa*' , $pkt);

        # Extract bit fields
        
        $ver = ($tmp & 0xf0) >> 4;
        $hlen = $tmp & 0x0f;
        
        $flags = $foffset >> 13;
        $foffset = ($foffset & 0x1fff) << 3;

        # Decode variable length header options and remaining data in field

        my $olen = $hlen - 5;
        $olen = 0, if ($olen < 0);  # Check for bad hlen

        # Option length is number of 32 bit words

        $olen = $olen * 4;

        ($options, $data) = unpack("a" . $olen . "a*", $options);

        # Convert 32 bit ip addresses to dotted quad notation

        $src_ip = to_dotquad($src_ip);
        $dest_ip = to_dotquad($dest_ip); 
	return ($src_ip, $dest_ip, $data);
    }
}

#UDP decode 
sub udp_decode {
my $pkt=shift;	


        ($len, $cksum, $src_port, $dest_port, $data) = 
        unpack("nnnna*", $pkt);
        print "Source port: $src_port \n Destination port: $dest_port \n Mess length: $len \n UDP checksum: $cksum \n ";
        return $data;


}


sub forked {

my @pids;
my $npids=0;


	foreach $file (@files)
	{
	my $pid;
	$pid=fork();
	if($pid>0){
		$npids++;
		if($npids>=$max_processes){
			for(1..($max_processes)){
				my $wait_ret=wait();
				if($wait_ret>0){
					$npids--;
				}
			}
		}
		next;
	}elsif(undef $pid){
		print " Fork error!\n";
		exit(0);
	}else{
		local $SIG{'ALRM'} = sub { exit(0); };
		alarm 0;

	eval {
		 if (($ping) && !($nodos)){
		 	
	    snmp_ping();
	}

	 	pdu_decode($file);

	};  


		exit(0);
	}
}

for(1..$npids){
	my $wt=wait();
	if($wt==-1){
		print " is  $!\n";
		redo;
	}
}


}



sub pdu_decode {
	 my $pkt;
	 my $file = shift;
if ($single) {	open(F, "< $file") or die "Unable to open PDU testcase $file ";}
else {open(F, "< $pdudir/$file") or die "Unable to open PDU testcase $file ";}
#Here we go with binary mode
     binmode(F);
     my $buf;
$buf=sysread(F, $pkt, 1024); # Read 1024 b from testcase
     close(F);                                                       
             
    pdu_send ($pkt);  
    return 0;  		
}
	

	


	
sub pdu_send {  
    
my ($treturn, $rpkt, $currentret); 
 my $pkt =shift;
 my $MAXLEN=1;

           
 
    for ( my $i = 0; $i < $retries; $i++) {
             my $sock = IO::Socket::INET->new(Proto => 'udp');
             send($sock,$pkt,0,pack_sockaddr_in($port,inet_aton($server)));

		   
        eval {   
    local $SIG{ALRM} = \&timed_out;
    alarm $timeout;
    $sock->recv($rpkt, $MAXLEN);
    close $sock;
    alarm 0;
           
    
}  ;
         
 
     } 
           print "\n***Last sent PDU case number : $pdudir/$file \n";

@rets = split( //, $rpkt );
foreach $currentret (@rets) { $treturn .=  unpack "H*",($currentret); }
     
                 if ($treturn =="30") 
                 {
 	                                          
       print "*** Recieved reply from server \n";
         undef($treturn);
		 undef($rpkt);     
                   
                 } 
                    	
}  


sub snmp_ping {      

my ($treturn, $rpkt, $currentret);

 my $pkt = pack "C*",( 0x30, 0x28, 0x02, 0x01, 0x00, 0x04, 0x06, 0x70, 0x75, 0x62, 0x6C, 0x69, 0x63, 0xA0, 0x1B, 
             0x02, 0x03, 0x00, 0xC9, 0x33, 0x02, 0x01, 0x00, 0x02, 0x01, 0x00, 0x30, 0x0E, 0x30, 0x0C, 0x06, 0x08,
             0x2B, 0x06, 0x01, 0x02, 0x01, 0x01, 0x01, 0x00, 0x05, 0x00 );
 my $MAXLEN=1;
         
 for ( my $i = 0; $i < $retries; $i++) {

             my $sock = IO::Socket::INET->new(Proto => 'udp');
             send($sock,$pkt,0,pack_sockaddr_in($port,inet_aton($server)));
             
            

	   
        eval {   

    local $SIG{ALRM} = \&timed_out;
    alarm $timeout;
    $sock->recv($rpkt, $MAXLEN);
    alarm 0;
    close $sock;
    
}  ;
 
     } 
               
@rets = split( //, $rpkt );
 
 foreach $currentret (@rets) { $treturn .= unpack "H*", ($currentret); }

                 if ($treturn) 
                 {
                     
                                                          
             print "\n <<<<<<<<<<<<<<<SNMP pong *$treturn >>>>>>>>>>\n" ;                     
       
                 }  else {
         print "\n****************** SNMP is timed out*************\n";
         print "\n*******************See last send test************\n";
            if ($kiledt) {
            	kill_all()
                 }
                 
                 }
}  

sub usage {
  print <<EOF ;
usage: $0 [snmp] [--host=host] [ --port=port ] [--maxprocess=i]

Options:
  --port=n                 Target SNMP server port. Defaults to 161.
  --host                   Target SNMP server host.
  --maxprocess=n           Maximum process fork to scan. Defaults to 20.
  --snmp request
  --snmpencode request
  --snmp trap
  --snmp trapencode
  --ping                   SNMP ping  SysDescr request, community "public"
  --nodos		   Only one SNMP ping forked (recommended for fork scan)
  --fork                   Default no fork only ICMP listener and one UDP client
  --file=s                 Single PDU test 
  --timeout=n              Request timeout (1 second default)
  --retries=n		   UDP send retries . Default = 1
  --kill                   Kill if snmp ping is unsuccessful
Example :
./snmpfuzz.pl --file snmp/00000001 --host 192.168.66.202 
./snmpfuzz.pl --trap --ping --host 192.168.66.202 --port 162
./snmpfuzz.pl --snmp --nodos --ping --fork --maxprocess 10 --host 192.168.66.202   
./snmpfuzz.pl --snmp --nodos --ping --fork --maxprocess 30 --kill --host 192.168.66.202 --timeout 3 
  --help                   This message
EOF
  exit shift;
}

sub banner
{
	print"###############################################################\n";
    print"#   SNMP fuzzer $VERSION ,using PROTOS Test-Suite cases                 #\n";
    print"#                                                                 #\n";
	print"#   http://www.arhont.com/index-5.html                        #\n";
	print"################################################################\n";
	print"\n";
}

sub banner_end
{
	print"###############################################################\n";
	print"#   SNMP fuzzer  $VERSION                                           #\n";
        print"#   ALL scans are done                                        #\n";
	print"#   http://www.arhont.com/index-5.html                        #\n" ;
	print"###############################################################\n";
	print( "\n", "c" );
}

sub kill_all {
	print " Killing ICMP listener \n";
                kill ("TERM" => $kidpid);
              # kill ('TERM', getppid());
                 exit 0;  
	
}
sub nodos {
while ($kidpid) {
snmp_ping()	
}
 	
} 

exit (0);
