/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.IOException;
import java.util.Date;

public class AppVersion
implements XMLWriteable,
Cloneable {
    public static final String ELEMENT_NAME = "AppVersion";
    private final long sequence;
    private long timestamp;
    private String releaseName;
    private int numClasses;
    private int codeSize;

    public AppVersion(long sequence, long time, String name) {
        this.sequence = sequence;
        this.timestamp = time;
        this.releaseName = name;
    }

    public AppVersion(long sequence, Date time, String name) {
        this.sequence = sequence;
        this.timestamp = time.getTime();
        this.releaseName = name;
    }

    public AppVersion(long sequence) {
        this.sequence = sequence;
        this.timestamp = System.currentTimeMillis();
        this.releaseName = "";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public long getSequenceNumber() {
        return this.sequence;
    }

    public long getTimestamp() {
        if (this.timestamp <= 0L) {
            return System.currentTimeMillis();
        }
        return this.timestamp;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public AppVersion setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public AppVersion setReleaseName(String releaseName) {
        this.releaseName = releaseName;
        return this;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        xmlOutput.openCloseTag(ELEMENT_NAME, new XMLAttributeList().addAttribute("sequence", String.valueOf(this.sequence)).addAttribute("timestamp", String.valueOf(this.timestamp)).addAttribute("release", this.releaseName).addAttribute("codeSize", String.valueOf(this.codeSize)).addAttribute("numClasses", String.valueOf(this.numClasses)));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.valueOf(this.sequence));
        buf.append(',');
        buf.append(String.valueOf(this.timestamp));
        buf.append(',');
        buf.append(this.releaseName);
        buf.append(',');
        buf.append(this.codeSize);
        buf.append(',');
        buf.append(this.codeSize);
        return buf.toString();
    }

    public AppVersion setNumClasses(int numClasses) {
        this.numClasses = numClasses;
        return this;
    }

    public int getNumClasses() {
        return this.numClasses;
    }

    public AppVersion setCodeSize(int codeSize) {
        this.codeSize = codeSize;
        return this;
    }

    public int getCodeSize() {
        return this.codeSize;
    }
}

