/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.WarningSuppressor;
import edu.umd.cs.findbugs.annotations.SuppressMatchType;
import edu.umd.cs.findbugs.detect.UselessSuppressionDetector;

public class ClassWarningSuppressor
extends WarningSuppressor {
    private static final String BUG_TYPE = "US_USELESS_SUPPRESSION_ON_CLASS";
    ClassAnnotation clazz;
    private final boolean userGeneratedClass;

    public ClassWarningSuppressor(String bugPattern, SuppressMatchType matchType, ClassAnnotation clazz, boolean userGeneratedClass) {
        super(bugPattern, matchType);
        this.clazz = clazz;
        this.userGeneratedClass = userGeneratedClass;
        if (DEBUG) {
            System.out.println("Suppressing " + bugPattern + " in " + String.valueOf(clazz));
        }
    }

    public ClassAnnotation getClassAnnotation() {
        return this.clazz;
    }

    @Override
    public BugInstance buildUselessSuppressionBugInstance(UselessSuppressionDetector detector) {
        return new BugInstance(detector, BUG_TYPE, 2).addClass(this.clazz.getClassDescriptor()).addString(this.bugPattern);
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        if (!super.match(bugInstance)) {
            return false;
        }
        ClassAnnotation primaryClassAnnotation = bugInstance.getPrimaryClass();
        if (DEBUG) {
            System.out.println("Compare " + String.valueOf(primaryClassAnnotation) + " with " + String.valueOf(this.clazz));
        }
        return this.clazz.contains(primaryClassAnnotation);
    }

    @Override
    public boolean isUselessSuppressionReportable() {
        return this.userGeneratedClass;
    }
}

