/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.WarningComparator;
import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import edu.umd.cs.findbugs.model.ClassNameRewriter;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class FuzzyBugComparator
implements WarningComparator {
    private static final boolean DEBUG = false;
    private final IdentityHashMap<BugInstance, BugCollection> bugCollectionMap = new IdentityHashMap();
    private ClassNameRewriter classNameRewriter;
    @StaticConstant
    private static final Set<String> significantDescriptionSet = Set.of("CLASS_DEFAULT", "CLASS_EXCEPTION", "CLASS_REFTYPE", "CLASS_SUPERCLASS", "CLASS_IMPLEMENTED_INTERFACE", "INTERFACE_TYPE", "METHOD_DEFAULT", "METHOD_CALLED", "METHOD_DANGEROUS_TARGET", "METHOD_DECLARED_NONNULL", "FIELD_DEFAULT", "FIELD_ON", "FIELD_SUPER", "FIELD_MASKED", "FIELD_MASKING", "FIELD_STORED", "TYPE_DEFAULT", "TYPE_EXPECTED", "TYPE_FOUND", "LOCAL_VARIABLE_NAMED", "INT_NULL_ARG", "INT_MAYBE_NULL_ARG", "INT_NONNULL_PARAM", "SOURCE_LINE_DEFAULT");

    public void registerBugCollection(BugCollection bugCollection) {
    }

    @Override
    public void setClassNameRewriter(ClassNameRewriter classNameRewriter) {
        this.classNameRewriter = classNameRewriter;
    }

    @Override
    public int compare(BugInstance lhs, BugInstance rhs) {
        BugPattern lhsPattern = lhs.getBugPattern();
        BugPattern rhsPattern = rhs.getBugPattern();
        int cmp = lhsPattern.getAbbrev().compareTo(rhsPattern.getAbbrev());
        if (cmp != 0) {
            return cmp;
        }
        BugCollection lhsCollection = this.bugCollectionMap.get(lhs);
        BugCollection rhsCollection = this.bugCollectionMap.get(rhs);
        FilteringBugAnnotationIterator lhsIter = new FilteringBugAnnotationIterator(lhs.annotationIterator());
        FilteringBugAnnotationIterator rhsIter = new FilteringBugAnnotationIterator(rhs.annotationIterator());
        while (lhsIter.hasNext() && rhsIter.hasNext()) {
            BugAnnotation lhsAnnotation = (BugAnnotation)lhsIter.next();
            BugAnnotation rhsAnnotation = (BugAnnotation)rhsIter.next();
            cmp = lhsAnnotation.getClass().getName().compareTo(rhsAnnotation.getClass().getName());
            if (cmp != 0) {
                return cmp;
            }
            cmp = lhsAnnotation.getClass() == ClassAnnotation.class ? this.compareClasses(lhsCollection, rhsCollection, (ClassAnnotation)lhsAnnotation, (ClassAnnotation)rhsAnnotation) : (lhsAnnotation.getClass() == MethodAnnotation.class ? this.compareMethods(lhsCollection, rhsCollection, (MethodAnnotation)lhsAnnotation, (MethodAnnotation)rhsAnnotation) : (lhsAnnotation.getClass() == SourceLineAnnotation.class ? this.compareSourceLines(lhsCollection, rhsCollection, (SourceLineAnnotation)lhsAnnotation, (SourceLineAnnotation)rhsAnnotation) : lhsAnnotation.compareTo(rhsAnnotation)));
            if (cmp == 0) continue;
            return cmp;
        }
        if (!lhsIter.hasNext() && !rhsIter.hasNext()) {
            return 0;
        }
        return lhsIter.hasNext() ? 1 : -1;
    }

    private static int compareNullElements(Object a, Object b) {
        if (a != null) {
            return 1;
        }
        if (b != null) {
            return -1;
        }
        return 0;
    }

    public int compareClasses(BugCollection lhsCollection, BugCollection rhsCollection, ClassAnnotation lhsClass, ClassAnnotation rhsClass) {
        if (lhsClass == null || rhsClass == null) {
            return FuzzyBugComparator.compareNullElements(lhsClass, rhsClass);
        }
        return this.compareClassesByName(lhsCollection, rhsCollection, lhsClass.getClassName(), rhsClass.getClassName());
    }

    public int compareClassesByName(BugCollection lhsCollection, BugCollection rhsCollection, String lhsClassName, String rhsClassName) {
        lhsClassName = this.rewriteClassName(lhsClassName);
        rhsClassName = this.rewriteClassName(rhsClassName);
        return lhsClassName.compareTo(rhsClassName);
    }

    private String rewriteClassName(String className) {
        if (this.classNameRewriter != null) {
            className = this.classNameRewriter.rewriteClassName(className);
        }
        return className;
    }

    public int compareMethods(BugCollection lhsCollection, BugCollection rhsCollection, MethodAnnotation lhsMethod, MethodAnnotation rhsMethod) {
        if (lhsMethod == null || rhsMethod == null) {
            return FuzzyBugComparator.compareNullElements(lhsMethod, rhsMethod);
        }
        return lhsMethod.compareTo(rhsMethod);
    }

    public int compareSourceLines(BugCollection lhsCollection, BugCollection rhsCollection, SourceLineAnnotation lhs, SourceLineAnnotation rhs) {
        if (lhs == null || rhs == null) {
            return FuzzyBugComparator.compareNullElements(lhs, rhs);
        }
        int cmp = this.compareClassesByName(lhsCollection, rhsCollection, lhs.getClassName(), rhs.getClassName());
        if (cmp != 0) {
            return cmp;
        }
        return 0;
    }

    public static boolean ignore(BugAnnotation annotation) {
        return !significantDescriptionSet.contains(annotation.getDescription());
    }

    private static class FilteringBugAnnotationIterator
    implements Iterator<BugAnnotation> {
        Iterator<BugAnnotation> iter;
        BugAnnotation next;

        public FilteringBugAnnotationIterator(Iterator<BugAnnotation> iter) {
            this.iter = iter;
        }

        private void findNext() {
            if (this.next == null) {
                while (this.iter.hasNext()) {
                    BugAnnotation candidate = this.iter.next();
                    if (FuzzyBugComparator.ignore(candidate)) continue;
                    this.next = candidate;
                    break;
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.next != null;
        }

        @Override
        public BugAnnotation next() {
            this.findNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            BugAnnotation result = this.next;
            this.next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

