/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.ClassWarningSuppressor;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.annotations.SuppressMatchType;
import edu.umd.cs.findbugs.detect.UselessSuppressionDetector;

public class ParameterWarningSuppressor
extends ClassWarningSuppressor {
    private static final String BUG_TYPE = "US_USELESS_SUPPRESSION_ON_METHOD_PARAMETER";
    final MethodAnnotation method;
    final int register;

    public ParameterWarningSuppressor(String bugPattern, SuppressMatchType matchType, ClassAnnotation clazz, MethodAnnotation method, int register, boolean userGeneratedClass) {
        super(bugPattern, matchType, clazz, userGeneratedClass);
        this.method = method;
        this.register = register;
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        if (!super.match(bugInstance)) {
            return false;
        }
        MethodAnnotation bugMethod = bugInstance.getPrimaryMethod();
        LocalVariableAnnotation localVariable = bugInstance.getPrimaryLocalVariableAnnotation();
        if (bugMethod == null || !this.method.equals(bugMethod)) {
            return false;
        }
        if (localVariable == null || localVariable.getRegister() != this.register) {
            return false;
        }
        if (DEBUG) {
            System.out.println("Suppressing " + String.valueOf(bugInstance));
        }
        return true;
    }

    @Override
    public BugInstance buildUselessSuppressionBugInstance(UselessSuppressionDetector detector) {
        return new BugInstance(detector, BUG_TYPE, 2).addClass(this.clazz.getClassDescriptor()).addMethod(this.method).addParameterAnnotation(this.register, "LOCAL_VARIABLE_PARAMETER").addString(this.bugPattern);
    }
}

