/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.SourceFileDataSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public class FileSourceFileDataSource
implements SourceFileDataSource {
    private final String fileName;
    private final URI uri;

    public FileSourceFileDataSource(String fileName) {
        this.fileName = fileName;
        this.uri = new File(fileName).toURI();
    }

    @Override
    public InputStream open() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.fileName));
    }

    @Override
    public String getFullFileName() {
        return this.fileName;
    }

    @Override
    public URI getFullURI() {
        return this.uri;
    }

    @Override
    public long getLastModified() {
        return new File(this.fileName).lastModified();
    }
}

