/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import org.apache.bcel.classfile.Code;

public class BadUseOfReturnValue
extends BytecodeScanningDetector {
    BugAccumulator bugAccumulator;
    boolean readLineOnTOS = false;
    boolean stringIndexOfOnTOS = false;

    public BadUseOfReturnValue(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(Code obj) {
        this.stringIndexOfOnTOS = false;
        this.readLineOnTOS = false;
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 182 && "indexOf".equals(this.getNameConstantOperand()) && "java/lang/String".equals(this.getClassConstantOperand()) && "(Ljava/lang/String;)I".equals(this.getSigConstantOperand())) {
            this.stringIndexOfOnTOS = true;
        } else if (this.stringIndexOfOnTOS) {
            if (seen == 158 || seen == 157) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "RV_CHECK_FOR_POSITIVE_INDEXOF", 3).addClassAndMethod(this), this);
            }
            this.stringIndexOfOnTOS = false;
        }
        if (seen == 182 && "readLine".equals(this.getNameConstantOperand()) && "()Ljava/lang/String;".equals(this.getSigConstantOperand()) && (this.getClassConstantOperand().startsWith("java/io") && !"java/io/LineNumberReader".equals(this.getClassConstantOperand()) || this.getClassConstantOperand().startsWith("javax/imageio/stream"))) {
            this.readLineOnTOS = true;
        } else if (this.readLineOnTOS) {
            if (seen == 198 || seen == 199) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "RV_DONT_JUST_NULL_CHECK_READLINE", 2).addClassAndMethod(this), this);
            }
            this.readLineOnTOS = false;
        }
    }
}

