/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.asm.ClassNodeDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public class CheckRelaxingNullnessAnnotation
extends ClassNodeDetector {
    public CheckRelaxingNullnessAnnotation(BugReporter bugReporter) {
        super(bugReporter);
    }

    public MethodVisitor visitMethod(int methodAccess, String methodName, String desc, String methodSignature, String[] exceptions) {
        if ((methodAccess & 8) != 0) {
            return null;
        }
        XMethod xmethod = this.xclass.findMethod(methodName, desc, false);
        if (xmethod == null) {
            this.bugReporter.reportSkippedAnalysis(new MethodDescriptor(this.xclass.getClassDescriptor().getClassName(), methodName, desc, false));
            return null;
        }
        return new DetectorNode(methodAccess, methodName, desc, methodSignature, exceptions, xmethod);
    }

    static boolean containsRelaxedNonNull(@CheckForNull List<AnnotationNode> methodAnnotations) {
        if (methodAnnotations == null) {
            return false;
        }
        for (AnnotationNode annotation : methodAnnotations) {
            NullnessAnnotation nullness = CheckRelaxingNullnessAnnotation.getNullness(annotation.desc);
            if (nullness != NullnessAnnotation.CHECK_FOR_NULL && nullness != NullnessAnnotation.NULLABLE) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    static Map<Integer, NullnessAnnotation> getNonnullOrNullableParams(@CheckForNull List<AnnotationNode>[] parameterAnnotations) {
        if (parameterAnnotations == null) {
            return null;
        }
        HashMap<Integer, NullnessAnnotation> nonNullParameter = new HashMap<Integer, NullnessAnnotation>();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            List<AnnotationNode> annotations = parameterAnnotations[i];
            if (annotations == null) continue;
            for (AnnotationNode annotation : annotations) {
                NullnessAnnotation nullness = CheckRelaxingNullnessAnnotation.getNullness(annotation.desc);
                if (nullness == null || nullness == NullnessAnnotation.CHECK_FOR_NULL) continue;
                nonNullParameter.put(i, nullness);
            }
        }
        return nonNullParameter;
    }

    @CheckForNull
    static NullnessAnnotation getNullness(@SlashedClassName String annotationDesc) {
        if (annotationDesc.length() < 2) {
            return null;
        }
        String substring = annotationDesc.substring(1, annotationDesc.length() - 1);
        return NullnessAnnotation.Parser.parse(ClassName.toDottedClassName(substring));
    }

    static boolean containsNullness(Collection<AnnotationValue> annotations, NullnessAnnotation nullness) {
        for (AnnotationValue annotation : annotations) {
            NullnessAnnotation check = NullnessAnnotation.Parser.parse(annotation.getAnnotationClass().getDottedClassName());
            if (check != nullness) continue;
            return true;
        }
        return false;
    }

    static boolean compatibleParameters(String signature, String superSignature) {
        SignatureParser sig = new SignatureParser(signature);
        SignatureParser superSig = new SignatureParser(superSignature);
        if (sig.getNumParameters() == superSig.getNumParameters()) {
            String superRetSig;
            Iterator<String> params = sig.parameterSignatureIterator();
            Iterator<String> superParams = superSig.parameterSignatureIterator();
            while (params.hasNext()) {
                String superParam;
                String param = params.next();
                if (CheckRelaxingNullnessAnnotation.areRelated(param, superParam = superParams.next())) continue;
                return false;
            }
            String retSig = sig.getReturnTypeSignature();
            if (CheckRelaxingNullnessAnnotation.areRelated(retSig, superRetSig = superSig.getReturnTypeSignature())) {
                return true;
            }
        }
        return false;
    }

    static boolean areRelated(String sig, String superSig) {
        try {
            if (sig.equals(superSig)) {
                return true;
            }
            if (sig.charAt(0) == 'L' && superSig.charAt(0) == 'L') {
                sig = sig.substring(1, sig.length() - 1);
                superSig = superSig.substring(1, superSig.length() - 1);
                return Hierarchy.isSubtype(sig, superSig);
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        return false;
    }

    private class HierarchyIterator {
        private XClass superclass;
        private Queue<ClassDescriptor> interfacesToVisit;
        private final Set<ClassDescriptor> visited;

        public HierarchyIterator(XClass xclass) {
            this.interfacesToVisit = new LinkedList<ClassDescriptor>(Arrays.asList(xclass.getInterfaceDescriptorList()));
            this.visited = new HashSet<ClassDescriptor>();
            this.superclass = CheckRelaxingNullnessAnnotation.this.getClassInfo(xclass.getSuperclassDescriptor());
        }

        public XClass next() {
            while (!this.interfacesToVisit.isEmpty()) {
                XClass xinterface;
                ClassDescriptor interfaceDescr = this.interfacesToVisit.poll();
                if (!this.visited.add(interfaceDescr) || (xinterface = CheckRelaxingNullnessAnnotation.this.getClassInfo(interfaceDescr)) == null) continue;
                this.interfacesToVisit.addAll(Arrays.asList(xinterface.getInterfaceDescriptorList()));
                return xinterface;
            }
            if (this.superclass == null) {
                return null;
            }
            XClass currentSuperclass = this.superclass;
            this.superclass = CheckRelaxingNullnessAnnotation.this.getClassInfo(this.superclass.getSuperclassDescriptor());
            if (this.superclass != null) {
                this.interfacesToVisit = new LinkedList<ClassDescriptor>(Arrays.asList(this.superclass.getInterfaceDescriptorList()));
            }
            return currentSuperclass;
        }
    }

    private final class DetectorNode
    extends MethodNode {
        private final XMethod xmethod;
        private Map<Integer, NullnessAnnotation> nonNullParameter;
        private boolean relaxedNullReturn;

        DetectorNode(int access, String name, String desc, String signature, String[] exceptions, XMethod xmethod) {
            super(589824, access, name, desc, signature, exceptions);
            this.xmethod = xmethod;
        }

        public void visitEnd() {
            XClass superClass;
            super.visitEnd();
            this.relaxedNullReturn = CheckRelaxingNullnessAnnotation.containsRelaxedNonNull(this.visibleAnnotations);
            if (!this.relaxedNullReturn) {
                this.relaxedNullReturn = CheckRelaxingNullnessAnnotation.containsRelaxedNonNull(this.invisibleAnnotations);
            }
            boolean needsCheck = this.relaxedNullReturn;
            if (this.invisibleParameterAnnotations != null || this.visibleParameterAnnotations != null) {
                this.nonNullParameter = CheckRelaxingNullnessAnnotation.getNonnullOrNullableParams(this.visibleParameterAnnotations);
                Map<Integer, NullnessAnnotation> nnp = CheckRelaxingNullnessAnnotation.getNonnullOrNullableParams(this.invisibleParameterAnnotations);
                if (nnp != null) {
                    if (this.nonNullParameter == null) {
                        this.nonNullParameter = nnp;
                    } else {
                        this.nonNullParameter.putAll(nnp);
                    }
                }
                needsCheck |= !this.nonNullParameter.isEmpty();
            }
            if (!needsCheck) {
                return;
            }
            HierarchyIterator hierarchy = new HierarchyIterator(CheckRelaxingNullnessAnnotation.this.xclass);
            boolean done = false;
            block0: while (!done && (superClass = hierarchy.next()) != null) {
                XMethod method = superClass.findMethod(this.name, this.desc, false);
                if (method != null) {
                    done = this.checkMethod(method);
                    continue;
                }
                for (XMethod xMethod : superClass.getXMethods()) {
                    if (!this.name.equals(xMethod.getName()) || !CheckRelaxingNullnessAnnotation.compatibleParameters(this.desc, xMethod.getSignature()) || !this.checkMethod(xMethod)) continue;
                    done = true;
                    continue block0;
                }
            }
        }

        private final boolean checkMethod(@Nonnull XMethod method) {
            boolean foundAny = false;
            if (this.relaxedNullReturn && CheckRelaxingNullnessAnnotation.containsNullness(method.getAnnotations(), NullnessAnnotation.NONNULL)) {
                BugInstance bug = new BugInstance(CheckRelaxingNullnessAnnotation.this, "NP_METHOD_RETURN_RELAXING_ANNOTATION", 1);
                bug.addClassAndMethod(this.xmethod);
                CheckRelaxingNullnessAnnotation.this.bugReporter.reportBug(bug);
                foundAny = true;
            }
            if (this.nonNullParameter != null) {
                for (Map.Entry<Integer, NullnessAnnotation> e : this.nonNullParameter.entrySet()) {
                    int i = e.getKey();
                    if (!CheckRelaxingNullnessAnnotation.containsNullness(method.getParameterAnnotations(i), NullnessAnnotation.CHECK_FOR_NULL)) continue;
                    NullnessAnnotation a = e.getValue();
                    BugInstance bug = new BugInstance(CheckRelaxingNullnessAnnotation.this, "NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION", a.equals(NullnessAnnotation.NONNULL) ? 1 : 2);
                    bug.addClassAndMethod(this.xmethod);
                    LocalVariableAnnotation lva = null;
                    if (this.localVariables != null) {
                        for (LocalVariableNode lvn : this.localVariables) {
                            if (lvn.index != i + 1) continue;
                            lva = new LocalVariableAnnotation(lvn.name, i + 1, 0);
                            lva.setDescription("LOCAL_VARIABLE_PARAMETER_NAMED");
                            break;
                        }
                    }
                    if (lva == null) {
                        lva = new LocalVariableAnnotation("?", i + 1, 0);
                        lva.setDescription("LOCAL_VARIABLE_PARAMETER");
                    }
                    bug.add(lva);
                    CheckRelaxingNullnessAnnotation.this.bugReporter.reportBug(bug);
                    foundAny = true;
                }
            }
            return foundAny;
        }
    }
}

