/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.constant.Constant;
import edu.umd.cs.findbugs.ba.constant.ConstantDataflow;
import edu.umd.cs.findbugs.ba.constant.ConstantFrame;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.detect.BuildStringPassthruGraph;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class DumbMethodInvocations
implements Detector {
    private static final MethodDescriptor STRING_SUBSTRING = new MethodDescriptor("java/lang/String", "substring", "(I)Ljava/lang/String;");
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;
    private final Map<MethodDescriptor, int[]> allFileNameStringMethods;
    private final Map<MethodDescriptor, int[]> allDatabasePasswordMethods;

    public DumbMethodInvocations(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
        BuildStringPassthruGraph.StringPassthruDatabase database = Global.getAnalysisCache().getDatabase(BuildStringPassthruGraph.StringPassthruDatabase.class);
        this.allFileNameStringMethods = database.getFileNameStringMethods();
        this.allDatabasePasswordMethods = database.findLinkedMethods(Collections.singleton(new BuildStringPassthruGraph.MethodParameter(new MethodDescriptor("java/sql/DriverManager", "getConnection", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/sql/Connection;", true), 2)));
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        for (Method method : methodList = classContext.getJavaClass().getMethods()) {
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
                this.bugAccumulator.reportAccumulatedBugs();
            }
            catch (MethodUnprofitableException mue) {
                if (!SystemProperties.getBoolean("unprofitable.debug")) continue;
                this.bugReporter.logError("skipping unprofitable method in " + this.getClass().getName());
            }
            catch (CFGBuilderException | DataflowAnalysisException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        CFG cfg = classContext.getCFG(method);
        ConstantDataflow constantDataflow = classContext.getConstantDataflow(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        MethodGen methodGen = classContext.getMethodGen(method);
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Constant operandValue;
            Location location = i.next();
            Instruction ins = location.getHandle().getInstruction();
            if (!(ins instanceof InvokeInstruction)) continue;
            InvokeInstruction iins = (InvokeInstruction)ins;
            SignatureParser parser = new SignatureParser(iins.getSignature(cpg));
            ConstantFrame frame = (ConstantFrame)constantDataflow.getFactAtLocation(location);
            if (!frame.isValid()) continue;
            MethodDescriptor md = new MethodDescriptor(iins, cpg);
            if (this.allDatabasePasswordMethods.containsKey(md)) {
                for (int paramNumber : this.allDatabasePasswordMethods.get(md)) {
                    operandValue = (Constant)frame.getArgument(iins, cpg, paramNumber, parser);
                    if (!operandValue.isConstantString()) continue;
                    String password = operandValue.getConstantString();
                    if (password.isEmpty()) {
                        this.bugAccumulator.accumulateBug(new BugInstance(this, "DMI_EMPTY_DB_PASSWORD", 2).addClassAndMethod(methodGen, sourceFile), classContext, methodGen, sourceFile, location);
                        continue;
                    }
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "DMI_CONSTANT_DB_PASSWORD", 2).addClassAndMethod(methodGen, sourceFile), classContext, methodGen, sourceFile, location);
                }
            }
            if (md.equals(STRING_SUBSTRING)) {
                int v;
                Constant operandValue2 = (Constant)frame.getTopValue();
                if (!operandValue2.isConstantInteger() || (v = operandValue2.getConstantInt()) != 0) continue;
                this.bugAccumulator.accumulateBug(new BugInstance(this, "DMI_USELESS_SUBSTRING", 2).addClassAndMethod(methodGen, sourceFile), classContext, methodGen, sourceFile, location);
                continue;
            }
            if (!this.allFileNameStringMethods.containsKey(md)) continue;
            for (int paramNumber : this.allFileNameStringMethods.get(md)) {
                String v;
                operandValue = (Constant)frame.getArgument(iins, cpg, paramNumber, parser);
                if (!operandValue.isConstantString() || !this.isAbsoluteFileName(v = operandValue.getConstantString()) || v.startsWith("/etc/") || v.startsWith("/dev/") || v.startsWith("/proc")) continue;
                int priority = 2;
                if (v.startsWith("/tmp")) {
                    priority = 3;
                } else if (v.indexOf("/home") >= 0) {
                    priority = 1;
                }
                this.bugAccumulator.accumulateBug(new BugInstance(this, "DMI_HARDCODED_ABSOLUTE_FILENAME", priority).addClassAndMethod(methodGen, sourceFile).addString(v).describe("FILE_NAME"), classContext, methodGen, sourceFile, location);
            }
        }
    }

    private boolean isAbsoluteFileName(String v) {
        char driveletter;
        if (v.startsWith("/dev/")) {
            return false;
        }
        if (v.startsWith("/")) {
            return true;
        }
        if (v.startsWith("\\\\")) {
            return true;
        }
        if (v.length() >= 2 && v.charAt(1) == ':' && ((driveletter = v.charAt(0)) >= 'A' && driveletter <= 'Z' || driveletter >= 'a' && driveletter <= 'z')) {
            return true;
        }
        try {
            File f = new File(v);
            return f.isAbsolute();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Override
    public void report() {
    }
}

