/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bytecode.MemberUtils;
import java.util.Arrays;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindHiddenMethod
implements Detector {
    private final BugReporter bugReporter;

    public FindHiddenMethod(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methods;
        JavaClass[] superClasses;
        JavaClass subClass = classContext.getJavaClass();
        try {
            superClasses = subClass.getSuperClasses();
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return;
        }
        for (Method method : methods = subClass.getMethods()) {
            if (!method.isStatic() || method.isPrivate() || method.isSynthetic() || MemberUtils.isMainMethod(method) || this.isConstructor(method) || this.isHidingInnerClass(method) || this.isAutoGeneratedMethod(method)) continue;
            for (JavaClass superClass : superClasses) {
                Method[] superMethods = superClass.getMethods();
                if (!Arrays.asList(superMethods).contains(method)) continue;
                this.bugReporter.reportBug(new BugInstance(this, "HSM_HIDING_METHOD", 2).addClass(subClass).addMethod(subClass, method).addClass(superClass).describe("CLASS_SUPERCLASS").addSourceLine(SourceLineAnnotation.fromVisitedInstruction(subClass, method, 0)));
            }
        }
    }

    @Override
    public void report() {
    }

    private boolean isHidingInnerClass(Method method) {
        return method.getName().contains("access$");
    }

    private boolean isAutoGeneratedMethod(Method method) {
        return method.getName().contains("class$");
    }

    private boolean isConstructor(Method method) {
        return "<clinit>".equals(method.getName()) || "<init>".equals(method.getName());
    }
}

