/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumberSourceInfo;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class FindSelfComparison2
implements Detector {
    private final BugReporter bugReporter;

    public FindSelfComparison2(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        for (Method method : methodList = classContext.getJavaClass().getMethods()) {
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (MethodUnprofitableException mue) {
                if (!SystemProperties.getBoolean("unprofitable.debug")) continue;
                this.bugReporter.logError("skipping unprofitable method in " + this.getClass().getName());
            }
            catch (CFGBuilderException | DataflowAnalysisException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", e);
            }
        }
    }

    static boolean booleanComparisonMethod(String methodName) {
        return "equals".equals(methodName) || "endsWith".equals(methodName) || "startsWith".equals(methodName) || "contains".equals(methodName) || "equalsIgnoreCase".equals(methodName);
    }

    static boolean comparatorMethod(String methodName) {
        return "compareTo".equals(methodName) || "compareToIgnoreCase".equals(methodName);
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        CFG cfg = classContext.getCFG(method);
        ValueNumberDataflow valueNumberDataflow = classContext.getValueNumberDataflow(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        MethodGen methodGen = classContext.getMethodGen(method);
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        Iterator<Location> i = cfg.locationIterator();
        block6: while (i.hasNext()) {
            Location location = i.next();
            Instruction ins = location.getHandle().getInstruction();
            switch (ins.getOpcode()) {
                case 182: 
                case 185: {
                    InvokeInstruction iins = (InvokeInstruction)ins;
                    String invoking = iins.getName(cpg);
                    if (!FindSelfComparison2.comparatorMethod(invoking) && !FindSelfComparison2.booleanComparisonMethod(invoking) || methodGen.getName().toLowerCase().indexOf("test") >= 0 || methodGen.getClassName().toLowerCase().indexOf("test") >= 0 || classContext.getJavaClass().getSuperclassName().toLowerCase().indexOf("test") >= 0 || location.getHandle().getNext().getInstruction().getOpcode() == 87) break;
                    String sig = iins.getSignature(cpg);
                    SignatureParser parser = new SignatureParser(sig);
                    if (parser.getNumParameters() != 1 || (!FindSelfComparison2.booleanComparisonMethod(invoking) || !sig.endsWith(";)Z")) && (!FindSelfComparison2.comparatorMethod(invoking) || !sig.endsWith(";)I"))) continue block6;
                    this.checkForSelfOperation(classContext, location, valueNumberDataflow, "COMPARISON", method, methodGen, sourceFile);
                    break;
                }
                case 100: 
                case 101: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    this.checkForSelfOperation(classContext, location, valueNumberDataflow, "COMPUTATION", method, methodGen, sourceFile);
                    break;
                }
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    break;
                }
                case 148: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    this.checkForSelfOperation(classContext, location, valueNumberDataflow, "COMPARISON", method, methodGen, sourceFile);
                    break;
                }
            }
        }
    }

    private void checkForSelfOperation(ClassContext classContext, Location location, ValueNumberDataflow valueNumberDataflow, String op, Method method, MethodGen methodGen, String sourceFile) throws DataflowAnalysisException {
        XField field;
        ValueNumberFrame frame = (ValueNumberFrame)valueNumberDataflow.getFactAtLocation(location);
        if (!frame.isValid()) {
            return;
        }
        Instruction ins = location.getHandle().getInstruction();
        short opcode = ins.getOpcode();
        int offset = 1;
        if (opcode == 148 || opcode == 131 || opcode == 127 || opcode == 129 || opcode == 101) {
            offset = 2;
        }
        ValueNumber v0 = (ValueNumber)frame.getStackValue(0);
        ValueNumber v1 = (ValueNumber)frame.getStackValue(offset);
        if (!v1.equals(v0)) {
            return;
        }
        if (v0.hasFlag(4) || v0.hasFlag(16)) {
            return;
        }
        int priority = 1;
        if (opcode == 100 || opcode == 101 || opcode == 185 || opcode == 182) {
            priority = 2;
        }
        if ((field = ValueNumberSourceInfo.findXFieldFromValueNumber(method, location, v0, frame)) != null) {
            return;
        }
        LocalVariableAnnotation annotation = ValueNumberSourceInfo.findLocalAnnotationFromValueNumber(method, location, v0, frame);
        String prefix = "SA_LOCAL_SELF_";
        if (opcode == 100) {
            return;
        }
        if (annotation == null) {
            return;
        }
        SourceLineAnnotation sourceLine = SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, location.getHandle());
        int line = sourceLine.getStartLine();
        BitSet occursMultipleTimes = classContext.linesMentionedMultipleTimes(method);
        if (line > 0 && occursMultipleTimes.get(line)) {
            return;
        }
        BugInstance bug = new BugInstance(this, prefix + op, priority).addClassAndMethod(methodGen, sourceFile);
        if (ins instanceof InvokeInstruction) {
            bug.addCalledMethod(classContext.getConstantPoolGen(), (InvokeInstruction)ins);
        }
        bug.add(annotation).addSourceLine(classContext, methodGen, sourceFile, location.getHandle());
        this.bugReporter.reportBug(bug);
    }

    @Override
    public void report() {
    }
}

