/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.UseAnnotationDatabase;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CheckReturnAnnotationDatabase;
import edu.umd.cs.findbugs.ba.CheckReturnValueAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.detect.FindNoSideEffectMethods;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.Set;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

public class MethodReturnCheck
extends OpcodeStackDetector
implements UseAnnotationDatabase {
    private static final boolean DEBUG = SystemProperties.getBoolean("mrc.debug");
    private static final BitSet INVOKE_OPCODE_SET = new BitSet();
    private static final Set<String> MOCKITO_VOID_STUBBING_METHODS;
    private static final Set<String> BDD_MOCKITO_VOID_STUBBING_METHODS;
    boolean previousOpcodeWasNEW;
    private final BugAccumulator bugAccumulator;
    private CheckReturnAnnotationDatabase checkReturnAnnotationDatabase;
    private XMethod callSeen;
    private State state;
    private int callPC;
    private final FindNoSideEffectMethods.NoSideEffectMethodsDatabase noSideEffectMethods;
    private boolean sawExcludedNSECall;
    private boolean sawMockitoInvoke;

    public MethodReturnCheck(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
        this.noSideEffectMethods = Global.getAnalysisCache().getDatabase(FindNoSideEffectMethods.NoSideEffectMethodsDatabase.class);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        this.checkReturnAnnotationDatabase = AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase();
        super.visitClassContext(classContext);
    }

    @Override
    public void visitAfter(Code code) {
        if (this.bugAccumulator.getLastBugLocation() == null && !this.sawExcludedNSECall && this.noSideEffectMethods.useless(this.getMethodDescriptor())) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "UC_USELESS_VOID_METHOD", code.getCode().length > 40 ? 1 : (code.getCode().length > 15 ? 2 : 3)).addClassAndMethod(this.getMethodDescriptor()), this);
        }
        this.sawExcludedNSECall = false;
        this.bugAccumulator.reportAccumulatedBugs();
    }

    private boolean badUseOfCompareResult(OpcodeStack.Item left, OpcodeStack.Item right) {
        XMethod m = left.getReturnValueOf();
        if (m == null) {
            return false;
        }
        String name = m.getName();
        if (!name.startsWith("compare")) {
            return false;
        }
        Object value = right.getConstant();
        if (!(value instanceof Integer) || (Integer)value == 0) {
            return false;
        }
        if (!m.isPublic() && m.isResolved()) {
            return false;
        }
        if ((m.isStatic() || !m.isResolved()) && "compare".equals(name) && m.getClassName().startsWith("com.google.common.primitives.")) {
            return true;
        }
        if (!m.isStatic() || !m.isResolved()) {
            if ("compareTo".equals(name) && "(Ljava/lang/Object;)I".equals(m.getSignature())) {
                return true;
            }
            if ("compare".equals(name) && "(Ljava/lang/Object;Ljava/lang/Object;)I".equals(m.getSignature())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void sawOpcode(int seen) {
        block20: {
            int arguments;
            OpcodeStack.Item invokedOn;
            if (DEBUG) {
                System.out.printf("%3d %10s %3s %s%n", new Object[]{this.getPC(), Const.getOpcodeName((int)seen), this.state, this.stack});
            }
            switch (seen) {
                case 159: 
                case 160: {
                    XMethod returnValueOf;
                    OpcodeStack.Item left = this.stack.getStackItem(1);
                    OpcodeStack.Item right = this.stack.getStackItem(0);
                    if (this.badUseOfCompareResult(left, right)) {
                        returnValueOf = left.getReturnValueOf();
                        assert (returnValueOf != null);
                        this.bugAccumulator.accumulateBug(new BugInstance(this, "RV_CHECK_COMPARETO_FOR_SPECIFIC_RETURN_VALUE", 2).addClassAndMethod(this).addMethod(returnValueOf).describe("METHOD_CALLED").addValueSource(right, this), this);
                        break;
                    }
                    if (!this.badUseOfCompareResult(right, left)) break;
                    returnValueOf = right.getReturnValueOf();
                    assert (returnValueOf != null);
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "RV_CHECK_COMPARETO_FOR_SPECIFIC_RETURN_VALUE", 2).addClassAndMethod(this).addMethod(returnValueOf).describe("METHOD_CALLED").addValueSource(left, this), this);
                    break;
                }
            }
            if (seen == 183 && "<init>".equals(this.getNameConstantOperand()) && (invokedOn = this.stack.getStackItem(arguments = PreorderVisitor.getNumberArguments(this.getSigConstantOperand()))).isNewlyAllocated() && (!"<init>".equals(this.getMethodName()) || invokedOn.getRegisterNumber() != 0)) {
                for (int i = arguments + 1; i < this.stack.getStackDepth(); ++i) {
                    OpcodeStack.Item item = this.stack.getStackItem(i);
                    if (!item.isNewlyAllocated() || !item.getSignature().equals(invokedOn.getSignature())) {
                        continue;
                    }
                    break block20;
                }
                this.callSeen = XFactory.createReferencedXMethod(this);
                this.callPC = this.getPC();
                this.sawMethodCallWithIgnoredReturnValue();
                this.state = State.SCAN;
                this.previousOpcodeWasNEW = false;
                return;
            }
        }
        if (this.state == State.SAW_INVOKE && this.isPop(seen)) {
            if (!this.sawMockitoInvoke) {
                this.sawMethodCallWithIgnoredReturnValue();
            }
            this.sawMockitoInvoke = false;
        } else if (INVOKE_OPCODE_SET.get(seen)) {
            this.callPC = this.getPC();
            this.callSeen = XFactory.createReferencedXMethod(this);
            this.state = State.SAW_INVOKE;
            this.sawMockitoInvoke |= this.isCallMockitoInvocation(this.callSeen) || this.isCallBDDMockitoInvocation(this.callSeen);
            if (DEBUG) {
                System.out.println("  invoking " + String.valueOf(this.callSeen));
            }
        } else {
            this.state = State.SCAN;
        }
        if (seen == 187) {
            this.previousOpcodeWasNEW = true;
        } else {
            CheckReturnValueAnnotation annotation;
            if (seen == 183 && this.previousOpcodeWasNEW && !this.sawMockitoInvoke && (annotation = this.checkReturnAnnotationDatabase.getResolvedAnnotation(this.callSeen, false)) != null && annotation != CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE) {
                int priority = annotation.getPriority();
                if (!this.checkReturnAnnotationDatabase.annotationIsDirect(this.callSeen) && !this.callSeen.getSignature().endsWith(ClassName.toSlashedClassName(this.callSeen.getClassName()) + ";")) {
                    ++priority;
                }
                this.bugAccumulator.accumulateBug(new BugInstance(this, annotation.getPattern(), priority).addClassAndMethod(this).addCalledMethod(this), this);
            }
            this.previousOpcodeWasNEW = false;
        }
    }

    private boolean isCallMockitoInvocation(XMethod method) {
        return method.isStatic() && "org.mockito.Mockito".equals(method.getClassName()) && MOCKITO_VOID_STUBBING_METHODS.contains(method.getName());
    }

    private boolean isCallBDDMockitoInvocation(XMethod method) {
        return method.isStatic() && "org.mockito.BDDMockito".equals(method.getClassName()) && BDD_MOCKITO_VOID_STUBBING_METHODS.contains(method.getName());
    }

    private void sawMethodCallWithIgnoredReturnValue() {
        BugInstance warning;
        CheckReturnValueAnnotation annotation = this.checkReturnAnnotationDatabase.getResolvedAnnotation(this.callSeen, false);
        if (annotation == null) {
            if (this.noSideEffectMethods.excluded(this.callSeen.getMethodDescriptor())) {
                this.sawExcludedNSECall = true;
            }
            if (this.noSideEffectMethods.hasNoSideEffect(this.callSeen.getMethodDescriptor())) {
                Type methodReturnType;
                int priority = 2;
                Type callReturnType = Type.getReturnType((String)this.callSeen.getMethodDescriptor().getSignature());
                if (callReturnType.equals((Object)(methodReturnType = Type.getReturnType((String)this.getMethodSig()))) && callReturnType != Type.BOOLEAN && callReturnType != Type.VOID) {
                    priority = 1;
                } else {
                    String callReturnClass = this.callSeen.getName().equals("<init>") ? this.callSeen.getClassDescriptor().getClassName() : ClassName.fromFieldSignature(callReturnType.getSignature());
                    String methodReturnClass = ClassName.fromFieldSignatureToDottedClassName(methodReturnType.getSignature());
                    if (callReturnClass != null && methodReturnClass != null && Subtypes2.instanceOf(ClassName.toDottedClassName(callReturnClass), methodReturnClass)) {
                        priority = 1;
                    }
                }
                int catchSize = this.getSizeOfSurroundingTryBlock(this.getPC());
                if (catchSize <= 2) {
                    ++priority;
                }
                warning = new BugInstance(this, "RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT", priority).addClassAndMethod(this).addMethod(this.callSeen).describe("METHOD_CALLED");
                this.bugAccumulator.accumulateBug(warning, SourceLineAnnotation.fromVisitedInstruction(this, this.callPC));
            } else {
                XFactory xFactory = AnalysisContext.currentXFactory();
                if (xFactory.isFunctionshatMightBeMistakenForProcedures(this.callSeen.getMethodDescriptor())) {
                    annotation = CheckReturnValueAnnotation.CHECK_RETURN_VALUE_INFERRED;
                }
            }
        }
        if (annotation != null && annotation.getPriority() <= 3) {
            int popPC = this.getPC();
            if (DEBUG) {
                System.out.println("Saw POP @" + popPC);
            }
            int catchSize = this.getSizeOfSurroundingTryBlock(popPC);
            int priority = annotation.getPriority();
            if (catchSize <= 1) {
                priority += 2;
            } else if (catchSize <= 2) {
                ++priority;
            }
            if (!this.checkReturnAnnotationDatabase.annotationIsDirect(this.callSeen) && !this.callSeen.getSignature().endsWith(ClassName.toSlashedClassName(this.callSeen.getClassName()) + ";")) {
                ++priority;
            }
            if (this.callSeen.isPrivate()) {
                ++priority;
            }
            if ("clone".equals(this.callSeen.getName()) || this.callSeen.getName().startsWith("get")) {
                ++priority;
            }
            String pattern = annotation.getPattern();
            if ("<init>".equals(this.callSeen.getName()) && Subtypes2.instanceOf(this.callSeen.getClassName(), "java.lang.Throwable")) {
                pattern = "RV_EXCEPTION_NOT_THROWN";
            }
            warning = new BugInstance(this, pattern, priority).addClassAndMethod(this).addMethod(this.callSeen).describe("METHOD_CALLED");
            this.bugAccumulator.accumulateBug(warning, SourceLineAnnotation.fromVisitedInstruction(this, this.callPC));
        } else {
            MethodDescriptor methodDescriptor = this.callSeen.getMethodDescriptor();
            SignatureParser methodSigParser = new SignatureParser(methodDescriptor.getSignature());
            String returnTypeSig = methodSigParser.getReturnTypeSignature();
            String returnType = ClassName.fromFieldSignature(returnTypeSig);
            String mContainerClass = methodDescriptor.getClassDescriptor().getClassName();
            if (returnType != null && Subtypes2.instanceOf(ClassName.toDottedClassName(returnType), "java.lang.Throwable") && methodDescriptor.isStatic() && returnType.equals(mContainerClass)) {
                BugInstance warning2 = new BugInstance(this, "RV_EXCEPTION_NOT_THROWN", 1).addClassAndMethod(this).addMethod(this.callSeen).describe("METHOD_CALLED");
                this.bugAccumulator.accumulateBug(warning2, SourceLineAnnotation.fromVisitedInstruction(this, this.callPC));
            }
        }
        this.state = State.SCAN;
    }

    private boolean isPop(int seen) {
        return seen == 87 || seen == 88;
    }

    static {
        INVOKE_OPCODE_SET.set(185);
        INVOKE_OPCODE_SET.set(183);
        INVOKE_OPCODE_SET.set(184);
        INVOKE_OPCODE_SET.set(182);
        MOCKITO_VOID_STUBBING_METHODS = Set.of("doAnswer", "doCallRealMethod", "doNothing", "doReturn", "doThrow", "verify");
        BDD_MOCKITO_VOID_STUBBING_METHODS = Set.of("then", "willThrow", "willReturn", "willDoNothing", "willCallRealMethod", "willAnswer");
    }

    private static enum State {
        SCAN,
        SAW_INVOKE;

    }
}

